/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.CodeState;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CpuLogCall {
    private final V8ProfileLine.ExecKind myExecKind;
    private final String myFunctionName;
    private final boolean myNative;
    private boolean myNotNavigatable;
    @Nullable
    private final V8ProfileLineFileDescriptor myDescriptor;
    private final String myNotParsedCallable;
    private final CodeState myCodeState;
    private final long myStringId;
    private String myPresentation;

    public V8CpuLogCall(V8ProfileLine.ExecKind execKind, String functionName, boolean aNative, boolean notNavigatable, @Nullable V8ProfileLineFileDescriptor descriptor, String notParsedCallable, CodeState codeState, long stringId) {
        this.myExecKind = execKind;
        this.myFunctionName = functionName;
        this.myNative = aNative;
        this.myNotNavigatable = notNavigatable;
        this.myDescriptor = descriptor;
        this.myNotParsedCallable = notParsedCallable;
        this.myCodeState = codeState;
        this.myStringId = stringId;
        this.setPresentation(this.getPresentation(false));
    }

    public V8CpuLogCall cloneMe() {
        return new V8CpuLogCall(this.myExecKind, this.myFunctionName, this.myNative, this.myNotNavigatable, this.myDescriptor, this.myNotParsedCallable, this.myCodeState, this.myStringId);
    }

    public long getStringId() {
        return this.myStringId;
    }

    public void setNotNavigatable(boolean notNavigatable) {
        this.myNotNavigatable = notNavigatable;
    }

    public V8ProfileLine.ExecKind getExecKind() {
        return this.myExecKind;
    }

    public String getFunctionName() {
        return this.myFunctionName;
    }

    public boolean isNative() {
        return this.myNative;
    }

    public boolean isNotNavigatable() {
        return this.myNotNavigatable;
    }

    public boolean isLocal() {
        return !this.isNative() && !this.isNotNavigatable() && this.getDescriptor() != null && this.getDescriptor().getPath() != null;
    }

    @Nullable
    public V8ProfileLineFileDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public String getNotParsedCallable() {
        return this.myNotParsedCallable;
    }

    public CodeState getCodeState() {
        return this.myCodeState;
    }

    public void setPresentation(String presentation) {
        this.myPresentation = presentation;
    }

    public String getPresentation() {
        return this.myPresentation;
    }

    public String getPresentation(boolean fullPath) {
        return this.getPresentation(fullPath, false);
    }

    public String getPresentation(boolean fullPath, boolean oldStyle) {
        V8ProfileLine.ExecKind kind = this.getExecKind();
        if (V8ProfileLine.ExecKind.unknown.equals((Object)kind)) {
            return this.getNotParsedCallable();
        }
        StringBuilder sb = new StringBuilder();
        V8ProfileLineFileDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            if (oldStyle) {
                sb.append(kind.name()).append(": ");
            }
            sb.append(this.getCodeState().getPrefix());
            String functionName = this.getFunctionName();
            if (!StringUtil.isEmptyOrSpaces((String)functionName)) {
                sb.append(functionName).append(" ");
            }
            if (this.isNative()) {
                sb.append("native ");
            }
            sb.append(fullPath ? descriptor.getLink() : descriptor.getShortLink());
        } else {
            sb.append(this.getNotParsedCallable());
        }
        return sb.toString();
    }

    public static V8CpuLogCall create(@NotNull String line, long stringId) {
        String word;
        String functionName;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8CpuLogCall", "create"));
        }
        String[] split = line.split(" ");
        ArrayDeque<String> parts = new ArrayDeque<String>(Arrays.asList(split));
        if (parts.size() < 2) {
            return V8CpuLogCall.dumb(line, stringId);
        }
        boolean isNative = false;
        V8ProfileLine.ExecKind kind = V8CpuLogCall.parseKind(parts.removeFirst());
        if (kind == null) {
            return V8CpuLogCall.dumb(line, stringId);
        }
        boolean notNavigatable = !V8ProfileLine.ExecKind.Function.equals((Object)kind) && !V8ProfileLine.ExecKind.LazyCompile.equals((Object)kind);
        String functionStr = parts.getFirst();
        CodeState codeState = functionStr.isEmpty() ? CodeState.compiled : V8CpuLogCall.parseCodeState(functionStr.substring(0, 1));
        String string = functionName = CodeState.optimizable.equals((Object)codeState) || CodeState.optimized.equals((Object)codeState) ? functionStr.substring(1) : functionStr;
        if (notNavigatable) {
            word = functionName;
            functionName = "";
        } else {
            parts.removeFirst();
            if (parts.isEmpty()) {
                return new V8CpuLogCall(kind, functionName, false, true, null, "", codeState, stringId);
            }
            word = parts.getFirst();
        }
        if ("native".equals(word)) {
            isNative = true;
            if (parts.isEmpty()) {
                return V8CpuLogCall.dumb(line, stringId);
            }
            parts.removeFirst();
        } else {
            parts.removeFirst();
            parts.addFirst(word);
        }
        String fileStr = StringUtil.join(parts, (String)" ");
        V8ProfileLineFileDescriptor descriptor = V8CpuLogCall.parseFileStr(fileStr, kind);
        if (descriptor == null) {
            return new V8CpuLogCall(kind, functionName, isNative, notNavigatable, null, fileStr, codeState, stringId);
        }
        return new V8CpuLogCall(kind, functionName, isNative, notNavigatable, descriptor, fileStr, codeState, stringId);
    }

    private static V8ProfileLineFileDescriptor parseFileStr(String str, V8ProfileLine.ExecKind kind) {
        if (V8ProfileLine.ExecKind.Script.equals((Object)kind)) {
            return V8CpuLogCall.parsePath(FileUtil.toSystemIndependentName((String)str), -1, -1);
        }
        int idxSecondColon = str.lastIndexOf(":");
        if (idxSecondColon <= 0) {
            return V8CpuLogCall.parsePath(FileUtil.toSystemIndependentName((String)str), -1, -1);
        }
        int idxFirstColon = str.lastIndexOf(":", idxSecondColon - 1);
        if (idxFirstColon <= 0) {
            return null;
        }
        try {
            int line = Integer.parseInt(str.substring(idxFirstColon + 1, idxSecondColon));
            int column = Integer.parseInt(str.substring(idxSecondColon + 1));
            String fileName = str.substring(0, idxFirstColon);
            fileName = FileUtil.toSystemIndependentName((String)fileName);
            return V8CpuLogCall.parsePath(fileName, line, column);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static V8ProfileLineFileDescriptor parsePath(@NotNull String fileName, int line, int column) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8CpuLogCall", "parsePath"));
        }
        String path = null;
        int idx = fileName.lastIndexOf(47);
        if (idx >= 0) {
            path = fileName;
            fileName = fileName.substring(idx + 1);
            return new V8ProfileLineFileDescriptor(fileName, path, line, column);
        }
        return new V8ProfileLineFileDescriptor(fileName, null, line, column);
    }

    private static CodeState parseCodeState(String substring) {
        CodeState state = CodeState.fromStrState(substring);
        return state == null ? CodeState.compiled : state;
    }

    @NotNull
    public static V8CpuLogCall dumb(@NotNull String line, long stringId) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8CpuLogCall", "dumb"));
        }
        V8CpuLogCall v8CpuLogCall = new V8CpuLogCall(V8ProfileLine.ExecKind.unknown, "", true, true, null, line, CodeState.compiled, stringId);
        if (v8CpuLogCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8CpuLogCall", "dumb"));
        }
        return v8CpuLogCall;
    }

    private static V8ProfileLine.ExecKind parseKind(String s) {
        if (!s.endsWith(":")) {
            return null;
        }
        return V8ProfileLine.ExecKind.safeValueOf(s.substring(0, s.length() - 1));
    }

    public Navigatable[] getNavigatables(Project project) {
        return this.myDescriptor == null ? null : this.myDescriptor.getNavigatables(project, this.myFunctionName, this.myNative);
    }

    public String getShort() {
        String link;
        if (V8ProfileLine.ExecKind.unknown.equals((Object)this.getExecKind())) {
            return this.getNotParsedCallable();
        }
        String string = link = this.myDescriptor == null ? this.myNotParsedCallable : this.myDescriptor.getShortLink();
        if (StringUtil.isEmptyOrSpaces((String)this.myFunctionName)) {
            return link + " (" + this.myExecKind.name() + ")";
        }
        return this.myFunctionName + " " + link;
    }
}

