/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PieChartDiagram<T>
extends JPanel {
    private static final int SPACE = 1;
    private final int myHeight;
    private double myHoleCoeff;
    private int myStartAngle;
    @NotNull
    private final List<T> myData;
    @NotNull
    private final Convertor<T, Integer> myDataConvertor;
    @NotNull
    private final Convertor<T, JBColor> myColorConvertor;

    public PieChartDiagram(int height, @NotNull List<T> data, @NotNull Convertor<T, Integer> dataConvertor, @NotNull Convertor<T, JBColor> colorConvertor) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/run/profile/cpu/view/PieChartDiagram", "<init>"));
        }
        if (dataConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataConvertor", "com/jetbrains/nodejs/run/profile/cpu/view/PieChartDiagram", "<init>"));
        }
        if (colorConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorConvertor", "com/jetbrains/nodejs/run/profile/cpu/view/PieChartDiagram", "<init>"));
        }
        this.myHoleCoeff = 0.75;
        this.myStartAngle = 135;
        this.myHeight = height;
        this.myData = data;
        this.myDataConvertor = dataConvertor;
        this.myColorConvertor = colorConvertor;
    }

    public PieChartDiagram<T> withHoleCoeff(double holeCoeff) {
        if (holeCoeff > 0.0 && holeCoeff < 1.0) {
            this.myHoleCoeff = holeCoeff;
        }
        return this;
    }

    public PieChartDiagram<T> withStartAngle(int startAngle) {
        this.myStartAngle = startAngle;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.myHeight + 4, this.myHeight + 4);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        V8Utils.safeDraw((Graphics2D)g, (Consumer<Graphics2D>)((Consumer)graphics2D -> {
            graphics2D.translate(2, 2);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double coeff = (360.0 - (double)(this.myData.size() * 1)) / 1000.0;
            int inner = (int)((double)this.myHeight * this.myHoleCoeff);
            int innerCenter = (int)(0.5 * (double)this.myHeight * (1.0 - this.myHoleCoeff));
            int startAngle = this.myStartAngle;
            Color border1 = UIUtil.isUnderDarcula() ? UIUtil.getPanelBackground().brighter() : UIUtil.getPanelBackground().darker();
            graphics2D.setColor(border1);
            graphics2D.fillArc(0, 0, this.myHeight, this.myHeight, 0, 360);
            for (T line : this.myData) {
                int angleDiff = (int)Math.round(coeff * (double)((Integer)this.myDataConvertor.convert(line)).intValue());
                graphics2D.setColor((Color)this.myColorConvertor.convert(line));
                graphics2D.fillArc(0, 0, this.myHeight, this.myHeight, startAngle, -angleDiff);
                graphics2D.setColor(UIUtil.getPanelBackground());
                startAngle -= angleDiff + 1;
            }
            graphics2D.fillArc(innerCenter, innerCenter, inner, inner, 0, 360);
            graphics2D.setColor(border1);
            graphics2D.drawArc(0, 0, this.myHeight, this.myHeight, 0, 360);
            graphics2D.drawArc(innerCenter, innerCenter, inner, inner, 0, 360);
        }));
    }
}

