/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class CompositeCloseable
implements Closeable {
    private final Logger LOG = Logger.getInstance(CompositeCloseable.class);
    private final List<Closeable> myList = new ArrayList<Closeable>();
    private Closeable myVeryLast;
    private final AtomicBoolean myDisposeStarted = new AtomicBoolean(false);

    public <T extends Closeable> T register(@NotNull T closeable) {
        if (closeable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeable", "com/jetbrains/nodejs/run/profile/heap/CompositeCloseable", "register"));
        }
        this.myList.add(closeable);
        return closeable;
    }

    @Override
    public void close() throws IOException {
        this.myDisposeStarted.set(true);
        for (Closeable closeable : this.myList) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.LOG.info((Throwable)e);
            }
        }
        if (this.myVeryLast != null) {
            this.myVeryLast.close();
        }
    }

    public <T extends Closeable> void closeAndRemove(@NotNull T closeable) {
        if (closeable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeable", "com/jetbrains/nodejs/run/profile/heap/CompositeCloseable", "closeAndRemove"));
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.LOG.info((Throwable)e);
        }
        this.myList.remove(closeable);
    }

    public <T extends Closeable> T setVeryLast(T veryLast) {
        this.myVeryLast = veryLast;
        return veryLast;
    }

    public boolean isDisposeStarted() {
        return this.myDisposeStarted.get();
    }
}

