/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFiles<T>
implements IndexFiles<T> {
    private final List<File> myFiles;
    @NotNull
    private final String myPrefix;

    public TempFiles(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/run/profile/heap/TempFiles", "<init>"));
        }
        this.myPrefix = prefix;
        this.myFiles = new ArrayList<File>();
    }

    @Override
    public File generate(@NotNull T category, @Nullable String postfix) throws IOException {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/nodejs/run/profile/heap/TempFiles", "generate"));
        }
        File file = FileUtil.createTempFile((String)this.myPrefix, (String)postfix, (boolean)true);
        this.myFiles.add(file);
        return file;
    }

    @Override
    public void close() throws IOException {
        for (File file : this.myFiles) {
            FileUtil.delete((File)file);
        }
    }
}

