/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.ReverseLinkIndexProcessor;
import com.jetbrains.nodejs.run.profile.heap.calculation.StringReverseIndexProcessor;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ReverseIndexes
implements Closeable {
    private final ReverseLinkIndexProcessor myReverseLinkIndexProcessor;
    private final StringReverseIndexProcessor myReverseStringIndexProcessor;
    private final long myNodesCnt;

    /*
     * WARNING - void declaration
     */
    public ReverseIndexes(long nodesCnt, @NotNull IndexFiles indexFiles, File file) throws IOException {
        void nodeIndex;
        if (indexFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexFiles", "com/jetbrains/nodejs/run/profile/heap/calculation/ReverseIndexes", "<init>"));
        }
        this.myNodesCnt = nodesCnt;
        this.myReverseLinkIndexProcessor = new ReverseLinkIndexProcessor(nodesCnt, indexFiles);
        this.myReverseStringIndexProcessor = new StringReverseIndexProcessor(indexFiles, (File)nodeIndex);
    }

    public void continueCalculation(@NotNull File edgeIndexFile, long numEdges) throws IOException {
        if (edgeIndexFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeIndexFile", "com/jetbrains/nodejs/run/profile/heap/calculation/ReverseIndexes", "continueCalculation"));
        }
        this.myReverseStringIndexProcessor.continueCalculation(edgeIndexFile, numEdges, this.myNodesCnt);
        this.myReverseStringIndexProcessor.close();
        this.myReverseLinkIndexProcessor.continueCalculation(edgeIndexFile, numEdges, this.myNodesCnt);
        this.myReverseLinkIndexProcessor.close();
    }

    public CloseableThrowableConsumer<V8HeapEntry, IOException> getNodesFirstStageCalculator() {
        return this.myReverseStringIndexProcessor.getNodesFirstStageCalculator();
    }

    public CloseableThrowableConsumer<V8HeapEdge, IOException> getEdgesFirstStageCalculator() {
        final CloseableThrowableConsumer<V8HeapEdge, IOException> edgeCalculator = this.myReverseLinkIndexProcessor.getFirstStageCalculator();
        final CloseableThrowableConsumer<V8HeapEdge, IOException> reverseStringCalculator = this.myReverseStringIndexProcessor.getFirstStageCalculator();
        return new CloseableThrowableConsumer<V8HeapEdge, IOException>(){

            @Override
            public void close() throws IOException {
                edgeCalculator.close();
                reverseStringCalculator.close();
            }

            public void consume(V8HeapEdge edge) throws IOException {
                edgeCalculator.consume(edge);
                reverseStringCalculator.consume(edge);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.myReverseLinkIndexProcessor.close();
        this.myReverseStringIndexProcessor.close();
    }

    public void correctStringsSize(long cnt) {
        this.myReverseStringIndexProcessor.correctSize(cnt);
    }

    public LinksReaderFactory<LinkedByNameId> getReverseStringIndexProcessor() throws FileNotFoundException {
        return this.myReverseStringIndexProcessor.getLinksReaderFactory();
    }

    public LinksReaderFactory<V8HeapEdge> getReverseLinkIndexProcessor() throws FileNotFoundException {
        return this.myReverseLinkIndexProcessor.getLinksReaderFactory();
    }
}

