/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.containers.Convertor;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.EdgeProcessor;
import com.jetbrains.nodejs.run.profile.heap.calculation.ProcessInPortions;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ReverseLinkIndexProcessor
implements EdgeProcessor {
    private static final int BOUND = 500000;
    private final ProcessInPortions<V8HeapEdge, V8HeapEdge> myDelegate;
    private TIntArrayList myReverseNum;

    /*
     * WARNING - void declaration
     */
    public ReverseLinkIndexProcessor(long nodesCnt, @NotNull IndexFiles indexFiles) throws IOException {
        void indexFiles2;
        if (indexFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexFiles", "com/jetbrains/nodejs/run/profile/heap/calculation/ReverseLinkIndexProcessor", "<init>"));
        }
        this.myReverseNum = new TIntArrayList();
        int i = 0;
        while ((long)i < nodesCnt) {
            this.myReverseNum.add(0);
            ++i;
        }
        this.myDelegate = new ProcessInPortions<V8HeapEdge, V8HeapEdge>(nodesCnt, -1L, V8HeapEdge.MyRawSerializer.getInstance(), V8HeapEdge.MyRawSerializer.getInstance(), new Convertor<V8HeapEdge, Long>(){

            public Long convert(V8HeapEdge o) {
                return o.getToIndex();
            }
        }, (Convertor<V8HeapEdge, V8HeapEdge>)Convertor.SELF, indexFiles2.generate(V8HeapIndexManager.Category.reverseNumLinks, ".num.index"), indexFiles2.generate(V8HeapIndexManager.Category.reverseLinks, ".index"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void continueCalculation(@NotNull File edgeIndexFile, long numEdges, long l) throws IOException {
        void nodesCnt;
        if (edgeIndexFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeIndexFile", "com/jetbrains/nodejs/run/profile/heap/calculation/ReverseLinkIndexProcessor", "continueCalculation"));
        }
        int from = 0;
        while ((long)from < nodesCnt) {
            int cnt = 0;
            int i = from;
            while ((long)i < nodesCnt && cnt < 500000) {
                cnt += this.myReverseNum.get(i);
                ++i;
            }
            int to = i - 1;
            to = to - from < 0 ? from : to;
            new SequentialRawReader<V8HeapEdge>(edgeIndexFile, V8HeapEdge.MyRawSerializer.getInstance(), numEdges).iterate(this.myDelegate.getStageCalculator(from, to));
            from = to + 1;
        }
        this.myReverseNum = null;
    }

    @Override
    public CloseableThrowableConsumer<V8HeapEdge, IOException> getFirstStageCalculator() {
        return new CloseableThrowableConsumer<V8HeapEdge, IOException>(){

            @Override
            public void close() throws IOException {
            }

            public void consume(V8HeapEdge edge) throws IOException {
                ReverseLinkIndexProcessor.this.myReverseNum.set((int)edge.getToIndex(), ReverseLinkIndexProcessor.this.myReverseNum.get((int)edge.getToIndex()) + 1);
            }
        };
    }

    public File getReverseLinksFile() {
        return this.myDelegate.getLinksFile();
    }

    public File getNumReverseLinksFile() {
        return this.myDelegate.getNumLinksFile();
    }

    public LinksReaderFactory<V8HeapEdge> getLinksReaderFactory() throws FileNotFoundException {
        return this.myDelegate.getLinksReaderFactory();
    }

    @Override
    public void close() throws IOException {
        this.myDelegate.close();
    }
}

