/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.TempFiles;
import com.jetbrains.nodejs.run.profile.heap.TimeReporter;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.HeapSnapshotListener;
import com.jetbrains.nodejs.run.profile.heap.calculation.HeapSnapshotReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.RetainedSizeCalculator;
import com.jetbrains.nodejs.run.profile.heap.calculation.ReverseIndexes;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8StringIndex;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class V8HeapProcessor
implements Disposable {
    public static final Logger LOG = Logger.getInstance((String)"#V8.Heap.Analysis");
    private final File myFile;
    private final TimeReporter myReporter;
    @NotNull
    private final Consumer<String> myErrorNotificator;
    private File myNodeIndex;
    private File myEdgeIndex;
    private V8HeapHeader myHeader;
    private ReverseIndexes myReverseIndexes;
    private V8StringIndex myStringIndex;
    private long myStringsCnt;
    private V8CachingReader myCachingReader;
    private final CompositeCloseable myResourses;
    private RetainedSizeCalculator myRetainedSizeCalculator;
    private final boolean myShowHidden;
    private V8ImportantStringsHolder myStringsHolder;
    private V8HeapIndexManager myManager;

    public V8HeapProcessor(@NotNull Consumer<String> errorNotificator, File file, boolean showHidden, ProgressIndicator indicator) throws IOException {
        if (errorNotificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorNotificator", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor", "<init>"));
        }
        this.myErrorNotificator = errorNotificator;
        this.myShowHidden = showHidden;
        this.myReporter = new TimeReporter("Heap processing", indicator);
        this.myFile = file;
        this.myResourses = new CompositeCloseable();
        if (this.myFile.getParentFile() == null) {
            throw new IOException("Can not create temp index files.");
        }
        this.myManager = new V8HeapIndexManager(this.myFile, this.myShowHidden);
    }

    public ByteArrayWrapper getDigest() {
        return this.myManager.getDigest();
    }

    public V8CachingReader getFromCacheOrProcess() throws IOException, ClassNotFoundException {
        V8CachingReader reader;
        if (this.myManager.isInitialized() && (reader = this.myManager.initReader(this.myResourses, this.myErrorNotificator)) != null) {
            return reader;
        }
        reader = this.processSnapshot(this.myManager.getDigest(), true, this.myManager.getIndexFiles());
        this.myManager.recordReader(reader);
        return reader;
    }

    public V8CachingReader processSnapshot(@NotNull ByteArrayWrapper digest) throws IOException {
        if (digest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "digest", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor", "processSnapshot"));
        }
        return this.processSnapshot(digest, true, this.myResourses.setVeryLast(new TempFiles(this.myFile.getName())));
    }

    public V8CachingReader processSnapshot(@NotNull ByteArrayWrapper digest, boolean calculateRetainedSizes) throws IOException {
        if (digest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "digest", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor", "processSnapshot"));
        }
        return this.processSnapshot(digest, calculateRetainedSizes, this.myResourses.setVeryLast(new TempFiles(this.myFile.getName())));
    }

    public V8CachingReader processSnapshot(@NotNull ByteArrayWrapper digest, boolean calculateRetainedSizes, IndexFiles indexFiles) throws IOException {
        if (digest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "digest", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor", "processSnapshot"));
        }
        try {
            this.myNodeIndex = indexFiles.generate(V8HeapIndexManager.Category.nodeIdx, ".node.index");
            this.myEdgeIndex = indexFiles.generate(V8HeapIndexManager.Category.edgeIdx, ".edge.index");
            this.myStringIndex = this.myResourses.register(new V8StringIndex(indexFiles));
            this.plainRead(indexFiles);
            this.myReverseIndexes.continueCalculation(this.myEdgeIndex, this.myHeader.getEdgesCnt());
            this.myReporter.reportStage("Reverse indexes calculated");
            this.myResourses.closeAndRemove(this.myReverseIndexes);
            this.myCachingReader = new V8CachingReader(this.myFile, digest, this.myResourses, this.myHeader, this.myErrorNotificator, this.myStringIndex, this.myNodeIndex, this.myEdgeIndex, this.myReverseIndexes.getReverseStringIndexProcessor(), this.myReverseIndexes.getReverseLinkIndexProcessor(), this.myStringsHolder);
            if (calculateRetainedSizes) {
                this.myRetainedSizeCalculator = this.myResourses.register(new RetainedSizeCalculator(this.myHeader.getNodesCnt(), this.myShowHidden));
                this.myRetainedSizeCalculator.execute(this.myCachingReader, this.myReverseIndexes.getReverseLinkIndexProcessor(), this.myNodeIndex, indexFiles, this.myStringsHolder);
                this.myCachingReader.setInMemoryIndexes(this.myRetainedSizeCalculator.getInMemoryIndexes());
                this.myCachingReader.setAggregatesLinksReaderFactory(this.myRetainedSizeCalculator.getAggregatesLinksReaderFactory());
                this.myCachingReader.resortChildren();
                this.myResourses.closeAndRemove(this.myRetainedSizeCalculator);
                this.myRetainedSizeCalculator = null;
            }
            this.myReporter.reportStage("Retained sizes ready");
            this.myReporter.reportTotal();
            if (!this.myShowHidden) {
                this.myCachingReader.resetDoNotShowHidden();
            }
            return this.myCachingReader;
        }
        catch (IOException e) {
            this.myResourses.close();
            throw e;
        }
        catch (Throwable th) {
            this.myResourses.close();
            throw new RuntimeException(th);
        }
    }

    private void plainRead(IndexFiles indexFiles) throws IOException {
        HeapSnapshotReader reader = this.myResourses.register(new HeapSnapshotReader(this.myFile));
        this.myHeader = reader.readHeader();
        this.myReverseIndexes = this.myResourses.register(new ReverseIndexes(this.myHeader.getNodesCnt(), indexFiles, this.myNodeIndex));
        ReaderListener listener = this.myResourses.register(new ReaderListener(this.myNodeIndex, this.myEdgeIndex, this.myReverseIndexes, this.myStringIndex, this.myHeader));
        reader.readWithReader(listener);
        this.myResourses.closeAndRemove(listener);
        this.myResourses.closeAndRemove(reader);
        this.myStringsCnt = listener.getStringsCnt();
        this.myStringsHolder = listener.getStringsHolder();
        this.myStringIndex.startReading();
        this.myReporter.reportStage("Read file, wrote indexes");
    }

    public long getStringsCnt() {
        return this.myStringsCnt;
    }

    public V8ImportantStringsHolder getStringsHolder() {
        return this.myStringsHolder;
    }

    public V8HeapHeader getHeader() {
        return this.myHeader;
    }

    public void dispose() {
        try {
            this.myResourses.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ReaderListener
    implements HeapSnapshotListener,
    Closeable {
        private final V8ImportantStringsHolder myStringsHolder;
        private long myEdgesOff;
        private long myStringsCnt;
        @NotNull
        private final File myNodeIndexFile;
        @NotNull
        private final File myEdgeIndexFile;
        private SequentialRawWriter<V8HeapEntry> myNodeWriter;
        private EdgeIndexCreator myEdgeIndexCreator;
        @NotNull
        private final ReverseIndexes myProcessor;
        @NotNull
        private final V8StringIndex myStringIndex;
        private final V8HeapHeader myHeader;
        private CloseableThrowableConsumer<V8HeapEdge, IOException> myEdgesFirstStageCalculator;
        private CloseableThrowableConsumer<V8HeapEntry, IOException> myNodesFirstStageCalculator;

        public ReaderListener(@NotNull File nodeIndexFile, @NotNull File edgeIndexFile, @NotNull ReverseIndexes processor, @NotNull V8StringIndex stringIndex, V8HeapHeader header) throws FileNotFoundException {
            if (nodeIndexFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndexFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "<init>"));
            }
            if (edgeIndexFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeIndexFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "<init>"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "<init>"));
            }
            if (stringIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringIndex", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "<init>"));
            }
            this.myNodeIndexFile = nodeIndexFile;
            this.myEdgeIndexFile = edgeIndexFile;
            this.myProcessor = processor;
            this.myStringIndex = stringIndex;
            this.myHeader = header;
            this.myEdgesOff = 0L;
            this.myNodeWriter = new SequentialRawWriter<V8HeapEntry>(this.myNodeIndexFile, V8HeapEntry.MyRawSerializer.getInstance());
            this.myNodesFirstStageCalculator = this.myProcessor.getNodesFirstStageCalculator();
            this.myStringsHolder = new V8ImportantStringsHolder();
        }

        @Override
        public void allNodesRead() throws IOException {
            this.myNodeWriter.close();
            this.myEdgeIndexCreator = new EdgeIndexCreator(this.myNodeIndexFile, this.myEdgeIndexFile, this.myHeader.getNodesCnt());
            this.myEdgesFirstStageCalculator = this.myProcessor.getEdgesFirstStageCalculator();
        }

        @Override
        public void allEdgesRead() {
            this.myEdgeIndexCreator.close();
        }

        @Override
        public void stringsCount(long cnt) {
            this.myProcessor.correctStringsSize(cnt);
            this.myStringsCnt = cnt;
        }

        @Override
        public void accept(@NotNull V8HeapEntry node) throws IOException {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "accept"));
            }
            node.setEdgesOffset(this.myEdgesOff);
            this.myNodesFirstStageCalculator.consume(node);
            this.myNodeWriter.write(node);
            this.myEdgesOff += node.getChildrenCount();
        }

        @Override
        public void accept(@NotNull V8HeapEdge edge) throws IOException {
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "accept"));
            }
            this.myEdgeIndexCreator.adjust(edge);
            this.myEdgesFirstStageCalculator.consume(edge);
            this.myEdgeIndexCreator.serialize(edge);
        }

        @Override
        public void accept(@NotNull String name) throws IOException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener", "accept"));
            }
            long id = this.myStringIndex.addString(name);
            this.myStringsHolder.accept(id, name);
        }

        @Override
        public void close() throws IOException {
            this.myStringsHolder.onFinish();
            if (this.myNodeWriter != null) {
                this.myNodeWriter.close();
            }
            if (this.myEdgeIndexCreator != null) {
                this.myEdgeIndexCreator.close();
            }
            if (this.myEdgesFirstStageCalculator != null) {
                this.myEdgesFirstStageCalculator.close();
            }
            if (this.myNodesFirstStageCalculator != null) {
                this.myNodesFirstStageCalculator.close();
            }
        }

        public long getStringsCnt() {
            return this.myStringsCnt;
        }

        public V8ImportantStringsHolder getStringsHolder() {
            return this.myStringsHolder;
        }
    }

    private static class EdgeIndexCreator {
        private SequentialRawWriter<V8HeapEdge> myEdgeWriter;
        private long myEdgeIdx;
        private long myNodeIdx;
        private V8HeapEntry myNode;
        private SequentialRawReader<V8HeapEntry> myNodesReader;

        public EdgeIndexCreator(@NotNull File nodeIndexFile, @NotNull File edgeIndexFile, long nodesCnt) throws IOException {
            if (nodeIndexFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndexFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$EdgeIndexCreator", "<init>"));
            }
            if (edgeIndexFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeIndexFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$EdgeIndexCreator", "<init>"));
            }
            this.myEdgeWriter = new SequentialRawWriter<V8HeapEdge>(edgeIndexFile, V8HeapEdge.MyRawSerializer.getInstance());
            this.myNodesReader = new SequentialRawReader<V8HeapEntry>(nodeIndexFile, V8HeapEntry.MyRawSerializer.getInstance(), nodesCnt);
            this.myEdgeIdx = 0L;
            this.myNodeIdx = 0L;
            this.myNode = this.myNodesReader.read();
        }

        public void adjust(@NotNull V8HeapEdge edge) throws IOException {
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$EdgeIndexCreator", "adjust"));
            }
            while (this.myEdgeIdx == this.myNode.getEdgesOffset() + this.myNode.getChildrenCount()) {
                this.myNode = this.myNodesReader.read();
                ++this.myNodeIdx;
            }
            edge.setFromIndex(this.myNodeIdx);
        }

        public void serialize(@NotNull V8HeapEdge edge) throws IOException {
            if (edge == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$EdgeIndexCreator", "serialize"));
            }
            this.myEdgeWriter.write(edge);
            ++this.myEdgeIdx;
        }

        public void close() {
            this.myEdgeWriter.close();
            this.myNodesReader.close();
        }
    }
}

