/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregatesViewDiff {
    private final List<AggregateDifference> myDiffMap = new ArrayList<AggregateDifference>();

    public void addAggregate(@NotNull AggregateDifference difference) {
        if (difference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "difference", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/AggregatesViewDiff", "addAggregate"));
        }
        this.myDiffMap.add(difference);
    }

    public List<AggregateDifference> getList() {
        return this.myDiffMap;
    }

    public static class AggregateDifference {
        private final String myClassName;
        private final V8HeapNodeType myType;
        @Nullable
        private final Aggregate myBase;
        @Nullable
        private final Aggregate myChanged;
        private int myAddedCnt;
        private int myRemovedCnt;
        private long myAddedSize;
        private long myRemovedSize;

        public AggregateDifference(String className, V8HeapNodeType type, @Nullable Aggregate base, @Nullable Aggregate changed) {
            assert (base != null || changed != null);
            this.myClassName = className;
            this.myType = type;
            this.myBase = base;
            this.myChanged = changed;
            if (base == null) {
                this.myAddedCnt = changed.getCnt();
                this.myAddedSize = changed.getSelfSize();
                this.myRemovedCnt = 0;
                this.myRemovedSize = 0L;
            }
            if (changed == null) {
                this.myAddedCnt = 0;
                this.myAddedSize = 0L;
                this.myRemovedCnt = base.getCnt();
                this.myRemovedSize = base.getSelfSize();
            }
        }

        public boolean isSystem() {
            return this.myBase == null ? this.myChanged.getClassIdx() < 0L : this.myBase.getClassIdx() < 0L;
        }

        public int getAddedCnt() {
            return this.myAddedCnt;
        }

        public void setAddedCnt(int addedCnt) {
            this.myAddedCnt = addedCnt;
        }

        public int getRemovedCnt() {
            return this.myRemovedCnt;
        }

        public void setRemovedCnt(int removedCnt) {
            this.myRemovedCnt = removedCnt;
        }

        public long getAddedSize() {
            return this.myAddedSize;
        }

        public void setAddedSize(long addedSize) {
            this.myAddedSize = addedSize;
        }

        public long getRemovedSize() {
            return this.myRemovedSize;
        }

        public void setRemovedSize(long removedSize) {
            this.myRemovedSize = removedSize;
        }

        public String getClassIdx() {
            return this.myClassName;
        }

        public V8HeapNodeType getType() {
            return this.myType;
        }

        @Nullable
        public Aggregate getBase() {
            return this.myBase;
        }

        @Nullable
        public Aggregate getChanged() {
            return this.myChanged;
        }

        public long selfSizeDiff() {
            return this.myBase == null ? this.myChanged.getSelfSize() : (this.myChanged == null ? -this.myBase.getSelfSize() : this.myChanged.getSelfSize() - this.myBase.getSelfSize());
        }

        public int selfSizePercent() {
            if (this.myChanged == null) {
                return -1;
            }
            if (this.myBase == null) {
                return -1;
            }
            long delta = this.selfSizeDiff();
            double val = (double)delta / (double)this.myChanged.getSelfSize() * 100.0;
            return (int)Math.round(val);
        }

        public int objectsPercent() {
            if (this.myChanged == null) {
                return -1;
            }
            if (this.myBase == null) {
                return -1;
            }
            long delta = this.objectsDiff();
            double val = (double)delta / (double)this.myChanged.getCnt() * 100.0;
            return (int)Math.round(val);
        }

        public long objectsDiff() {
            return this.myBase == null ? (long)this.myChanged.getCnt() : (long)(this.myChanged == null ? -this.myBase.getCnt() : this.myChanged.getCnt() - this.myBase.getCnt());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregateDifference that = (AggregateDifference)o;
            if (this.myClassName != null ? !this.myClassName.equals(that.myClassName) : that.myClassName != null) {
                return false;
            }
            return this.myType == that.myType;
        }

        public int hashCode() {
            int result = this.myClassName != null ? this.myClassName.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            return result;
        }

        public boolean somethingChanged() {
            return this.myAddedCnt > 0 || this.myAddedSize > 0L || this.myRemovedCnt > 0 || this.myRemovedSize > 0L;
        }
    }
}

