/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.Convertor;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregateDifferenceEmphasizer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.BiggestObjectsDiffTableModel;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.DiffCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.MarkUnmarkDiffAction;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.NavigateInSourceSnapshotAction;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8HeapSummaryDiffComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class V8HeapBiggestObjectsDiffComponent
implements ProfilingView<V8HeapTreeTable> {
    private final V8HeapTreeTable myTable;
    private final Project myProject;
    private final V8DiffCachingReader myReader;
    private final String myBaseName;
    private final String myChangedName;

    public V8HeapBiggestObjectsDiffComponent(Project project, V8DiffCachingReader reader, String baseName, String changedName) {
        this.myProject = project;
        this.myReader = reader;
        this.myBaseName = baseName;
        this.myChangedName = changedName;
        this.myTable = new V8HeapTreeTable((TreeTableModel)new BiggestObjectsDiffTableModel(project, reader), reader.getResourses());
        TreeTableSpeedSearch search = new TreeTableSpeedSearch((TreeTable)this.myTable, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                Object component = o.getLastPathComponent();
                if (component instanceof BeforeAfter) {
                    BeforeAfter beforeAfter = (BeforeAfter)component;
                    if (beforeAfter.getAfter() != null) {
                        return ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getName();
                    }
                    return ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getName();
                }
                return component.toString();
            }
        });
        search.setComparator(new SpeedSearchComparator(false, true));
        String sample = String.valueOf(reader.getChangedReader().getRetainedSize(0)) + " 100% a b";
        V8Utils.afterModelReset(this.myTable, sample, reader.getResourses(), (TreeCellRenderer)((Object)new DiffCellRenderer(project, reader.getBaseReader(), reader.getChangedReader(), AggregateDifferenceEmphasizer.getInstance())));
    }

    @Override
    public JComponent getMainComponent() {
        DataProviderPanel panel = DataProviderPanel.wrap((JComponent)new JBScrollPane((Component)((Object)this.myTable)));
        panel.register(V8HeapSummaryDiffComponent.SELECTED_PAIR.getName(), (Getter<Object>)((Getter)() -> {
            TreePath value = this.myTable.getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof BeforeAfter) {
                return value.getLastPathComponent();
            }
            return null;
        }));
        return panel;
    }

    @Override
    public String getName() {
        return "Biggest Objects Diff";
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        MarkUnmarkDiffAction markUnmarkDiffAction = new MarkUnmarkDiffAction(this.myProject, this.myBaseName, this.myChangedName, this.myReader.getBaseReader().getDigest(), this.myReader.getChangedReader().getDigest());
        NavigateInSourceSnapshotAction navigateInSourceSnapshotAction = new NavigateInSourceSnapshotAction(this.myProject, this.myBaseName, this.myChangedName, this.myReader.getBaseReader().getDigest(), this.myReader.getChangedReader().getDigest());
        group.add((AnAction)markUnmarkDiffAction);
        group.add((AnAction)navigateInSourceSnapshotAction);
        DefaultActionGroup popupGroup = new DefaultActionGroup();
        popupGroup.add((AnAction)markUnmarkDiffAction);
        popupGroup.add((AnAction)navigateInSourceSnapshotAction);
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTable), (ActionGroup)popupGroup, (String)"V8_HEAP_DIFF_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8HeapTreeTable getTreeTable() {
        return this.myTable;
    }

    @Override
    public void defaultExpand() {
    }
}

