/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.jetbrains.nodejs.run.profile.heap.io.Positioned;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jetbrains.annotations.NotNull;

public class RandomRawWriter<T extends Positioned>
implements Closeable {
    @NotNull
    private final RawSerializer<T> mySerializer;
    private final RandomAccessFile myRandomAccessFile;

    public RandomRawWriter(@NotNull File file, @NotNull RawSerializer<T> serializer) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/run/profile/heap/io/RandomRawWriter", "<init>"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/jetbrains/nodejs/run/profile/heap/io/RandomRawWriter", "<init>"));
        }
        this.mySerializer = serializer;
        this.myRandomAccessFile = new RandomAccessFile(file, "rw");
    }

    public void write(T t) throws IOException {
        this.myRandomAccessFile.seek(t.getOffset());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(out);
        this.mySerializer.write(stream, t);
        this.myRandomAccessFile.write(out.toByteArray());
    }

    @Override
    public void close() throws IOException {
        this.myRandomAccessFile.close();
    }
}

