/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.intellij.openapi.util.Pair;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RawLongLongSerializer
implements RawSerializer<Pair<Long, Long>> {
    private static final RawLongLongSerializer ourInstance = new RawLongLongSerializer();

    public static RawLongLongSerializer getInstance() {
        return ourInstance;
    }

    @Override
    public long getRecordSize() {
        return 16L;
    }

    @Override
    public void write(@NotNull DataOutput os, @NotNull Pair<Long, Long> pair) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/jetbrains/nodejs/run/profile/heap/io/RawLongLongSerializer", "write"));
        }
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/jetbrains/nodejs/run/profile/heap/io/RawLongLongSerializer", "write"));
        }
        RawSerializer.Helper.serializeLong((Long)pair.getFirst(), os);
        RawSerializer.Helper.serializeLong((Long)pair.getSecond(), os);
    }

    @Override
    public Pair<Long, Long> read(@NotNull DataInput is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/jetbrains/nodejs/run/profile/heap/io/RawLongLongSerializer", "read"));
        }
        return Pair.create((Object)RawSerializer.Helper.deserializeLong(is), (Object)RawSerializer.Helper.deserializeLong(is));
    }
}

