/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public interface RawSerializer<T> {
    public long getRecordSize();

    public void write(@NotNull DataOutput var1, @NotNull T var2) throws IOException;

    public T read(@NotNull DataInput var1) throws IOException;

    public static class Helper {
        public static void serializeInt(int value, @NotNull DataOutput dout) throws IOException {
            if (dout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dout", "com/jetbrains/nodejs/run/profile/heap/io/RawSerializer$Helper", "serializeInt"));
            }
            int off = 0;
            for (int i = 0; i < 4; ++i) {
                dout.writeByte(value >> off & 0xFF);
                off += 8;
            }
        }

        public static int deserializeInt(@NotNull DataInput din) throws IOException {
            if (din == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "din", "com/jetbrains/nodejs/run/profile/heap/io/RawSerializer$Helper", "deserializeInt"));
            }
            int result = 0;
            int off = 0;
            for (int i = 0; i < 4; ++i) {
                result |= (din.readByte() & 0xFF) << off;
                off += 8;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public static void serializeLong(long value, @NotNull DataOutput dataOutput) throws IOException {
            if (dataOutput == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dout", "com/jetbrains/nodejs/run/profile/heap/io/RawSerializer$Helper", "serializeLong"));
            }
            int off = 0;
            for (int i = 0; i < 8; ++i) {
                void dout;
                dout.writeByte((byte)(value >> off & 0xFFL));
                off += 8;
            }
        }

        public static long deserializeLong(@NotNull DataInput din) throws IOException {
            if (din == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "din", "com/jetbrains/nodejs/run/profile/heap/io/RawSerializer$Helper", "deserializeLong"));
            }
            long result = 0L;
            int off = 0;
            for (int i = 0; i < 8; ++i) {
                result |= (long)(din.readByte() & 0xFF) << off;
                off += 8;
            }
            return result;
        }
    }
}

