/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.SearchDialog;
import com.jetbrains.nodejs.run.profile.heap.view.models.RetainersTreeModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.SearchDetailsTreeModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class SearchResultsTreeModelFactory {
    private static final Object TARGETS = new Object();
    private static final Object FOUND = new Object();
    private static final Object TARGETS_CONTENTS = new Object();
    private static final Comparator<String> BY_TYPE_COMPARATOR = SearchResultsTreeModelFactory.createByTypeComparator();
    private final Project myProject;
    @NotNull
    private final String myText;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final Map<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> myMap;
    private final boolean mySearchEverywhereSelected;
    private final Comparator<String> myComparator;
    private String myTarget;

    public SearchResultsTreeModelFactory(Project project, @NotNull String text, @NotNull V8CachingReader reader, @NotNull Map<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> map, boolean searchEverywhereSelected) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchResultsTreeModelFactory", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchResultsTreeModelFactory", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchResultsTreeModelFactory", "<init>"));
        }
        this.myProject = project;
        this.myText = text;
        this.myReader = reader;
        this.myMap = new HashMap<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>>();
        for (Map.Entry<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> entry : map.entrySet()) {
            this.myMap.put(entry.getKey().replace("&", ""), entry.getValue());
        }
        this.mySearchEverywhereSelected = searchEverywhereSelected;
        this.myComparator = this.createComparator();
    }

    @NotNull
    private static Comparator<String> createByTypeComparator() {
        HashMap<String, Integer> rank = new HashMap<String, Integer>();
        for (String option : SearchDialog.OPTIONS) {
            rank.put(option.replace("&", ""), rank.size());
        }
        Comparator comparator = (o1, o2) -> Comparing.compare((Comparable)((Comparable)rank.get(o1)), (Comparable)((Comparable)rank.get(o2)));
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchResultsTreeModelFactory", "createByTypeComparator"));
        }
        return comparator;
    }

    @NotNull
    private Comparator<String> createComparator() {
        Comparator comparator = (o1, o2) -> {
            boolean exact1 = o1.equalsIgnoreCase(this.myText);
            boolean exact2 = o2.equalsIgnoreCase(this.myText);
            if (exact1 && exact2) {
                return o1.compareTo((String)o2);
            }
            if (exact1) {
                return -1;
            }
            if (exact2) {
                return 1;
            }
            return o1.compareTo((String)o2);
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchResultsTreeModelFactory", "createComparator"));
        }
        return comparator;
    }

    private ColumnInfo[] createColumns(V8CachingReader reader) {
        ColumnInfo[] columnInfos = new ColumnInfo[4];
        DirectTreeTableRenderer renderer = new DirectTreeTableRenderer(this.myProject, reader){

            @Override
            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchResultsTreeModelFactory$1", "customizeCellRenderer"));
                }
                if (value instanceof ChainTreeTableModel.Node) {
                    Object obj = ((ChainTreeTableModel.Node)value).getT();
                    if (obj == TARGETS) {
                        this.setBackground(null);
                        this.append("Targets", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (obj == FOUND) {
                        this.setBackground(null);
                        this.append("Found Occurrences", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (obj == TARGETS_CONTENTS) {
                        this.setBackground(null);
                        this.append(SearchResultsTreeModelFactory.this.myTarget, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (obj instanceof Pair && ((Pair)obj).getFirst() instanceof String && ((Pair)obj).getSecond() instanceof SimpleTextAttributes) {
                        this.setBackground(null);
                        SimpleTextAttributes attributes = (SimpleTextAttributes)((Pair)obj).getSecond();
                        if (selected) {
                            attributes = new SimpleTextAttributes(attributes.getBgColor(), SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.getFgColor(), attributes.getWaveColor(), attributes.getStyle());
                        }
                        this.append(((Pair)obj).getFirst().toString(), attributes);
                    } else {
                        super.customizeCellRenderer(tree, obj, selected, expanded, leaf, row, hasFocus);
                    }
                    int count = ((ChainTreeTableModel.Node)value).getMeaningfulChildren();
                    if (count > 0) {
                        SimpleTextAttributes attributes;
                        SimpleTextAttributes simpleTextAttributes = attributes = selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                        if (count == 1) {
                            this.append(" (" + count + " occurrence)", attributes);
                        } else {
                            this.append(" (" + count + " occurrences)", attributes);
                        }
                    }
                } else {
                    super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                }
            }
        };
        renderer.setReverseAsDirect(true);
        RetainersTreeModel.fillColumns(this.myProject, columnInfos, reader, renderer);
        return columnInfos;
    }

    public ChainTreeModelWithTopLevelFilter<String> createByTypes() {
        ArrayList<String> typeKeys = new ArrayList<String>(this.myMap.keySet());
        Collections.sort(typeKeys, BY_TYPE_COMPARATOR);
        ChainTreeModelWithTopLevelFilter<String> mainModel = new ChainTreeModelWithTopLevelFilter<String>(this.createColumns(this.myReader));
        this.addSearchConditions(mainModel);
        ChainTreeTableModel.Node topNode = mainModel.createNode(FOUND);
        mainModel.addTopKey(topNode);
        int numResults = 0;
        for (String key : typeKeys) {
            ChainTreeTableModel.Node typeNode = mainModel.createNode(Pair.create((Object)key, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            topNode.getChildren().add(typeNode);
            Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> map = this.myMap.get(key);
            ArrayList<String> stringKeys = new ArrayList<String>(map.keySet());
            Collections.sort(stringKeys, this.myComparator);
            ArrayList<Pair<V8HeapEdge, V8HeapEntry>> commonList = new ArrayList<Pair<V8HeapEdge, V8HeapEntry>>();
            for (String stringKey : stringKeys) {
                commonList.addAll((Collection<Pair<V8HeapEdge, V8HeapEntry>>)map.get(stringKey));
            }
            int numNodes = this.addResultsForStringKey(commonList, mainModel, typeNode.getChildren());
            typeNode.setMeaningfulChildren(numNodes);
            numResults += numNodes;
        }
        topNode.setMeaningfulChildren(numResults);
        mainModel.setNumResults(numResults);
        return mainModel;
    }

    public ChainTreeModelWithTopLevelFilter<String> createSimple() {
        Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> map = this.zipByString();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys, this.myComparator);
        ChainTreeModelWithTopLevelFilter<String> mainModel = new ChainTreeModelWithTopLevelFilter<String>(this.createColumns(this.myReader));
        this.addSearchConditions(mainModel);
        ChainTreeTableModel.Node topNode = mainModel.createNode(FOUND);
        mainModel.addTopKey(topNode);
        int numResults = 0;
        for (String key : keys) {
            ChainTreeTableModel.Node keyNode = mainModel.createNode(Pair.create((Object)key, (Object)SimpleTextAttributes.DARK_TEXT));
            topNode.getChildren().add(keyNode);
            List<ChainTreeTableModel.Node<Object>> addedNodesList = keyNode.getChildren();
            int numNodes = this.addResultsForStringKey(map.get(key), mainModel, addedNodesList);
            keyNode.setMeaningfulChildren(numNodes);
            numResults += numNodes;
        }
        topNode.setMeaningfulChildren(numResults);
        mainModel.setNumResults(numResults);
        return mainModel;
    }

    private int addResultsForStringKey(List<Pair<V8HeapEdge, V8HeapEntry>> list, ChainTreeModelWithTopLevelFilter<String> mainModel, List<ChainTreeTableModel.Node<Object>> addedNodesList) {
        int numResults = 0;
        ArrayList<List<FixedRetainerNode>> nodes = new ArrayList<List<FixedRetainerNode>>();
        for (Pair<V8HeapEdge, V8HeapEntry> pair : list) {
            List<FixedRetainerNode> chain = SearchDetailsTreeModel.getChainToRoot(0, (V8HeapEntry)pair.getSecond(), (V8HeapEdge)pair.getFirst(), this.myReader);
            Collections.reverse(chain);
            if (chain.isEmpty()) continue;
            nodes.add(chain);
            ++numResults;
        }
        for (List list2 : nodes) {
            ChainTreeTableModel.Node node = mainModel.createNode(list2.get(0));
            addedNodesList.add(node);
            for (int i = 1; i < list2.size(); ++i) {
                ChainTreeTableModel.Node childNode = mainModel.createNode(list2.get(i));
                node.getChildren().add(childNode);
                node = childNode;
            }
        }
        return numResults;
    }

    private void addSearchConditions(ChainTreeModelWithTopLevelFilter<String> model) {
        StringBuilder sb = new StringBuilder("Occurrences of '" + this.myText + "' ");
        if (this.mySearchEverywhereSelected) {
            sb.append("everywhere");
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : this.myMap.keySet()) {
                list.add(s.replace("&", ""));
            }
            Collections.sort(list);
            sb.append("in ").append(StringUtil.join(list, (String)", "));
        }
        ChainTreeTableModel.Node targetsNode = model.createNode(TARGETS);
        model.addTopKey(targetsNode);
        this.myTarget = sb.toString();
        targetsNode.getChildren().add(model.createNode(TARGETS_CONTENTS));
    }

    private Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> zipByString() {
        HashMap<String, List<Pair<V8HeapEdge, V8HeapEntry>>> result = new HashMap<String, List<Pair<V8HeapEdge, V8HeapEntry>>>();
        for (Map.Entry<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> entry : this.myMap.entrySet()) {
            Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> byKey = entry.getValue();
            for (Map.Entry<String, List<Pair<V8HeapEdge, V8HeapEntry>>> listEntry : byKey.entrySet()) {
                ArrayList list = (ArrayList)result.get(listEntry.getKey());
                if (list == null) {
                    list = new ArrayList();
                    result.put(listEntry.getKey(), list);
                }
                list.addAll(listEntry.getValue());
            }
        }
        for (Map.Entry<String, Map<String, List<Object>>> entry : result.entrySet()) {
            List list = (List)((Object)entry.getValue());
            List<Pair<V8HeapEdge, V8HeapEntry>> filtered = SearchResultsTreeModelFactory.filterRepeatingNodesOut(list);
            if (list.size() <= filtered.size()) continue;
            list.clear();
            list.addAll(filtered);
        }
        return result;
    }

    private static List<Pair<V8HeapEdge, V8HeapEntry>> filterRepeatingNodesOut(List<Pair<V8HeapEdge, V8HeapEntry>> list) {
        if (list.size() <= 1) {
            return list;
        }
        HashSet<Long> nodeIdsReferencesByLinks = new HashSet<Long>();
        for (Pair<V8HeapEdge, V8HeapEntry> pair : list) {
            if (pair.getFirst() == null) continue;
            nodeIdsReferencesByLinks.add(((V8HeapEntry)pair.getSecond()).getId());
        }
        ArrayList<Pair<V8HeapEdge, V8HeapEntry>> result = new ArrayList<Pair<V8HeapEdge, V8HeapEntry>>();
        HashSet<Long> alreadyAdded = new HashSet<Long>();
        for (Pair<V8HeapEdge, V8HeapEntry> pair : list) {
            if (pair.getFirst() == null && nodeIdsReferencesByLinks.contains(((V8HeapEntry)pair.getSecond()).getId()) || alreadyAdded.contains(((V8HeapEntry)pair.getSecond()).getId())) continue;
            result.add(pair);
            alreadyAdded.add(((V8HeapEntry)pair.getSecond()).getId());
        }
        return result;
    }

    public static void expandTop(TreeTableTree tree, TreeTableModel model) {
        ChainTreeTableModel.Node root = (ChainTreeTableModel.Node)model.getRoot();
        for (ChainTreeTableModel.Node o : root.getChildren()) {
            tree.expandPath(new TreePath(new Object[]{root, o}));
        }
    }

    public static class ChainTreeModelWithTopLevelFilter<T>
    extends ChainTreeTableModel {
        private final Set<T> myAllowedTopLevel = new HashSet<T>();
        private boolean myFilter = false;
        private int myNumResults = 0;

        public ChainTreeModelWithTopLevelFilter(ColumnInfo[] columns) {
            super(columns);
        }

        public int getNumResults() {
            return this.myNumResults;
        }

        public void setNumResults(int numResults) {
            this.myNumResults = numResults;
        }

        public void noFilter() {
            this.myFilter = false;
            this.myAllowedTopLevel.clear();
        }

        public void setFilter(Set<T> set) {
            this.myAllowedTopLevel.clear();
            this.myAllowedTopLevel.addAll(set);
            this.myFilter = true;
        }

        @Override
        protected List<ChainTreeTableModel.Node<?>> getChildren(Object object) {
            List<ChainTreeTableModel.Node<?>> children = super.getChildren(object);
            if (this.myFilter && this.getRoot().equals(object)) {
                ArrayList list = new ArrayList();
                for (ChainTreeTableModel.Node<?> child : children) {
                    if (!this.myAllowedTopLevel.contains(child.getT())) continue;
                    list.add(child);
                }
                return list;
            }
            return children;
        }
    }
}

