/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.main;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapProcessor;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponentPartner;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class OpenSnapshotWorker
extends Task.Backgroundable {
    private final VirtualFile myFile;
    private final boolean myShowHiddenData;
    private V8CachingReader myCachingReader;

    private OpenSnapshotWorker(Project project, VirtualFile file, boolean showHiddenData) {
        super(project, "Processing heap snapshot " + file.getName(), true, null);
        this.myFile = file;
        this.myShowHiddenData = showHiddenData;
    }

    public static void work(Project project, VirtualFile file, boolean showHiddenData) {
        try {
            byte[] bytes = V8HeapIndexManager.snapshotDigest(new File(file.getPath()), showHiddenData);
            if (bytes != null && V8HeapComponent.getInstance(project).activateIfOpen(new ByteArrayWrapper(bytes))) {
                return;
            }
        }
        catch (IOException e) {
            OpenSnapshotWorker.createNotificator(project).consume((Object)e.getMessage());
        }
        ProgressManager.getInstance().run((Task)new OpenSnapshotWorker(project, file, showHiddenData));
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/heap/view/main/OpenSnapshotWorker", "run"));
        }
        try {
            V8HeapProcessor processor = new V8HeapProcessor(OpenSnapshotWorker.createNotificator(this.myProject), new File(this.myFile.getPath()), this.myShowHiddenData, indicator);
            this.myCachingReader = processor.getFromCacheOrProcess();
        }
        catch (IOException e1) {
            this.notifyOnException(e1);
        }
        catch (ClassNotFoundException e1) {
            this.notifyOnException(e1);
        }
    }

    @NotNull
    public static Consumer<String> createNotificator(Project project) {
        Consumer consumer = message -> NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Problem with heap snapshot: " + message, MessageType.ERROR).notify(project);
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/main/OpenSnapshotWorker", "createNotificator"));
        }
        return consumer;
    }

    private void notifyOnException(Exception e1) {
        V8HeapProcessor.LOG.info((Throwable)e1);
        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Error during processing snapshot: " + e1.getMessage(), MessageType.ERROR).notify(this.myProject);
    }

    public void onSuccess() {
        if (this.myCachingReader != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                try {
                    String name = this.myFile.getName();
                    name = name.endsWith(".heapsnapshot") ? name.substring(0, name.length() - "heapsnapshot".length() - 1) : name;
                    V8HeapComponent.getInstance(this.myProject).showMe(this.myCachingReader.getDigest(), new V8HeapComponentPartner(this.myCachingReader, name), name, null);
                }
                catch (IOException e) {
                    this.notifyOnException(e);
                }
            });
        }
    }
}

