/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.settings;

import com.intellij.execution.ui.AdjustingTabSettingsEditor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.linter.NodeModuleConfigurationView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;

public class NodeProfilingPanel<T extends NodeJsRunConfiguration>
extends SettingsEditor<T>
implements AdjustingTabSettingsEditor {
    @NotNull
    private final Getter<NodeJsInterpreter> myNodePathProvider;
    private JBCheckBox myProfile;
    private TextFieldWithBrowseButton myLogFileField;
    private JPanel myMainPanel;
    private JPanel myViewerParameters;
    private JBCheckBox myAllowHeapProfiling;
    private NodePackageField myV8ProfilerPackage;
    private TextFieldWithHistoryWithBrowseButton myV8RemoteProfilerPackage;
    private JPanel myV8ProfilerPanel;
    private JSpinner myPort;
    private JEditorPane myV8ProfilerHint;
    @NotNull
    private Project myProject;
    private JBCheckBox myOneLogFile;
    private JPanel myV8profilerWrapper;
    private boolean myIsRemote;
    private NodeJsInterpreter myPreviousPath;
    private Getter<Boolean> myV8ProfilerPackageBrowsingUpdater;

    public NodeProfilingPanel(@NotNull Getter<NodeJsInterpreter> nodePathProvider, @NotNull Project project) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel", "<init>"));
        }
        this.myNodePathProvider = nodePathProvider;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.pathToNodeChanged();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel", "createEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull T rc) {
        boolean haveLogFile;
        if (rc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rc", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel", "resetEditorFrom"));
        }
        NodeProfilingSettings settings = ((NodeJsRunConfiguration)((Object)rc)).getNodeProfilingSettings();
        this.myIsRemote = this.myNodePathProvider.get() != null && NodeJsRemoteInterpreterType.getInstance().equals(((NodeJsInterpreter)this.myNodePathProvider.get()).getType());
        ((GridLayoutManager)this.myMainPanel.getLayout()).setHGap(2);
        this.myProfile.setSelected(settings.isProfile());
        String text = StringUtil.notNullize((String)settings.getLogFolder());
        boolean bl = haveLogFile = settings.getLogFolder() != null;
        if (haveLogFile) {
            String basePath;
            File file = new File(text);
            if (!file.isAbsolute() && (basePath = this.myProject.getBasePath()) != null) {
                file = ".".equals(text) ? new File(basePath) : new File(basePath, text);
            }
            text = FileUtil.toSystemDependentName((String)file.getAbsolutePath());
        } else {
            text = this.myProject.getBasePath();
        }
        this.myLogFileField.setText(text);
        this.myOneLogFile.setSelected(settings.isOneLogFile());
        this.cpuEnabled(settings.isProfile());
        this.myAllowHeapProfiling.setSelected(settings.isAllowRuntimeHeapSnapshot());
        if (this.myIsRemote) {
            ((TextFieldWithHistory)this.myV8RemoteProfilerPackage.getChildComponent()).setText(StringUtil.notNullize((String)settings.getV8ProfilerPackage()));
        } else if (StringUtil.isEmptyOrSpaces((String)settings.getV8ProfilerPackage())) {
            NodePackage defaultPackage = NodePackage.findDefaultPackage((Project)this.myProject, (String)"v8-profiler", (NodeJsInterpreter)((NodeJsInterpreter)this.myNodePathProvider.get()));
            if (defaultPackage != null) {
                this.myV8ProfilerPackage.setSelected(defaultPackage);
            }
        } else {
            this.myV8ProfilerPackage.setSelected(new NodePackage(StringUtil.notNullize((String)settings.getV8ProfilerPackage())));
        }
        this.myPort.setValue(settings.getInnerPort() == -1 ? 43517 : settings.getInnerPort());
        this.heapEnabled(settings.isAllowRuntimeHeapSnapshot());
    }

    protected void applyEditorTo(@NotNull T rc) throws ConfigurationException {
        if (rc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rc", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel", "applyEditorTo"));
        }
        NodeProfilingSettings settings = ((NodeJsRunConfiguration)((Object)rc)).getNodeProfilingSettings();
        this.pathToNodeChanged();
        settings.setProfile(this.myProfile.isSelected());
        String text = this.getLogFileText();
        settings.setLogFolder(StringUtil.isEmptyOrSpaces((String)text) ? null : text);
        settings.setOneLogFile(this.myOneLogFile.isSelected());
        settings.setOpenViewer(true);
        settings.setAllowRuntimeHeapSnapshot(this.myAllowHeapProfiling.isSelected());
        settings.setV8ProfilerPackage(this.myIsRemote ? this.myV8RemoteProfilerPackage.getText().trim() : this.myV8ProfilerPackage.getSelected().getSystemDependentPath());
        Number number = ((SpinnerNumberModel)this.myPort.getModel()).getNumber();
        settings.setInnerPort(number == null ? -1 : number.intValue());
    }

    private String getLogFileText() {
        String relativePath;
        String text = this.myLogFileField.getText();
        String basePath = this.myProject.getBasePath();
        if (basePath != null && (relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)basePath), (String)FileUtil.toSystemIndependentName((String)text), (char)'/')) != null) {
            text = relativePath;
        }
        return text;
    }

    private void cpuEnabled(boolean value) {
        UIUtil.setEnabled((Component)this.myViewerParameters, (boolean)value, (boolean)true);
    }

    private void heapEnabled(boolean value) {
        UIUtil.setEnabled((Component)this.myV8ProfilerPanel, (boolean)value, (boolean)true);
    }

    private void createUIComponents() {
        this.myProfile = new JBCheckBox(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.record.checkbox", new Object[0]));
        this.myProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeProfilingPanel.this.cpuEnabled(NodeProfilingPanel.this.myProfile.isSelected());
            }
        });
        final FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLogFileField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(folderDescriptor, NodeProfilingPanel.this.myProject, (Component)NodeProfilingPanel.this.myLogFileField);
                VirtualFile[] fileWrapper = chooser.choose(NodeProfilingPanel.this.myProject, new VirtualFile[]{NodeProfilingPanel.this.myProject.getBaseDir()});
                if (fileWrapper.length == 1) {
                    NodeProfilingPanel.this.myLogFileField.setText(fileWrapper[0].getPath());
                }
            }
        });
        FileChooserFactory.getInstance().installFileCompletion(this.myLogFileField.getTextField(), folderDescriptor, false, null);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().setVerticalGap(2);
        formBuilder.addLabeledComponent(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.log.folder.label", new Object[0]), (JComponent)this.myLogFileField);
        this.myOneLogFile = new JBCheckBox(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.one.log.file.checkbox", new Object[0]));
        formBuilder.addComponent((JComponent)this.myOneLogFile).addVerticalGap(4);
        this.myViewerParameters = formBuilder.getPanel();
        FormBuilder formBuilder2 = FormBuilder.createFormBuilder().setVerticalGap(2);
        this.myV8profilerWrapper = new JPanel(new CardLayout());
        this.myV8ProfilerPackage = new NodePackageField(this.myProject, "v8-profiler", () -> (NodeJsInterpreter)this.myNodePathProvider.get());
        Pair pair = NodeModuleConfigurationView.createRemotePackageField((Project)this.myProject, (String)"v8-profiler", (String)NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.package.title", new Object[0]), this.myNodePathProvider);
        this.myV8RemoteProfilerPackage = (TextFieldWithHistoryWithBrowseButton)pair.getFirst();
        this.myV8ProfilerPackageBrowsingUpdater = (Getter)pair.getSecond();
        this.myV8profilerWrapper.add((Component)this.myV8ProfilerPackage, "Local");
        this.myV8profilerWrapper.add((Component)this.myV8RemoteProfilerPackage, "Remote");
        formBuilder2.addLabeledComponent(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.package.label", new Object[0]), (JComponent)this.myV8profilerWrapper);
        String disabledHtml = NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.hint.html.disabled", NodeProfilingPanel.getDisabledLinkColor());
        this.myV8ProfilerHint = SwingHelper.createHtmlLabel((String)NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.hint.html", new Object[0]), (String)disabledHtml, null);
        formBuilder2.addComponentToRightColumn((JComponent)this.myV8ProfilerHint, 0).addVerticalGap(4);
        this.myPort = new JSpinner(new SpinnerNumberModel(43517, 1024, 65535, 1));
        this.myPort.setEditor(new JSpinner.NumberEditor(this.myPort, "0"));
        formBuilder2.addLabeledComponent(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.communication.port", new Object[0]), (JComponent)this.myPort);
        this.myV8ProfilerPanel = formBuilder2.getPanel();
        this.myAllowHeapProfiling = new JBCheckBox(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.take.snapshots.checkbox", new Object[0]));
        this.myAllowHeapProfiling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeProfilingPanel.this.heapEnabled(NodeProfilingPanel.this.myAllowHeapProfiling.isSelected());
            }
        });
    }

    public void pathToNodeChanged() {
        NodeJsInterpreter interpreter = (NodeJsInterpreter)this.myNodePathProvider.get();
        if (interpreter == null || interpreter.equals(this.myPreviousPath)) {
            return;
        }
        this.myPreviousPath = interpreter;
        this.myIsRemote = NodeJsRemoteInterpreterType.getInstance().equals(interpreter.getType());
        if (this.myIsRemote) {
            ((CardLayout)this.myV8profilerWrapper.getLayout()).show(this.myV8profilerWrapper, "Remote");
            if (this.myV8ProfilerPackageBrowsingUpdater != null) {
                this.myV8RemoteProfilerPackage.getButton().setEnabled(Boolean.TRUE.equals(this.myV8ProfilerPackageBrowsingUpdater.get()));
            }
        } else {
            ((CardLayout)this.myV8profilerWrapper.getLayout()).show(this.myV8profilerWrapper, "Local");
        }
    }

    private static String getDisabledLinkColor() {
        Color darker = UIUtil.isUnderDarcula() ? UIUtil.getLabelDisabledForeground().brighter() : UIUtil.getLabelDisabledForeground().darker();
        return "#" + Integer.toHexString(darker.getRGB()).substring(2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBCheckBox jBCheckBox = this.myProfile;
        jBCheckBox.setText("Record CPU profiling info");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBCheckBox jBCheckBox2 = this.myAllowHeapProfiling;
        jBCheckBox2.setText("Allow taking heap snapshots ");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myV8ProfilerPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(3, 1, 1, 3, 0, 3, 3, 3, null, null, null, 5));
        JPanel jPanel3 = this.myViewerParameters;
        jPanel.add((Component)jPanel3, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null, 5));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

