/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.settings;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.nodejs.packages.NodePackagesView;
import com.jetbrains.nodejs.settings.NodeCoreSourcesView;
import com.jetbrains.nodejs.settings.NodeVersionListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsView {
    @NonNls
    private static final String LOCAL = "Local";
    @NonNls
    private static final String REMOTE = "Remote";
    private final boolean myOneClickConfiguration;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final JComponent myComponent;
    private JPanel myWrapperPanel;
    private final List<NodeVersionListener> myVersionListeners;

    public NodeSettingsView(@NotNull Project project, @Nullable VirtualFile requestor, boolean oneClickConfiguration) {
        JPanel bottomComponent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/settings/NodeSettingsView", "<init>"));
        }
        this.myVersionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOneClickConfiguration = oneClickConfiguration;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false){

            public boolean isDefaultProjectInterpreterField() {
                return true;
            }
        };
        FormBuilder formBuilder = FormBuilder.createFormBuilder().setAlignLabelOnRight(true);
        formBuilder.addLabeledComponent("Node interpreter:", (JComponent)this.myNodeInterpreterField);
        NodeCoreSourcesView nodeCoreSourcesView = new NodeCoreSourcesView(project, requestor);
        formBuilder.addComponent(nodeCoreSourcesView.getComponent(), JBUI.scale((int)5));
        this.myVersionListeners.add(nodeCoreSourcesView);
        if (!project.isDefault()) {
            NodePackagesView nodePackagesView = new NodePackagesView(project, oneClickConfiguration);
            this.myVersionListeners.add(nodePackagesView);
            this.myWrapperPanel = new JPanel(new CardLayout());
            this.myWrapperPanel.add((Component)nodePackagesView.getComponent(), LOCAL);
            this.myWrapperPanel.add((Component)NodeUIUtil.wrapInCenteredPanel((String)"Not implemented yet"), REMOTE);
            ((CardLayout)this.myWrapperPanel.getLayout()).show(this.myWrapperPanel, LOCAL);
            bottomComponent = this.myWrapperPanel;
        } else {
            bottomComponent = new JPanel();
        }
        formBuilder.addComponentFillVertically((JComponent)bottomComponent, 0);
        this.myComponent = formBuilder.getPanel();
        this.listenForNodeInterpreterPathUpdate();
    }

    private void listenForNodeInterpreterPathUpdate() {
        this.myNodeInterpreterField.addChangeListener(this::handleNodeInterpreterChange);
    }

    private void handleNodeInterpreterChange(@Nullable NodeJsInterpreter newInterpreter) {
        if (newInterpreter == null) {
            this.fireVersionUpdated(null, null);
        } else {
            Ref versionRef = newInterpreter.getCachedVersion();
            if (versionRef != null) {
                this.fireVersionUpdated(newInterpreter, (SemVer)versionRef.get());
            } else {
                this.fireUpdateStarted();
                ModalityState modalityState = ModalityState.current();
                newInterpreter.fetchVersion(version -> ApplicationManager.getApplication().invokeLater(() -> this.fireVersionUpdated(newInterpreter, (SemVer)version), modalityState));
            }
            this.updateCard(newInterpreter);
        }
        this.updateCard(newInterpreter);
    }

    private void fireUpdateStarted() {
        for (NodeVersionListener listener : this.myVersionListeners) {
            listener.versionUpdateStarted();
        }
    }

    private void fireVersionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        for (NodeVersionListener listener : this.myVersionListeners) {
            listener.versionUpdated(interpreter, version);
        }
    }

    public void setInterpreter(@Nullable NodeJsInterpreter interpreter) {
        this.myNodeInterpreterField.setInterpreter(interpreter);
        if (this.myOneClickConfiguration) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
        }
        this.updateCard(interpreter);
    }

    private void updateCard(@Nullable NodeJsInterpreter interpreter) {
        if (this.myWrapperPanel == null) {
            return;
        }
        CardLayout layout = (CardLayout)this.myWrapperPanel.getLayout();
        if (interpreter instanceof NodeJsRemoteInterpreter) {
            layout.show(this.myWrapperPanel, REMOTE);
        } else {
            layout.show(this.myWrapperPanel, LOCAL);
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myNodeInterpreterField.getInterpreter();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeSettingsView", "getComponent"));
        }
        return jComponent;
    }
}

