/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.uml;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JsModuleUmlUtil {
    public static String getModuleName(@NotNull JSFile moduleFile) {
        if (moduleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFile", "com/jetbrains/nodejs/uml/JsModuleUmlUtil", "getModuleName"));
        }
        return FileUtil.getNameWithoutExtension((String)moduleFile.getName());
    }

    public static JSFile[] findDependencies(JSFile moduleFile) {
        final ArrayList result = new ArrayList();
        moduleFile.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression[] argumentList;
                JSReferenceExpression ref;
                if (node.getMethodExpression() instanceof JSReferenceExpression && "require".equals((ref = (JSReferenceExpression)node.getMethodExpression()).getReferencedName()) && ref.getQualifier() == null && (argumentList = node.getArguments()).length > 0) {
                    PsiReference[] references;
                    for (PsiReference reference : references = argumentList[0].getReferences()) {
                        PsiElement resolved = reference.resolve();
                        if (!(resolved instanceof JSFile)) continue;
                        result.add((JSFile)resolved);
                    }
                }
            }
        });
        return result.toArray(new JSFile[result.size()]);
    }

    public static JSNamedElement[] getExportedSymbols(JSFile moduleFile) {
        ArrayList<JSNamedElement> result = new ArrayList<JSNamedElement>();
        for (JSPsiElementBase elementBase : JSClassResolver.getInstance().findNamespaceMembers("exports", GlobalSearchScope.fileScope((PsiFile)moduleFile))) {
            if (!(elementBase instanceof JSNamedElement)) continue;
            result.add((JSNamedElement)elementBase);
        }
        Collections.sort(result, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return result.toArray(new JSNamedElement[result.size()]);
    }
}

