/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.uml;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationships;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.jetbrains.nodejs.uml.JSModulesUmlEdge;
import com.jetbrains.nodejs.uml.JSModulesUmlProvider;
import com.jetbrains.nodejs.uml.JsModuleUmlNode;
import com.jetbrains.nodejs.uml.JsModuleUmlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsModulesUmlDataModel
extends DiagramDataModel<JSFile> {
    private final JSFile myOriginalElement;
    private final Collection<JsModuleUmlNode> myNodes = new HashSet<JsModuleUmlNode>();
    private final Collection<JSModulesUmlEdge> myEdges = new HashSet<JSModulesUmlEdge>();

    public JsModulesUmlDataModel(Project project, JSFile element, DiagramPresentationModel presentationModel, JSModulesUmlProvider provider) {
        super(project, (DiagramProvider)provider);
        this.myOriginalElement = element;
    }

    @NotNull
    public Collection<? extends DiagramNode<JSFile>> getNodes() {
        Collection<JsModuleUmlNode> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/uml/JsModulesUmlDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<JSFile>> getEdges() {
        Collection<JSModulesUmlEdge> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/uml/JsModulesUmlDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<JSFile> n) {
        if ("aaa" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/uml/JsModulesUmlDataModel", "getNodeName"));
        }
        return "aaa";
    }

    @Nullable
    public DiagramNode<JSFile> addElement(JSFile element) {
        return null;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.addNodeWithDependencies(this.myOriginalElement, new HashMap<JSFile, JsModuleUmlNode>(), new HashSet<JSFile>());
    }

    private JsModuleUmlNode addNodeWithDependencies(JSFile moduleFile, Map<JSFile, JsModuleUmlNode> file2node, Collection<JSFile> processed) {
        JsModuleUmlNode node = new JsModuleUmlNode(moduleFile, (DiagramProvider<JSFile>)this.getProvider());
        this.myNodes.add(node);
        for (JSFile dependency : JsModuleUmlUtil.findDependencies(moduleFile)) {
            if (processed.contains(dependency)) continue;
            JsModuleUmlNode dependencyNode = file2node.get(dependency);
            if (dependencyNode == null) {
                processed.add(moduleFile);
                dependencyNode = this.addNodeWithDependencies(dependency, file2node, processed);
                processed.remove(moduleFile);
                file2node.put(dependency, dependencyNode);
            }
            this.myEdges.add(new JSModulesUmlEdge((DiagramNode<JSFile>)node, (DiagramNode<JSFile>)dependencyNode, DiagramRelationships.DEPENDENCY));
        }
        return node;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/uml/JsModulesUmlDataModel", "getModificationTracker"));
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }
}

