/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.uml;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.Nullable;

public class JsModulesUmlVfsResolver
implements DiagramVfsResolver<JSFile> {
    public String getQualifiedName(JSFile moduleFile) {
        VirtualFile baseDir = moduleFile.getProject().getBaseDir();
        VirtualFile vFile = moduleFile.getVirtualFile();
        String path = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)baseDir, (char)'/');
        if (path == null) {
            path = vFile.getPath();
        }
        return path;
    }

    @Nullable
    public JSFile resolveElementByFQN(String fqn, Project project) {
        PsiFile psiFile;
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{fqn});
        if (file == null) {
            file = LocalFileSystem.getInstance().findFileByPath(fqn);
        }
        if (file != null && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof JSFile) {
            return (JSFile)psiFile;
        }
        return null;
    }
}

