/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerResponse;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdInspection;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContainerInspectionImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.NotNullSetter;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.OngoingProcessBase;
import com.intellij.docker.agent.ResultCallbackImpl;
import com.intellij.docker.agent.StreamCallbackBase;
import com.intellij.docker.agent.WebsocketClientEndpoint;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import com.intellij.remoteServer.agent.util.log.TerminalPipe;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Session;

public abstract class DockerAgentApplicationBase
implements DockerAgentApplication {
    private final DockerAgentContext myContext;
    private String myContainerId;

    public DockerAgentApplicationBase(DockerAgentContext context) {
        this.myContext = context;
    }

    protected DockerClient getClient() {
        return this.myContext.getClient();
    }

    protected CloudAgentErrorHandler getErrorHandler() {
        return this.myContext.getErrorHandler();
    }

    protected CloudAgentLogger getLogger() {
        return this.myContext.getLogger();
    }

    public String getContainerId() {
        return this.myContainerId;
    }

    protected void setContainerId(String containerId) {
        this.myContainerId = containerId;
    }

    public void startContainer() {
        new StateChangeTaskBase(this.getErrorHandler()){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().startContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void stopContainer() {
        this.stopContainerImmediate(this.getErrorHandler());
    }

    public void stopContainerImmediate(CloudAgentErrorHandler errorHandler) {
        new StateChangeTaskBase(errorHandler){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().stopContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void deleteContainer() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteContainerWithVolumes() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteImage() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeImageCmd(DockerAgentApplicationBase.this.getImageId()).exec();
                return null;
            }
        }.perform();
    }

    public String createContainer() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                StartContainerCmd startContainerCmd = DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId);
                startContainerCmd.exec();
                return containerId;
            }
        }.perform();
    }

    public String getWebUrl() {
        throw new UnsupportedOperationException();
    }

    public void showLog(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doShowLog(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doShowLog(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        final DockerLogPipe logPipe = new DockerLogPipe(containerId, loggingHandler);
        this.myContext.getLogManager().startListeningLog(containerId, new LogPipeProvider(){

            public List<? extends LogPipe> createLogPipes(String deploymentName) {
                return Collections.singletonList(logPipe);
            }
        });
    }

    public void inspect2log(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                LogListener logListener = loggingHandler.getOrCreateEmptyLogListener("Inspection");
                InspectContainerResponse response = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ObjectMapper objectMapper = new ObjectMapper();
                String responseString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                logListener.lineLogged(responseString);
                return null;
            }
        }.perform();
    }

    public DockerAgentContainerInspection inspect() {
        return (DockerAgentContainerInspection)new ApiTaskBase<DockerAgentContainerInspection>(this.getErrorHandler()){

            @Override
            protected DockerAgentContainerInspection doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    cmdConfig.withName(containerName);
                }
                DockerAgentApplicationBase.this.setupContainerConfig((CreateContainerCmd)cmdConfig, inspection, DockerAgentContainerConfigImpl.createEmptyConfig());
                return new DockerAgentContainerInspectionImpl((CreateContainerCmd)cmdConfig, inspectResponse.getState().getRunning());
            }
        }.perform();
    }

    public void showProcesses(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                LogListener logListener = loggingHandler.getOrCreateEmptyLogListener("Processes");
                TopContainerResponse response = DockerAgentApplicationBase.this.getClient().topContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ObjectMapper objectMapper = new ObjectMapper();
                String responseString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                logListener.lineLogged(responseString);
                return null;
            }
        }.perform();
    }

    public void attach(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doAttach(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doAttach(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        this.doAttachPipe(containerId, (LogPipeBase)new DocketAttachHijackPipe(containerId, loggingHandler));
    }

    public void attachWebsocket(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doAttachWebsocket(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    private void doAttachWebsocket(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        this.doAttachPipe(containerId, (LogPipeBase)new DocketAttachWebSocketPipe(containerId, loggingHandler));
    }

    private void doAttachPipe(String containerId, final LogPipeBase attachPipe) throws IOException, ApiTaskException {
        this.myContext.getLogManager().startListeningLog(containerId + " attach", new LogPipeProvider(){

            public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                return Collections.singletonList(attachPipe);
            }
        });
    }

    public OngoingProcess exec(final CloudAgentLoggingHandler loggingHandler, final String[] command, final String logName) {
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this.getErrorHandler()){

            @Override
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.doExec(loggingHandler, command, logName);
            }
        }.perform();
    }

    protected OngoingProcess doExec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) throws IOException, ApiTaskException {
        final DockerExecPipe execPipe = new DockerExecPipe(loggingHandler, command, logName);
        StringBuilder id = new StringBuilder();
        id.append(this.getContainerId());
        id.append(" exec");
        for (String commandPart : command) {
            id.append(" ");
            id.append(commandPart);
        }
        this.myContext.getLogManager().startListeningLog(id.toString(), new LogPipeProvider(){

            public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                return Collections.singletonList(execPipe);
            }
        });
        return new OngoingProcessBase(this.getLogger()){

            public void cancel() {
                DockerAgentApplicationBase.this.stopContainerImmediate(this.getErrorHandler());
            }

            public void await() {
                DockerAgentApplicationBase.this.waitForExitImmediate(this.getErrorHandler());
            }
        };
    }

    public void pushImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                String repository = repositoryConfig.getQualifiedRepository();
                String tag = repositoryConfig.getTag();
                if (!this.hasImageTag()) {
                    TagImageCmd tagImageCmd = DockerAgentApplicationBase.this.getClient().tagImageCmd(DockerAgentApplicationBase.this.getImageId(), repository, tag);
                    tagImageCmd.exec();
                }
                PushImageCmd pushImageCmd = DockerAgentApplicationBase.this.getClient().pushImageCmd(repository);
                pushImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(repositoryConfig.getAuthConfig()));
                if (tag != null) {
                    pushImageCmd.withTag(tag);
                }
                pushImageCmd.exec(new ResultCallbackImpl(progressCallback, DockerAgentApplicationBase.this.getLogger()));
                return null;
            }

            private boolean hasImageTag() {
                return Arrays.asList(DockerAgentApplicationBase.this.getImageRepoTags()).contains(repositoryConfig.getQualifiedTag());
            }
        }.perform();
    }

    public void updateContainer(final DockerAgentContainerConfig config) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    createContainerCmd.withName(containerName);
                }
                DockerAgentApplicationBase.this.setupContainerConfig(createContainerCmd, inspection, new DockerAgentContainerConfigImpl(config));
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                DockerAgentApplicationBase.this.setContainerId(containerId);
                if (!DockerUtil.isStoppedStatus((String)DockerAgentApplicationBase.this.getContainerStatus())) {
                    DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId).exec();
                }
                return null;
            }
        }.perform();
    }

    protected void setupContainerConfig(final CreateContainerCmd createContainerCmd, CreateContainerCmdConfig cmdConfig, DockerAgentContainerConfigImpl priorityConfig) {
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withAttachStdin(value);
            }
        }.set(cmdConfig.isAttachStdin());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withAttachStdout(value);
            }
        }.set(cmdConfig.isAttachStdout());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withAttachStderr(value);
            }
        }.set(cmdConfig.isAttachStderr());
        new NotNullSetter<Bind[]>(){

            @Override
            protected void doSet(Bind[] value) {
                createContainerCmd.withBinds(value);
            }
        }.set((T[])new Bind[][]{priorityConfig.createCmdVolumeBindings(), this.prepareBinds(cmdConfig.getBinds())});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withUser(value);
            }
        }.set(priorityConfig.getUser(), cmdConfig.getUser());
        new NotNullSetter<Integer>(){

            @Override
            protected void doSet(Integer value) {
                createContainerCmd.withBlkioWeight(value);
            }
        }.set(cmdConfig.getBlkioWeight());
        new NotNullSetter<Capability[]>(){

            @Override
            protected void doSet(Capability[] value) {
                createContainerCmd.withCapAdd(value);
            }
        }.set((T[])new Capability[][]{cmdConfig.getCapAdd()});
        new NotNullSetter<Capability[]>(){

            @Override
            protected void doSet(Capability[] value) {
                createContainerCmd.withCapAdd(value);
            }
        }.set((T[])new Capability[][]{cmdConfig.getCapDrop()});
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withCmd(value);
            }
        }.set((T[])new String[][]{priorityConfig.getCommand(), cmdConfig.getCmd()});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withContainerIDFile(value);
            }
        }.set(cmdConfig.getContainerIDFile());
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withCpusetCpus(value);
            }
        }.set(cmdConfig.getCpusetCpus());
        new NotNullSetter<Integer>(){

            @Override
            protected void doSet(Integer value) {
                createContainerCmd.withCpuShares(value);
            }
        }.set(cmdConfig.getCpuShares());
        new NotNullSetter<Integer>(){

            @Override
            protected void doSet(Integer value) {
                createContainerCmd.withCpuPeriod(value);
            }
        }.set(cmdConfig.getCpuPeriod());
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withCpusetMems(value);
            }
        }.set(cmdConfig.getCpusetMems());
        new NotNullSetter<Device[]>(){

            @Override
            protected void doSet(Device[] value) {
                createContainerCmd.withDevices(value);
            }
        }.set((T[])new Device[][]{cmdConfig.getDevices()});
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withDns(value);
            }
        }.set((T[])new String[][]{cmdConfig.getDns()});
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withDnsSearch(value);
            }
        }.set((T[])new String[][]{cmdConfig.getDnsSearch()});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withDomainName(value);
            }
        }.set(cmdConfig.getDomainName());
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withEntrypoint(value);
            }
        }.set((T[])new String[][]{priorityConfig.getEntrypoint(), cmdConfig.getEntrypoint()});
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withEnv(value);
            }
        }.set((T[])new String[][]{priorityConfig.createCmdEnvVars(), cmdConfig.getEnv()});
        new NotNullSetter<ExposedPort[]>(){

            @Override
            protected void doSet(ExposedPort[] value) {
                createContainerCmd.withExposedPorts(value);
            }
        }.set((T[])new ExposedPort[][]{cmdConfig.getExposedPorts()});
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withExtraHosts(value);
            }
        }.set((T[])new String[][]{priorityConfig.getExtraHosts(), cmdConfig.getExtraHosts()});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withHostName(value);
            }
        }.set(cmdConfig.getHostName());
        new NotNullSetter<Map<String, String>>(){

            @Override
            protected void doSet(Map<String, String> value) {
                createContainerCmd.withLabels(value);
            }
        }.set(cmdConfig.getLabels());
        new NotNullSetter<Link[]>(){

            @Override
            protected void doSet(Link[] value) {
                createContainerCmd.withLinks(value);
            }
        }.set((T[])new Link[][]{priorityConfig.createCmdLinks(), cmdConfig.getLinks()});
        new NotNullSetter<LxcConf[]>(){

            @Override
            protected void doSet(LxcConf[] value) {
                createContainerCmd.withLxcConf(value);
            }
        }.set((T[])new LxcConf[][]{cmdConfig.getLxcConf()});
        new NotNullSetter<LogConfig>(){

            @Override
            protected void doSet(LogConfig value) {
                createContainerCmd.withLogConfig(value);
            }
        }.set(cmdConfig.getLogConfig());
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withMacAddress(value);
            }
        }.set(cmdConfig.getMacAddress());
        new NotNullSetter<Long>(){

            @Override
            protected void doSet(Long value) {
                createContainerCmd.withMemory(value);
            }
        }.set(cmdConfig.getMemory());
        new NotNullSetter<Long>(){

            @Override
            protected void doSet(Long value) {
                createContainerCmd.withMemorySwap(value);
            }
        }.set(cmdConfig.getMemory());
        Boolean networkDisabled = priorityConfig.getNetworkDisabled();
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withNetworkDisabled(value);
            }
        }.set(networkDisabled != null ? networkDisabled : cmdConfig.isNetworkDisabled());
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withNetworkMode(value);
            }
        }.set(priorityConfig.getNetworkMode(), cmdConfig.getNetworkMode());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withOomKillDisable(value);
            }
        }.set(cmdConfig.getOomKillDisable());
        new NotNullSetter<Ports>(){

            @Override
            protected void doSet(Ports value) {
                createContainerCmd.withPortBindings(value);
            }
        }.set(priorityConfig.createCmdPortBindings(), cmdConfig.getPortBindings());
        new NotNullSetter<ExposedPort[]>(){

            @Override
            protected void doSet(ExposedPort[] value) {
                createContainerCmd.withExposedPorts(value);
            }
        }.set((T[])new ExposedPort[][]{priorityConfig.createCmdExposedPorts(), cmdConfig.getExposedPorts()});
        new NotNullSetter<String[]>(){

            @Override
            protected void doSet(String[] value) {
                createContainerCmd.withPortSpecs(value);
            }
        }.set((T[])new String[][]{cmdConfig.getPortSpecs()});
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withPrivileged(value);
            }
        }.set(cmdConfig.getPrivileged());
        Boolean publishAllPorts = priorityConfig.getPublishAllPorts();
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withPublishAllPorts(value);
            }
        }.set(publishAllPorts != null ? publishAllPorts : cmdConfig.getPublishAllPorts());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withReadonlyRootfs(value);
            }
        }.set(cmdConfig.getReadonlyRootfs());
        new NotNullSetter<RestartPolicy>(){

            @Override
            protected void doSet(RestartPolicy value) {
                createContainerCmd.withRestartPolicy(value);
            }
        }.set(cmdConfig.getRestartPolicy());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withStdInOnce(value);
            }
        }.set(cmdConfig.isStdInOnce());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withStdinOpen(value);
            }
        }.set(cmdConfig.isStdinOpen());
        new NotNullSetter<Boolean>(){

            @Override
            protected void doSet(Boolean value) {
                createContainerCmd.withTty(value);
            }
        }.set(cmdConfig.isTty());
        new NotNullSetter<Ulimit[]>(){

            @Override
            protected void doSet(Ulimit[] value) {
                createContainerCmd.withUlimits(value);
            }
        }.set((T[])new Ulimit[][]{cmdConfig.getUlimits()});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withUser(value);
            }
        }.set(cmdConfig.getUser());
        new NotNullSetter<Volume[]>(){

            @Override
            protected void doSet(Volume[] value) {
                createContainerCmd.withVolumes(value);
            }
        }.set((T[])new Volume[][]{priorityConfig.createCmdVolumes(), cmdConfig.getVolumes()});
        new NotNullSetter<VolumesFrom[]>(){

            @Override
            protected void doSet(VolumesFrom[] value) {
                createContainerCmd.withVolumesFrom(value);
            }
        }.set((T[])new VolumesFrom[][]{priorityConfig.createCmdVolumesFrom(), cmdConfig.getVolumesFrom()});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withWorkingDir(value);
            }
        }.set(priorityConfig.getWorkingDir(), cmdConfig.getWorkingDir());
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                createContainerCmd.withName(value);
            }
        }.set(priorityConfig.getContainerName());
    }

    protected Bind[] prepareBinds(Bind[] binds) {
        return binds;
    }

    public String getImageUser() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec().getConfig().getUser();
            }
        }.perform();
    }

    public InputStream copyArchiveFromContainer(final String sourceDirPath) {
        return (InputStream)new ApiTaskBase<InputStream>(this.getErrorHandler()){

            @Override
            protected InputStream doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().copyArchiveFromContainerCmd(DockerAgentApplicationBase.this.getContainerId(), sourceDirPath).exec();
            }
        }.perform();
    }

    public int waitForExit() {
        return this.waitForExitImmediate(this.getErrorHandler());
    }

    public int waitForExitImmediate(CloudAgentErrorHandler errorHandler) {
        return (Integer)new ApiTaskBase<Integer>(errorHandler){

            @Override
            protected Integer doPerform() throws IOException, ApiTaskException {
                return ((WaitContainerResultCallback)DockerAgentApplicationBase.this.getClient().waitContainerCmd(DockerAgentApplicationBase.this.myContainerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            }
        }.perform();
    }

    private static class MyPipedInputStream
    extends PipedInputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private abstract class TerminalPipeBase
    extends TerminalPipe {
        private final PipedInputStream myInputStream;
        private final PipedOutputStream myReversedInputStream;
        private final OutputStream myOutputStream;
        private final PipedInputStream myReversedOutputStream;
        private final PipedInputStream myStderr;
        private final PipedOutputStream myReversedStderr;

        public TerminalPipeBase(String logPipeName, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(logPipeName, loggingHandler);
            this.myReversedOutputStream = new MyPipedInputStream();
            this.myOutputStream = new PipedOutputStream(this.myReversedOutputStream);
            this.myInputStream = new MyPipedInputStream();
            this.myReversedInputStream = new PipedOutputStream(this.myInputStream);
            this.myStderr = new MyPipedInputStream();
            this.myReversedStderr = new PipedOutputStream(this.myStderr);
        }

        protected PipedOutputStream getReversedInputStream() {
            return this.myReversedInputStream;
        }

        protected PipedInputStream getReversedOutputStream() {
            return this.myReversedOutputStream;
        }

        protected PipedOutputStream getReversedStderr() {
            return this.myReversedStderr;
        }

        public void close() {
            try {
                this.myOutputStream.close();
                this.myReversedInputStream.close();
                this.myReversedStderr.close();
            }
            catch (IOException e) {
                DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
            }
            super.close();
        }

        protected OutputStream getOutputStream() {
            return this.myOutputStream;
        }

        protected InputStream getInputStream() {
            return this.myInputStream;
        }

        protected InputStream getStderr() {
            return this.myStderr;
        }
    }

    private class DockerExecPipe
    extends TerminalPipeBase {
        public DockerExecPipe(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) throws IOException, ApiTaskException {
            super(logName, loggingHandler);
            ExecCreateCmd execCreateCmd = DockerAgentApplicationBase.this.getClient().execCreateCmd(DockerAgentApplicationBase.this.getContainerId()).withAttachStdout(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withTty(Boolean.valueOf(true)).withCmd(command);
            String execId = ((ExecCreateCmdResponse)execCreateCmd.exec()).getId();
            ExecStartCmd execStartCmd = DockerAgentApplicationBase.this.getClient().execStartCmd(execId).withDetach(Boolean.valueOf(false)).withStdIn((InputStream)this.getReversedOutputStream());
            execStartCmd.exec((ResultCallback)new ExecStartResultCallback(this.getReversedInputStream(), this.getReversedStderr()){

                public void close() throws IOException {
                    DockerExecPipe.this.close();
                    super.close();
                }
            });
        }
    }

    private static abstract class StateChangeTaskBase
    extends ApiTaskBase {
        public StateChangeTaskBase(CloudAgentErrorHandler errorHandler) {
            super(errorHandler);
        }

        @Override
        protected Object doPerform() throws IOException, ApiTaskException {
            try {
                this.doPerformStateChange();
            }
            catch (NotModifiedException e) {
                String message = e.getMessage();
                throw new NotModifiedException(message == null ? "Possibly, container is in the target state already" : message, (Throwable)e);
            }
            return null;
        }

        protected abstract void doPerformStateChange() throws IOException, ApiTaskException;
    }

    public class DocketAttachWebSocketPipe
    extends TerminalPipe {
        private final PipedInputStream myInputStream;
        private final PipedOutputStream myReverseOfInputStream;
        private final BufferedWriter myWriterOfInput;
        private final OutputStream myOutputStream;
        private final WebsocketClientEndpoint myWebsocketClientEndpoint;

        public DocketAttachWebSocketPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
            super("Attached console", loggingHandler);
            this.myInputStream = new MyPipedInputStream();
            this.myReverseOfInputStream = new PipedOutputStream(this.myInputStream);
            this.myWriterOfInput = new BufferedWriter(new OutputStreamWriter(this.myReverseOfInputStream));
            try {
                DockerClientConfig clientConfig = DockerAgentApplicationBase.this.myContext.getClientConfig();
                URI clientUri = clientConfig.getDockerHost();
                String dockerCertPath = clientConfig.getDockerCertPath();
                boolean isSsl = dockerCertPath != null && !dockerCertPath.isEmpty();
                String webSocketScheme = isSsl ? "wss" : "ws";
                String webSocketPath = "/containers/" + DockerUtil.shortedId((String)containerId) + "/attach/ws";
                URI webSocketUri = new URI(webSocketScheme, null, clientUri.getHost(), clientUri.getPort(), webSocketPath, "logs=0&stream=1&stdin=1&stdout=1&stderr=1", null);
                SSLContext sslContext = isSsl ? new LocalDirectorySSLConfig(dockerCertPath).getSSLContext() : null;
                this.myWebsocketClientEndpoint = new WebsocketClientEndpoint(webSocketUri, clientUri, sslContext, DockerAgentApplicationBase.this.getLogger()){

                    @Override
                    protected void handleMessage(String inMessage) {
                        try {
                            DocketAttachWebSocketPipe.this.myWriterOfInput.write(inMessage);
                            DocketAttachWebSocketPipe.this.myWriterOfInput.flush();
                        }
                        catch (IOException e) {
                            DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
                        }
                    }

                    public void onClose(Session session, CloseReason closeReason) {
                        DocketAttachWebSocketPipe.this.close();
                    }
                };
                this.myWriterOfInput.flush();
                this.myOutputStream = this.myWebsocketClientEndpoint.getSendStream();
            }
            catch (URISyntaxException e) {
                throw new ApiTaskException(e);
            }
            catch (DeploymentException e) {
                throw new ApiTaskException((Exception)((Object)e));
            }
        }

        public void close() {
            super.close();
            try {
                this.myWriterOfInput.flush();
                this.myReverseOfInputStream.close();
                this.myWebsocketClientEndpoint.close();
            }
            catch (IOException e) {
                DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
            }
        }

        protected OutputStream getOutputStream() {
            return this.myOutputStream;
        }

        protected InputStream getInputStream() {
            return this.myInputStream;
        }
    }

    public class DocketAttachHijackPipe
    extends TerminalPipeBase {
        public DocketAttachHijackPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
            super("Attached console", loggingHandler);
            AttachContainerCmd attachContainerCmd = DockerAgentApplicationBase.this.getClient().attachContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdIn((InputStream)this.getReversedOutputStream());
            attachContainerCmd.exec((ResultCallback)new AttachContainerResultCallback(){

                public void close() throws IOException {
                    DocketAttachHijackPipe.this.close();
                    super.close();
                }

                public void onNext(Frame item) {
                    try {
                        PipedOutputStream stream = item.getStreamType() == StreamType.STDERR ? DocketAttachHijackPipe.this.getReversedStderr() : DocketAttachHijackPipe.this.getReversedInputStream();
                        stream.write(item.getPayload());
                    }
                    catch (IOException e) {
                        DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
                    }
                }
            });
        }
    }

    private class DockerLogPipe
    extends LogPipe {
        private final StreamCallbackBase<Frame> myStreamCallback;

        public DockerLogPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(containerId, "Log", DockerAgentApplicationBase.this.getLogger(), loggingHandler);
            LogContainerCmd logContainerCmd = DockerAgentApplicationBase.this.getClient().logContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(false));
            this.myStreamCallback = new StreamCallbackBase<Frame>(DockerAgentApplicationBase.this.getLogger()){

                @Override
                protected void onNextWrite(Frame packet) throws IOException {
                    PipedOutputStream reverseOfInputStream = this.getReverseOfInputStream();
                    reverseOfInputStream.write(packet.getPayload());
                    reverseOfInputStream.flush();
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    DockerLogPipe.this.close();
                }
            };
            logContainerCmd.exec(this.myStreamCallback);
        }

        protected InputStream createInputStream(String containerId) {
            return this.myStreamCallback.getInputStream();
        }
    }
}

