/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.CreateContainerCmdImpl;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ArrayMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DockerCliParser {
    private static Map<String, Long> MEMORY_UNIT_2_RATIO = new HashMap<String, Long>();

    public void parse(CreateContainerCmdImpl cmd, String[] optionsLine) throws ApiTaskException {
        OptionHandler[] handlers = DockerCliParser.createHandlers();
        Options options = new Options();
        for (OptionHandler handler : handlers) {
            options.addOption(handler.getOption());
        }
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(options, optionsLine);
            for (OptionHandler handler : handlers) {
                handler.handle(commandLine, cmd);
            }
        }
        catch (ParseException e) {
            throw new ApiTaskException((Exception)((Object)e));
        }
    }

    private static OptionHandler[] createHandlers() {
        return new OptionHandler[]{new OptionHandler(Option.builder((String)"h").longOpt("hostname").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withHostName(value);
            }
        }, new OptionHandler(Option.builder((String)"u").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withUser(value);
            }
        }, new OptionHandler(Option.builder((String)"m").longOpt("memory").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withMemory(Long.valueOf(DockerCliParser.parseMemory(value)));
            }
        }, new OptionHandler(Option.builder().longOpt("memory-swap").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withMemorySwap(Long.valueOf(DockerCliParser.parseMemory(value)));
            }
        }, new OptionHandler(Option.builder().longOpt("cpuset-cpus").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withCpusetCpus(value);
            }
        }, new OptionHandler(Option.builder((String)"c").longOpt("cpu-shares").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withCpuShares(Integer.valueOf(Integer.parseInt(value)));
            }
        }, new OptionHandler(Option.builder().longOpt("cpu-period").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withCpuPeriod(Integer.valueOf(Integer.parseInt(value)));
            }
        }, new OptionHandler(Option.builder().longOpt("cpuset-mems").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withCpusetMems(value);
            }
        }, new OptionHandler(Option.builder().longOpt("blkio-weight").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withBlkioWeight(Integer.valueOf(Integer.parseInt(value)));
            }
        }, new BooleanOptionHandler(Option.builder().longOpt("oom-kill-disable").hasArg().optionalArg(true)){

            @Override
            protected void handleBooleanValue(boolean value) {
                this.getCmd().withOomKillDisable(Boolean.valueOf(value));
            }
        }, new OptionHandler(Option.builder((String)"a").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                if ("stdin".equalsIgnoreCase(value)) {
                    this.getCmd().withAttachStdin(Boolean.valueOf(true));
                } else if ("stdout".equalsIgnoreCase(value)) {
                    this.getCmd().withAttachStdout(Boolean.valueOf(true));
                } else if ("stderr".equalsIgnoreCase(value)) {
                    this.getCmd().withAttachStderr(Boolean.valueOf(true));
                } else {
                    throw new IllegalOptionException(this.getOption().getOpt(), value);
                }
            }
        }, new BooleanOptionHandler(Option.builder((String)"d").optionalArg(true)){

            @Override
            protected void handleBooleanValue(boolean value) {
                if (value) {
                    this.getCmd().withAttachStdin(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(false)).withAttachStderr(Boolean.valueOf(false));
                }
            }
        }, new BooleanOptionHandler(Option.builder((String)"t").optionalArg(true)){

            @Override
            protected void handleBooleanValue(boolean value) {
                this.getCmd().withTty(Boolean.valueOf(value));
            }
        }, new BooleanOptionHandler(Option.builder((String)"i").optionalArg(true)){

            @Override
            protected void handleBooleanValue(boolean value) {
                this.getCmd().withStdinOpen(Boolean.valueOf(value));
            }
        }, new OptionHandler(Option.builder((String)"e").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withEnv(values);
            }
        }, new OptionHandler(Option.builder().longOpt("entrypoint").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withEntrypoint(new String[]{value});
            }
        }, new OptionHandler(Option.builder((String)"w").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withWorkingDir(value);
            }
        }, new OptionHandler(Option.builder().longOpt("expose").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withExposedPorts((ExposedPort[])new ArrayMapping<String, ExposedPort>(){

                    protected ExposedPort mapElement(String source) {
                        return ExposedPort.parse((String)source);
                    }
                }.map((Object[])values, ExposedPort.class));
            }
        }, new OptionHandler(Option.builder().longOpt("add-host").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withExtraHosts(values);
            }
        }, new OptionHandler(Option.builder((String)"v").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                ArrayList<Bind> binds = new ArrayList<Bind>();
                for (String value : values) {
                    if (value.split(":").length == 1) {
                        volumes.add(new Volume(value));
                        continue;
                    }
                    binds.add(Bind.parse((String)value));
                }
                if (!volumes.isEmpty()) {
                    this.getCmd().withVolumes(volumes.toArray(new Volume[volumes.size()]));
                }
                if (!binds.isEmpty()) {
                    this.getCmd().withBinds(binds.toArray(new Bind[binds.size()]));
                }
            }
        }, new OptionHandler(Option.builder().longOpt("link").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withLinks(DockerCliParser.mapLinks(values, this.getOption()));
            }
        }, new OptionHandler(Option.builder().longOpt("lxc-conf").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withLxcConf((LxcConf[])new ArrayMapping<String, LxcConf>(){

                    protected LxcConf mapElement(String source) {
                        String[] parts = source.split("=", 2);
                        if (parts.length == 2) {
                            return new LxcConf(parts[0].trim(), parts[1].trim());
                        }
                        throw new IllegalOptionException(this.getOption().getLongOpt(), source);
                    }
                }.map((Object[])values, LxcConf.class));
            }
        }, new OptionHandler(Option.builder().longOpt("log-driver").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                for (LogConfig.LoggingType loggingType : LogConfig.LoggingType.values()) {
                    if (!loggingType.getType().equals(value)) continue;
                    this.getOrCreateLogConfig().setType(loggingType);
                    return;
                }
                throw new IllegalOptionException(this.getOption().getLongOpt(), value);
            }
        }, new OptionHandler(Option.builder().longOpt("log-opt").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                String[] parts;
                LogConfig logConfig = this.getOrCreateLogConfig();
                HashMap<String, String> logOptions = logConfig.getConfig();
                if (logOptions == null) {
                    logOptions = new HashMap<String, String>();
                    logConfig.setConfig(logOptions);
                }
                if ((parts = value.split("=", 2)).length != 2) {
                    throw new IllegalOptionException(this.getOption().getLongOpt(), value);
                }
                logOptions.put(parts[0].trim(), parts[1].trim());
            }
        }, new OptionHandler(Option.builder().longOpt("mac-address").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withMacAddress(value);
            }
        }, new OptionHandler(Option.builder((String)"p").longOpt("publish").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withPortBindings((PortBinding[])new ArrayMapping<String, PortBinding>(){

                    protected PortBinding mapElement(String source) {
                        return PortBinding.parse((String)source);
                    }
                }.map((Object[])values, PortBinding.class));
            }
        }, new BooleanOptionHandler(Option.builder((String)"P").longOpt("publish-all").optionalArg(true)){

            @Override
            protected void handleBooleanValue(boolean value) {
                this.getCmd().withPublishAllPorts(Boolean.valueOf(value));
            }
        }, new BooleanOptionHandler(Option.builder().longOpt("privileged").hasArg().optionalArg(true)){

            @Override
            protected void handleBooleanValue(boolean value) {
                this.getCmd().withPrivileged(Boolean.valueOf(value));
            }
        }, new OptionHandler(Option.builder().longOpt("dns").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withDns(values);
            }
        }, new OptionHandler(Option.builder().longOpt("dns-search").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withDnsSearch(values);
            }
        }, new OptionHandler(Option.builder().longOpt("volumes-from").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withVolumesFrom((VolumesFrom[])new ArrayMapping<String, VolumesFrom>(){

                    protected VolumesFrom mapElement(String source) {
                        return VolumesFrom.parse((String)source);
                    }
                }.map((Object[])values, VolumesFrom.class));
            }
        }, new OptionHandler(Option.builder().longOpt("cidfile").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withContainerIDFile(value);
            }
        }, new OptionHandler(Option.builder().longOpt("cap-add").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withCapAdd(DockerCliParser.parseCaps(values));
            }
        }, new OptionHandler(Option.builder().longOpt("cap-drop").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withCapDrop(DockerCliParser.parseCaps(values));
            }
        }, new OptionHandler(Option.builder().longOpt("restart").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                this.getCmd().withRestartPolicy(RestartPolicy.parse((String)value));
            }
        }, new OptionHandler(Option.builder().longOpt("net").hasArg()){

            @Override
            protected void handleEachValue(String value) {
                if ("none".equalsIgnoreCase(value)) {
                    this.getCmd().withNetworkDisabled(Boolean.valueOf(true));
                } else {
                    this.getCmd().withNetworkMode(value);
                }
            }
        }, new OptionHandler(Option.builder().longOpt("device").hasArg()){

            @Override
            protected void handleValueList(String[] values) {
                this.getCmd().withDevices((Device[])new ArrayMapping<String, Device>(){

                    protected Device mapElement(String source) {
                        String[] parts = source.split(":");
                        if (parts.length == 2 || parts.length == 3) {
                            return new Device(parts.length == 2 ? "" : parts[2], parts[1], parts[0]);
                        }
                        throw new IllegalOptionException(this.getOption().getLongOpt(), source);
                    }
                }.map((Object[])values, Device.class));
            }
        }};
    }

    public static Link[] mapLinks(String[] values, final Option option) {
        return (Link[])new ArrayMapping<String, Link>(){

            protected Link mapElement(String source) {
                String[] parts = source.split(":");
                if (parts.length == 1) {
                    return new Link(source, source);
                }
                if (parts.length == 2) {
                    return new Link(parts[0], parts[1]);
                }
                throw new IllegalOptionException(option.getLongOpt(), source);
            }
        }.map((Object[])values, Link.class);
    }

    private static long parseMemory(String value) {
        String unit = value.substring(value.length() - 1).toLowerCase();
        Long ratio = MEMORY_UNIT_2_RATIO.get(unit);
        return ratio == null ? Long.parseLong(value) : Long.parseLong(value.substring(0, value.length() - 1)) * ratio;
    }

    private static Capability[] parseCaps(String[] values) {
        return (Capability[])new ArrayMapping<String, Capability>(){

            protected Capability mapElement(String source) {
                return Capability.valueOf((String)source);
            }
        }.map((Object[])values, Capability.class);
    }

    static {
        MEMORY_UNIT_2_RATIO.put("b", 1L);
        MEMORY_UNIT_2_RATIO.put("k", 1024L);
        MEMORY_UNIT_2_RATIO.put("m", 0x100000L);
        MEMORY_UNIT_2_RATIO.put("g", 0x40000000L);
    }

    private static class IllegalOptionException
    extends IllegalArgumentException {
        public IllegalOptionException(String name, String value) {
            super("Error parsing option '" + name + "' value: '" + value + "'");
        }
    }

    private static abstract class BooleanOptionHandler
    extends OptionHandler {
        public BooleanOptionHandler(Option.Builder builder) {
            super(builder);
        }

        @Override
        protected void handleOptionalValue(String value) {
            boolean boolValue = value == null || Boolean.parseBoolean(value);
            this.handleBooleanValue(boolValue);
        }

        protected abstract void handleBooleanValue(boolean var1);
    }

    private static abstract class OptionHandler {
        private final Option myOption;
        private CreateContainerCmdImpl myCmd;

        public OptionHandler(Option.Builder builder) {
            this.myOption = builder.build();
        }

        public Option getOption() {
            return this.myOption;
        }

        public void handle(CommandLine commandLine, CreateContainerCmdImpl cmd) {
            String opt;
            this.myCmd = cmd;
            String string = opt = this.myOption.getOpt() == null ? this.myOption.getLongOpt() : this.myOption.getOpt();
            if (commandLine.hasOption(opt)) {
                String[] values = commandLine.getOptionValues(opt);
                boolean noValues = values == null || values.length == 0;
                this.handleOptionalValue(noValues ? null : values[0]);
                if (!noValues) {
                    this.handleValueList(values);
                }
            }
        }

        protected void handleValueList(String[] values) {
            for (String value : values) {
                this.handleEachValue(value);
            }
        }

        protected CreateContainerCmdImpl getCmd() {
            return this.myCmd;
        }

        protected LogConfig getOrCreateLogConfig() {
            LogConfig result = this.myCmd.getLogConfig();
            this.myCmd.withLogConfig(result);
            return result;
        }

        protected void handleOptionalValue(String value) {
        }

        protected void handleEachValue(String value) {
        }
    }
}

