/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerProgressDetail;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.Closeable;
import java.io.IOException;

public class ResultCallbackImpl<T extends ResponseItem>
implements ResultCallback<T> {
    private final DockerAgentProgressCallback myAgentCallback;
    private final CloudAgentLogger myLogger;
    private String myErrorMessage;
    private String mySuccessMessage;

    public ResultCallbackImpl(DockerAgentProgressCallback callback, CloudAgentLogger logger) {
        this.myAgentCallback = callback;
        this.myLogger = logger;
    }

    public void onStart(Closeable closeable) {
    }

    public void onNext(T item) {
        String progress;
        String status;
        StringBuilder statusBuilder = new StringBuilder();
        String error = item.getError();
        if (error != null) {
            statusBuilder.append(error);
            this.myErrorMessage = error;
        }
        if ((status = item.getStatus()) != null) {
            statusBuilder.append(status);
        }
        if ((progress = item.getProgress()) != null) {
            statusBuilder.append(" ");
            statusBuilder.append(progress.substring(progress.indexOf(93) + 1));
        }
        int current = 0;
        int total = 0;
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        if (progressDetail != null) {
            ObjectMapper jsonMapper = new ObjectMapper();
            try {
                String progressDetailValue = jsonMapper.writeValueAsString((Object)progressDetail);
                DockerProgressDetail exposedProgressDetail = (DockerProgressDetail)jsonMapper.readValue(progressDetailValue, DockerProgressDetail.class);
                current = exposedProgressDetail.myCurrent;
                total = exposedProgressDetail.myTotal;
            }
            catch (JsonProcessingException e) {
                this.myLogger.debugEx((Exception)((Object)e));
            }
            catch (IOException e) {
                this.myLogger.debugEx((Exception)e);
            }
        }
        this.myAgentCallback.step(statusBuilder.toString(), (long)current, (long)total);
    }

    public void onError(Throwable throwable) {
        this.myAgentCallback.failed(throwable.toString());
        this.myLogger.debugEx(new Exception(throwable));
    }

    public void onComplete() {
        if (this.myErrorMessage != null) {
            this.myAgentCallback.failed(this.myErrorMessage);
        } else {
            this.myAgentCallback.succeeded(this.mySuccessMessage);
        }
    }

    public void close() throws IOException {
    }

    protected void setSuccessMessage(String successMessage) {
        this.mySuccessMessage = successMessage;
    }
}

