/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public abstract class WebsocketClientEndpoint
extends Endpoint {
    private static final String ORIGIN_HEADER = "Origin";
    private final Session mySession;
    private final CloudAgentLogger myLogger;

    public WebsocketClientEndpoint(URI endpointURI, final URI originUri, SSLContext sslContext, CloudAgentLogger logger) throws IOException, DeploymentException {
        this.myLogger = logger;
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        ClientEndpointConfig.Builder configBuilder = ClientEndpointConfig.Builder.create();
        configBuilder.configurator(new ClientEndpointConfig.Configurator(){

            public void beforeRequest(Map<String, List<String>> headers) {
                headers.put(WebsocketClientEndpoint.ORIGIN_HEADER, Arrays.asList(originUri.toString()));
            }
        });
        ClientEndpointConfig config = configBuilder.build();
        if (sslContext != null) {
            Map userProperties = config.getUserProperties();
            userProperties.put("org.apache.tomcat.websocket.SSL_CONTEXT", sslContext);
        }
        this.mySession = container.connectToServer((Endpoint)this, config, endpointURI);
    }

    public void close() throws IOException {
        this.mySession.close();
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String s) {
                WebsocketClientEndpoint.this.handleMessage(s);
            }
        });
    }

    public void onError(Session session, Throwable thr) {
        this.myLogger.debug(thr.toString());
    }

    public OutputStream getSendStream() throws IOException {
        return this.mySession.getBasicRemote().getSendStream();
    }

    protected abstract void handleMessage(String var1);
}

