/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.netty.WebTarget;
import com.intellij.docker.agent.fix.FixedAuthCmdExec;
import com.intellij.docker.agent.netty.DockerCmdExecNettyFactoryCopyImpl;
import com.intellij.docker.agent.netty.WebTargetFixed;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ThreadFactory;

public class FixedDockerCmdExecNettyFactoryCopyImpl
extends DockerCmdExecNettyFactoryCopyImpl {
    @Override
    protected DockerCmdExecNettyFactoryCopyImpl.NettyInitializer createUnixDomainSocketInitializer() {
        if (Epoll.isAvailable()) {
            return new DockerCmdExecNettyFactoryCopyImpl.UnixDomainSocketInitializer(this);
        }
        if (KQueue.isAvailable()) {
            return new KQueueDomainSocketInitializer();
        }
        throw new IllegalStateException("Neither Epoll nor KQueue support available for Unix domain socket connection", KQueue.unavailabilityCause());
    }

    @Override
    protected WebTarget getBaseResource() {
        return new WebTargetFixed(this.channelProvider);
    }

    @Override
    public AuthCmd.Exec createAuthCmdExec() {
        return new FixedAuthCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    private static class KQueueDomainSocketInitializer
    implements DockerCmdExecNettyFactoryCopyImpl.NettyInitializer {
        private volatile String mySocketPath;

        private KQueueDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            if (dockerClientConfig.getDockerHost().getPath() == null) {
                throw new IllegalStateException("Path must not be null");
            }
            this.mySocketPath = dockerClientConfig.getDockerHost().getPath();
            KQueueEventLoopGroup nioEventLoopGroup = new KQueueEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(threadPrefix));
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(KQueueDomainSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<KQueueDomainSocketChannel>(){

                protected void initChannel(KQueueDomainSocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(((Object)((Object)this)).getClass())});
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            if (this.mySocketPath == null) {
                throw new IllegalStateException("socket path is not initialized");
            }
            if (!Files.exists(Paths.get(this.mySocketPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("socket not found: " + this.mySocketPath);
            }
            DomainSocketAddress address = new DomainSocketAddress(this.mySocketPath);
            return (DuplexChannel)bootstrap.connect((SocketAddress)address).sync().channel();
        }
    }
}

