/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;

public class FixedHttpConnectionHijackHandler
implements HttpClientUpgradeHandler.UpgradeCodec {
    private CountDownLatch latch = new CountDownLatch(1);
    private ChannelInboundHandler httpResponseHandler;

    public FixedHttpConnectionHijackHandler(ChannelInboundHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        this.httpResponseHandler.channelRead(ctx, (Object)upgradeResponse);
        ctx.pipeline().addLast(new ChannelHandler[]{this.httpResponseHandler});
        this.latch.countDown();
    }

    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        return Collections.emptyList();
    }

    public CharSequence protocol() {
        return "tcp";
    }

    public void awaitUpgrade() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

