/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerCompose;

import com.intellij.docker.agent.ApiTaskException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class DockerComposeFile {
    private File myFile;

    public DockerComposeFile(File file) {
        this.myFile = file;
    }

    private Object getRoot() throws IOException, ApiTaskException {
        Yaml yaml = new Yaml();
        try {
            return yaml.load((InputStream)new FileInputStream(this.myFile));
        }
        catch (YAMLException e) {
            throw new ApiTaskException((Exception)((Object)e));
        }
    }

    public List<String> getServices() throws IOException, ApiTaskException {
        Map servicesMap = (Map)this.getRoot();
        if (servicesMap == null) {
            throw new ApiTaskException("No services found");
        }
        ArrayList<String> containerModels = new ArrayList<String>();
        for (Map.Entry serviceObject : servicesMap.entrySet()) {
            Map.Entry serviceMap = serviceObject;
            HashMap serviceParameters = (HashMap)serviceMap.getValue();
            if (serviceParameters == null) continue;
            containerModels.add(serviceMap.getKey().toString());
        }
        return containerModels;
    }
}

