/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BitInputStream;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public final class DataReaderStrips
extends DataReader {
    private final int bitsPerPixel;
    private final int width;
    private final int height;
    private final int compression;
    private final int rowsPerStrip;
    private final TiffImageData.Strips imageData;
    private int x = 0;
    private int y = 0;

    public DataReaderStrips(PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, int rowsPerStrip, TiffImageData.Strips imageData) {
        super(photometricInterpreter, bitsPerSample, predictor, samplesPerPixel);
        this.bitsPerPixel = bitsPerPixel;
        this.width = width;
        this.height = height;
        this.compression = compression;
        this.rowsPerStrip = rowsPerStrip;
        this.imageData = imageData;
    }

    private void interpretStrip(BufferedImage bi, byte[] bytes, int pixels_per_strip) throws ImageReadException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitInputStream bis = new BitInputStream(bais);
        for (int i = 0; i < pixels_per_strip; ++i) {
            int[] samples = this.getSamplesAsBytes(bis);
            if (this.x < this.width && this.y < this.height) {
                samples = this.applyPredictor(samples, this.x);
                this.photometricInterpreter.interpretPixel(bi, samples, this.x, this.y);
            }
            ++this.x;
            if (this.x < this.width) continue;
            this.x = 0;
            ++this.y;
            bis.flushCache();
            if (this.y >= this.height) break;
        }
    }

    @Override
    public void readImageData(BufferedImage bi) throws ImageReadException, IOException {
        for (int strip = 0; strip < this.imageData.strips.length; ++strip) {
            int rowsRemaining = this.height - strip * this.rowsPerStrip;
            int rowsInThisStrip = Math.min(rowsRemaining, this.rowsPerStrip);
            int pixelsPerStrip = rowsInThisStrip * this.width;
            int bytesPerStrip = (pixelsPerStrip * this.bitsPerPixel + 7) / 8;
            byte[] compressed = this.imageData.strips[strip].data;
            byte[] decompressed = this.decompress(compressed, this.compression, bytesPerStrip);
            this.interpretStrip(bi, decompressed, pixelsPerStrip);
        }
    }
}

