/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.jba;

import com.intellij.ide.RegionUrlMapper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.settingsSync.core.AbstractServerCommunicator;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncStatusTracker;
import com.intellij.settingsSync.core.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import com.intellij.settingsSync.jba.CloudConfigVersionContext;
import com.intellij.settingsSync.jba.SettingsSyncJbaBundle;
import com.intellij.settingsSync.jba.auth.JBAAuthService;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.util.net.PlatformHttpClient;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.HeaderStorage;
import com.jetbrains.cloudconfig.auth.AuthProvider;
import com.jetbrains.cloudconfig.auth.JbaJwtTokenAuthProvider;
import com.jetbrains.cloudconfig.exception.UnauthorizedException;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 32\u00020\u0001:\u00013B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0016H\u0014J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J$\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020\u0019H\u0014J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*2\u0006\u0010\u001a\u001a\u00020\u0003J\u001f\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\tH\u0011\u00a2\u0006\u0002\b.J\n\u0010/\u001a\u0004\u0018\u000100H\u0002J\b\u00101\u001a\u00020\u001cH\u0002J\b\u00102\u001a\u00020\u001cH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0004\u0018\u00010\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00118PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\f\u00a8\u00064"}, d2={"Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator;", "Lcom/intellij/settingsSync/core/AbstractServerCommunicator;", "serverUrl", "", "jbaAuthService", "Lcom/intellij/settingsSync/jba/auth/JBAAuthService;", "<init>", "(Ljava/lang/String;Lcom/intellij/settingsSync/jba/auth/JBAAuthService;)V", "clientVersionContext", "Lcom/intellij/settingsSync/jba/CloudConfigVersionContext;", "currentIdTokenVar", "getCurrentIdTokenVar$intellij_settingsSync", "()Ljava/lang/String;", "setCurrentIdTokenVar$intellij_settingsSync", "(Ljava/lang/String;)V", "clientRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "client", "getClient$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "lastRemoteErrorRef", "", "readFileInternal", "Lkotlin/Pair;", "Ljava/io/InputStream;", "filePath", "requestSuccessful", "", "handleRemoteError", "e", "downloadSnapshot", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "getLatestVersion", "deleteFileInternal", "userId", "getUserId", "writeFileInternal", "versionId", "content", "fetchHistory", "", "createCloudConfigClient", "url", "versionContext", "createCloudConfigClient$intellij_settingsSync", "createConfiguration", "Lcom/jetbrains/cloudconfig/Configuration;", "setAuthActionRequired", "dispose", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nCloudConfigServerCommunicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/jba/CloudConfigServerCommunicator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n13#2:234\n*S KotlinDebug\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/jba/CloudConfigServerCommunicator\n*L\n223#1:234\n*E\n"})
public class CloudConfigServerCommunicator
extends AbstractServerCommunicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String serverUrl;
    @NotNull
    private final JBAAuthService jbaAuthService;
    @NotNull
    private final CloudConfigVersionContext clientVersionContext;
    @VisibleForTesting
    @Nullable
    private volatile String currentIdTokenVar;
    @NotNull
    private final AtomicReference<CloudConfigFileClientV2> clientRef;
    @NotNull
    private final AtomicReference<Throwable> lastRemoteErrorRef;
    private static final int CONNECTION_TIMEOUT_MS = 10000;
    private static final int READ_TIMEOUT_MS = 50000;
    @NotNull
    private static final String URL_PROVIDER = "https://www.jetbrains.com/config/IdeaCloudConfig.xml";
    @NotNull
    private static final String DEFAULT_PRODUCTION_URL = "https://cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String DEFAULT_DEBUG_URL = "https://stgn.cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String URL_PROPERTY = "idea.settings.sync.cloud.url";
    @NotNull
    private static final Lazy<String> defaultUrl$delegate = LazyKt.lazy(CloudConfigServerCommunicator::defaultUrl_delegate$lambda$0);
    @NotNull
    private static final Logger LOG;
    @VisibleForTesting
    @NotNull
    private static final ETagStorage DUMMY_E_TAG_STORAGE;

    public CloudConfigServerCommunicator(@Nullable String serverUrl, @NotNull JBAAuthService jbaAuthService) {
        Intrinsics.checkNotNullParameter((Object)jbaAuthService, (String)"jbaAuthService");
        this.serverUrl = serverUrl;
        this.jbaAuthService = jbaAuthService;
        this.clientVersionContext = new CloudConfigVersionContext();
        this.clientRef = new AtomicReference();
        this.lastRemoteErrorRef = new AtomicReference();
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            public void loginStateChanged() {
                clientRef.set(null);
            }
        });
    }

    @Nullable
    public final String getCurrentIdTokenVar$intellij_settingsSync() {
        return this.currentIdTokenVar;
    }

    public final void setCurrentIdTokenVar$intellij_settingsSync(@Nullable String string) {
        this.currentIdTokenVar = string;
    }

    @NotNull
    public CloudConfigFileClientV2 getClient$intellij_settingsSync() {
        if (this.clientRef.get() == null) {
            String string = this.serverUrl;
            if (string == null) {
                string = Companion.getDefaultUrl$intellij_settingsSync();
            }
            this.clientRef.set(this.createCloudConfigClient$intellij_settingsSync(string, this.clientVersionContext));
        }
        CloudConfigFileClientV2 cloudConfigFileClientV2 = this.clientRef.get();
        if (cloudConfigFileClientV2 == null) {
            throw new IOException("Communicator is not ready yet");
        }
        return cloudConfigFileClientV2;
    }

    @NotNull
    protected Pair<InputStream, String> readFileInternal(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return (Pair)this.clientVersionContext.doWithVersion(filePath, null, arg_0 -> CloudConfigServerCommunicator.readFileInternal$lambda$0(this, arg_0));
    }

    protected void requestSuccessful() {
        if (this.lastRemoteErrorRef.get() != null) {
            LOG.info("Connection to setting sync server is restored");
        }
        this.lastRemoteErrorRef.set(null);
    }

    @NotNull
    protected String handleRemoteError(@NotNull Throwable e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            Throwable throwable = this.lastRemoteErrorRef.get();
            if (!Intrinsics.areEqual((Object)(throwable != null ? throwable.getMessage() : null), (Object)e.getMessage())) {
                this.lastRemoteErrorRef.set(e);
                LOG.warn(defaultMessage + ": " + e.getMessage());
            }
        } else if (e instanceof UnauthorizedException) {
            String string2 = this.currentIdTokenVar;
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                LOG.warn("Got \"Unauthorized\" from Settings Sync server. Settings Sync will be disabled. Please login to JBA again");
                this.setAuthActionRequired();
                this.jbaAuthService.invalidateJBA(it);
            }
        } else {
            LOG.error(e);
        }
        if ((string = e.getMessage()) == null) {
            string = defaultMessage;
        }
        return string;
    }

    @Nullable
    public final InputStream downloadSnapshot(@NotNull String filePath, @NotNull FileVersionInfo version) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        InputStream stream = (InputStream)this.clientVersionContext.doWithVersion(filePath, version.getVersionId(), arg_0 -> CloudConfigServerCommunicator.downloadSnapshot$lambda$0(this, arg_0));
        if (stream == null) {
            LOG.info(filePath + " not found on the server");
        }
        return stream;
    }

    @Nullable
    protected String getLatestVersion(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileVersionInfo fileVersionInfo = this.getClient$intellij_settingsSync().getLatestVersion(filePath);
        return fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
    }

    protected void deleteFileInternal(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getClient$intellij_settingsSync().delete(filePath);
    }

    @NotNull
    public String getUserId() {
        return "jba";
    }

    @Nullable
    protected String writeFileInternal(@NotNull String filePath, @Nullable String versionId, @NotNull InputStream content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return (String)this.clientVersionContext.doWithVersion(filePath, versionId, arg_0 -> CloudConfigServerCommunicator.writeFileInternal$lambda$0(this, content, arg_0));
    }

    @NotNull
    public final List<FileVersionInfo> fetchHistory(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List list = this.getClient$intellij_settingsSync().getVersions(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVersions(...)");
        return list;
    }

    @VisibleForTesting
    @Nullable
    public CloudConfigFileClientV2 createCloudConfigClient$intellij_settingsSync(@NotNull String url, @NotNull CloudConfigVersionContext versionContext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Configuration configuration = this.createConfiguration();
        if (configuration == null) {
            return null;
        }
        Configuration conf = configuration;
        return new CloudConfigFileClientV2(url, conf, DUMMY_E_TAG_STORAGE, (HeaderStorage)versionContext);
    }

    private final Configuration createConfiguration() {
        String idToken;
        Configuration configuration = new Configuration().connectTimeout(10000).readTimeout(50000);
        this.currentIdTokenVar = idToken = this.jbaAuthService.getIdToken();
        if (idToken == null) {
            JBAccountInfoService jBAccountInfoService = this.jbaAuthService.getAccountInfoService();
            if ((jBAccountInfoService != null ? jBAccountInfoService.getUserData() : null) != null) {
                this.setAuthActionRequired();
            }
            return null;
        }
        configuration.auth((AuthProvider)new JbaJwtTokenAuthProvider(idToken));
        return configuration;
    }

    private final void setAuthActionRequired() {
        if (SettingsSyncStatusTracker.Companion.getInstance().getCurrentStatus() instanceof SettingsSyncStatusTracker.SyncStatus.ActionRequired) {
            return;
        }
        this.jbaAuthService.setAuthRequiredAction$intellij_settingsSync(new SettingsSyncAuthService.PendingUserAction(SettingsSyncJbaBundle.INSTANCE.message("action.settingsSync.authRequired", new Object[0]), SettingsSyncBundle.INSTANCE.message("config.button.login", new Object[0]), SettingsSyncJbaBundle.INSTANCE.message("action.settingsSync.authRequired.text", new Object[0]), (Function2)new Function2<Component, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Component)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.label = 1;
                        v0 = CloudConfigServerCommunicator.access$getJbaAuthService$p(this.this$0).login((Component)it, (Continuation<? super SettingsSyncUserData>)((Continuation)this));
                        if (v0 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if ((userData = (SettingsSyncUserData)v0) != null) {
                            CloudConfigServerCommunicator.access$getJbaAuthService$p(this.this$0).setAuthRequiredAction$intellij_settingsSync(null);
                            SettingsSyncStatusTracker.Companion.getInstance().updateOnSuccess();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Component p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing...");
        }
        this.clientRef.set(null);
        this.currentIdTokenVar = null;
    }

    private static final Pair readFileInternal$lambda$0(CloudConfigServerCommunicator this$0, String filePath) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            InputStream stream = this$0.getClient$intellij_settingsSync().read(filePath);
            String actualVersion = this$0.clientVersionContext.get(filePath);
            if (actualVersion == null) {
                LOG.warn("Version not stored in the context for " + filePath + " [r]");
            }
            pair = new Pair((Object)stream, (Object)actualVersion);
        }
        catch (FileNotFoundException fileNotFoundException) {
            pair = new Pair(null, null);
        }
        return pair;
    }

    private static final InputStream downloadSnapshot$lambda$0(CloudConfigServerCommunicator this$0, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this$0.getClient$intellij_settingsSync().read(path);
    }

    private static final String writeFileInternal$lambda$0(CloudConfigServerCommunicator this$0, InputStream $content, String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this$0.getClient$intellij_settingsSync().write(filePath, $content);
        String actualVersion = this$0.clientVersionContext.get(filePath);
        if (actualVersion == null) {
            LOG.warn("Version not stored in the context for " + filePath + " [w]");
        }
        return actualVersion;
    }

    private static final String defaultUrl_delegate$lambda$0() {
        String string;
        String explicitUrl = System.getProperty(URL_PROPERTY);
        if (explicitUrl != null) {
            LOG.info("Using SettingSync server URL (from properties): " + explicitUrl);
            return explicitUrl;
        }
        if (PluginManagerCore.isRunningFromSources()) {
            LOG.info("Using SettingSync server URL (DEBUG): https://stgn.cloudconfig.jetbrains.com/cloudconfig");
            return DEFAULT_DEBUG_URL;
        }
        try {
            String string2 = RegionUrlMapper.tryMapUrlBlocking((String)URL_PROVIDER);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tryMapUrlBlocking(...)");
            String regionalUrl = string2;
            HttpRequest request = PlatformHttpClient.request((URI)new URI(regionalUrl));
            HttpResponse response = PlatformHttpClient.checkResponse(PlatformHttpClient.client().send(request, HttpResponse.BodyHandlers.ofByteArray()));
            String configUrl = JDOMUtil.load((byte[])((byte[])response.body())).getAttributeValue("baseUrl");
            LOG.info("Using SettingSync server URL: " + configUrl);
            string = configUrl;
        }
        catch (Exception e) {
            LOG.warn("Failed to obtain a SettingSync server URL", (Throwable)e);
            LOG.info("Using SettingSync server URL (fallback): https://cloudconfig.jetbrains.com/cloudconfig");
            string = DEFAULT_PRODUCTION_URL;
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        return string3;
    }

    public static final /* synthetic */ JBAAuthService access$getJbaAuthService$p(CloudConfigServerCommunicator $this) {
        return $this.jbaAuthService;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigServerCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DUMMY_E_TAG_STORAGE = new ETagStorage(){

            public String get(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return null;
            }

            public void store(String path, String value) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void remove(String path) {
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u00020\u00148\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator$Companion;", "", "<init>", "()V", "CONNECTION_TIMEOUT_MS", "", "READ_TIMEOUT_MS", "URL_PROVIDER", "", "DEFAULT_PRODUCTION_URL", "DEFAULT_DEBUG_URL", "URL_PROPERTY", "defaultUrl", "getDefaultUrl$intellij_settingsSync", "()Ljava/lang/String;", "defaultUrl$delegate", "Lkotlin/Lazy;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DUMMY_E_TAG_STORAGE", "Lcom/jetbrains/cloudconfig/ETagStorage;", "getDUMMY_E_TAG_STORAGE$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/ETagStorage;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultUrl$intellij_settingsSync() {
            Lazy lazy = defaultUrl$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final ETagStorage getDUMMY_E_TAG_STORAGE$intellij_settingsSync() {
            return DUMMY_E_TAG_STORAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

