/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.editor.RangeMarker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c2\u0003JA\u0010'\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010(\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\tH\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0014\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/CommandBlockImpl;", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "command", "", "prompt", "rightPrompt", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "commandAndRightPromptLength", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/editor/RangeMarker;I)V", "getCommand", "()Ljava/lang/String;", "getPrompt", "getRightPrompt", "getRange", "()Lcom/intellij/openapi/editor/RangeMarker;", "startOffset", "getStartOffset", "()I", "endOffset", "getEndOffset", "commandStartOffset", "getCommandStartOffset", "outputStartOffset", "getOutputStartOffset", "trimmedLinesCount", "getTrimmedLinesCount", "setTrimmedLinesCount", "(I)V", "isFinalized", "", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "intellij.terminal"})
public final class CommandBlockImpl
implements CommandBlock {
    @Nullable
    private final String command;
    @Nullable
    private final String prompt;
    @Nullable
    private final String rightPrompt;
    @NotNull
    private final RangeMarker range;
    private final int commandAndRightPromptLength;
    private int trimmedLinesCount;

    public CommandBlockImpl(@Nullable String command2, @Nullable String prompt, @Nullable String rightPrompt, @NotNull RangeMarker range, int commandAndRightPromptLength) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.command = command2;
        this.prompt = prompt;
        this.rightPrompt = rightPrompt;
        this.range = range;
        this.commandAndRightPromptLength = commandAndRightPromptLength;
    }

    @Override
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    @Nullable
    public String getRightPrompt() {
        return this.rightPrompt;
    }

    @NotNull
    public final RangeMarker getRange() {
        return this.range;
    }

    @Override
    public int getStartOffset() {
        return this.range.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.range.getEndOffset();
    }

    @Override
    public int getCommandStartOffset() {
        int n = this.range.getStartOffset();
        String string = this.getPrompt();
        if (string == null) {
            string = "";
        }
        return n + string.length();
    }

    @Override
    public int getOutputStartOffset() {
        return this.getCommandStartOffset() + (this.commandAndRightPromptLength > 0 ? this.commandAndRightPromptLength + 1 : 0);
    }

    @Override
    public int getTrimmedLinesCount() {
        return this.trimmedLinesCount;
    }

    @Override
    public void setTrimmedLinesCount(int n) {
        this.trimmedLinesCount = n;
    }

    @Override
    public boolean isFinalized() {
        return !this.range.isGreedyToRight();
    }

    @Nullable
    public final String component1() {
        return this.command;
    }

    @Nullable
    public final String component2() {
        return this.prompt;
    }

    @Nullable
    public final String component3() {
        return this.rightPrompt;
    }

    @NotNull
    public final RangeMarker component4() {
        return this.range;
    }

    private final int component5() {
        return this.commandAndRightPromptLength;
    }

    @NotNull
    public final CommandBlockImpl copy(@Nullable String command2, @Nullable String prompt, @Nullable String rightPrompt, @NotNull RangeMarker range, int commandAndRightPromptLength) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new CommandBlockImpl(command2, prompt, rightPrompt, range, commandAndRightPromptLength);
    }

    public static /* synthetic */ CommandBlockImpl copy$default(CommandBlockImpl commandBlockImpl, String string, String string2, String string3, RangeMarker rangeMarker, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = commandBlockImpl.command;
        }
        if ((n2 & 2) != 0) {
            string2 = commandBlockImpl.prompt;
        }
        if ((n2 & 4) != 0) {
            string3 = commandBlockImpl.rightPrompt;
        }
        if ((n2 & 8) != 0) {
            rangeMarker = commandBlockImpl.range;
        }
        if ((n2 & 0x10) != 0) {
            n = commandBlockImpl.commandAndRightPromptLength;
        }
        return commandBlockImpl.copy(string, string2, string3, rangeMarker, n);
    }

    @NotNull
    public String toString() {
        return "CommandBlockImpl(command=" + this.command + ", prompt=" + this.prompt + ", rightPrompt=" + this.rightPrompt + ", range=" + this.range + ", commandAndRightPromptLength=" + this.commandAndRightPromptLength + ")";
    }

    public int hashCode() {
        int result = this.command == null ? 0 : this.command.hashCode();
        result = result * 31 + (this.prompt == null ? 0 : this.prompt.hashCode());
        result = result * 31 + (this.rightPrompt == null ? 0 : this.rightPrompt.hashCode());
        result = result * 31 + this.range.hashCode();
        result = result * 31 + Integer.hashCode(this.commandAndRightPromptLength);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandBlockImpl)) {
            return false;
        }
        CommandBlockImpl commandBlockImpl = (CommandBlockImpl)other;
        if (!Intrinsics.areEqual((Object)this.command, (Object)commandBlockImpl.command)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prompt, (Object)commandBlockImpl.prompt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rightPrompt, (Object)commandBlockImpl.rightPrompt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.range, (Object)commandBlockImpl.range)) {
            return false;
        }
        return this.commandAndRightPromptLength == commandBlockImpl.commandAndRightPromptLength;
    }
}

