/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.Alarm;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.TextStyle;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.hyperlinks.Gen1TerminalHyperlinkHighlighter;
import org.jetbrains.plugins.terminal.block.output.BlockTerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImplKt;
import org.jetbrains.plugins.terminal.block.output.CommandBlockInfo;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.PartialCommandOutput;
import org.jetbrains.plugins.terminal.block.output.TerminalBlocksDecorator;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretModel;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.block.output.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputContentUpdatesScheduler;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.output.highlighting.CompositeTerminalTextHighlighter;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.session.impl.StyleRange;
import org.jetbrains.plugins.terminal.util.ShellType;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 T2\u00020\u0001:\u0003RSTB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010&\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0007J\u0012\u0010+\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010(H\u0003J\b\u0010,\u001a\u00020%H\u0003J\u000e\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020%H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020%H\u0007J\b\u00105\u001a\u00020%H\u0007J\u0015\u00106\u001a\u00020%2\u0006\u00107\u001a\u000208H\u0001\u00a2\u0006\u0002\b9J\u0010\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020<H\u0003J\u0010\u0010=\u001a\u00020%2\u0006\u0010;\u001a\u00020<H\u0003J\u0018\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020/H\u0002J\u0018\u0010A\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u0010;\u001a\u00020<H\u0002J&\u0010B\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u0010C\u001a\u00020/2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J\f\u0010G\u001a\u00020H*\u00020IH\u0002J\u001a\u0010J\u001a\u00020%2\u0006\u0010K\u001a\u00020L2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010NJ\u0016\u0010O\u001a\u00020%2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020%0$H\u0007J\b\u0010Q\u001a\u000208H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "focusModel", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;)V", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "getSelectionModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "blocksDecorator", "Lorg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator;", "textHighlighter", "Lorg/jetbrains/plugins/terminal/block/output/TerminalTextHighlighter;", "blockCreationAlarm", "Lcom/intellij/util/Alarm;", "runningCommandContext", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandContext;", "runningCommandInteractivity", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandInteractivity;", "hyperlinkHighlighter", "Lorg/jetbrains/plugins/terminal/block/hyperlinks/Gen1TerminalHyperlinkHighlighter;", "nextBlockCanBeStartedQueue", "Ljava/util/Queue;", "Lkotlin/Function0;", "", "startCommandBlock", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "installRunningCommandInteractivity", "disposeRunningCommandInteractivity", "finishCommandBlock", "exitCode", "", "scheduleLastOutputUpdate", "trimLastEmptyLine", "block", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "insertEmptyLine", "scrollToBottom", "alternateBufferStateChanged", "enabled", "", "alternateBufferStateChanged$intellij_terminal", "updateCommandOutput", "output", "Lorg/jetbrains/plugins/terminal/block/output/PartialCommandOutput;", "doUpdateCommandOutput", "createNewBlock", "context", "terminalWidth", "updateBlock", "updateHighlightings", "replaceOffset", "styles", "", "Lorg/jetbrains/plugins/terminal/session/impl/StyleRange;", "toTextAttributesProvider", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "Lcom/jediterm/terminal/TextStyle;", "addDocumentListener", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "doWhenNextBlockCanBeStarted", "callback", "isCommandRunning", "RunningCommandContext", "RunningCommandInteractivity", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalOutputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,418:1\n23#2:419\n23#2:430\n23#2:439\n158#3,7:420\n158#3,7:453\n774#4:427\n865#4,2:428\n1563#4:445\n1634#4,3:446\n565#5:431\n566#5,6:433\n529#5,5:440\n565#5:449\n566#5,2:451\n570#5,2:460\n565#5:462\n566#5,6:464\n1#6:432\n1#6:450\n1#6:463\n*S KotlinDebug\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputController\n*L\n113#1:419\n242#1:430\n274#1:439\n158#1:420,7\n103#1:453,7\n217#1:427\n217#1:428,2\n343#1:445\n343#1:446,3\n263#1:431\n263#1:433,6\n294#1:440,5\n102#1:449\n102#1:451,2\n102#1:460,2\n131#1:462\n131#1:464,6\n263#1:432\n102#1:450\n131#1:463\n*E\n"})
public final class TerminalOutputController
implements TerminalModel.TerminalListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalBlocksDecorator blocksDecorator;
    @NotNull
    private final TerminalTextHighlighter textHighlighter;
    @NotNull
    private final Alarm blockCreationAlarm;
    @Nullable
    private RunningCommandContext runningCommandContext;
    @Nullable
    private volatile RunningCommandInteractivity runningCommandInteractivity;
    @NotNull
    private final Gen1TerminalHyperlinkHighlighter hyperlinkHighlighter;
    @NotNull
    private final Queue<Function0<Unit>> nextBlockCanBeStartedQueue;
    @NotNull
    private static final DataKey<TerminalOutputController> KEY = DataKey.Companion.create("TerminalOutputController");

    public TerminalOutputController(@NotNull Project project, @NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalFocusModel focusModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        this.project = project;
        this.editor = editor;
        this.session = session2;
        this.settings = settings;
        this.outputModel = new TerminalOutputModelImpl(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.blocksDecorator = new TerminalBlocksDecorator(this.session.getColorPalette(), this.outputModel, focusModel, this.selectionModel, this.editor);
        this.textHighlighter = new TerminalTextHighlighter(this.outputModel);
        this.blockCreationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.session);
        this.hyperlinkHighlighter = new Gen1TerminalHyperlinkHighlighter(this.project, this.outputModel, this.session);
        this.nextBlockCanBeStartedQueue = new LinkedList();
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_EDITOR_KEY$intellij_terminal(), (Object)true);
        this.editor.setHighlighter((EditorHighlighter)new CompositeTerminalTextHighlighter(this.outputModel, this.textHighlighter, this.session));
        TerminalModel.addTerminalListener$default(this.session.getModel(), this, null, 2, null);
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void clearInvoked() {
                Disposable disposable = Disposer.newDisposable((Disposable)session);
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                session.addCommandListener(new ShellCommandListener(this, disposable2){
                    final /* synthetic */ TerminalOutputController this$0;
                    final /* synthetic */ Disposable $disposable;
                    {
                        this.this$0 = $receiver;
                        this.$disposable = $disposable;
                    }

                    public void commandFinished(CommandFinishedEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)TerminalOutputController.access$getEditor$p(this.this$0));
                        ModalityState modalityState = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> clearInvoked.1.commandFinished$lambda$0(this.this$0));
                        Disposer.dispose((Disposable)this.$disposable);
                    }

                    private static final void commandFinished$lambda$0(TerminalOutputController this$0) {
                        this$0.getOutputModel().clearBlocks();
                    }
                }, disposable2);
            }
        }, null, 2, null);
    }

    @NotNull
    public final TerminalOutputModel getOutputModel() {
        return this.outputModel;
    }

    @NotNull
    public final TerminalSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @RequiresEdt
    public final void startCommandBlock(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt) {
        RunningCommandContext newRunningCommandContext;
        this.scrollToBottom();
        this.installRunningCommandInteractivity(command2);
        this.runningCommandContext = newRunningCommandContext = new RunningCommandContext(command2, prompt);
        Function0 createBlockRequest = () -> TerminalOutputController.startCommandBlock$lambda$0(this, newRunningCommandContext);
        this.blockCreationAlarm.addRequest(() -> TerminalOutputController.startCommandBlock$lambda$1(createBlockRequest), 200);
    }

    @RequiresEdt(generateAssertion=false)
    private final void installRunningCommandInteractivity(String command2) {
        if (this.runningCommandInteractivity != null) {
            TerminalOutputController $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalOutputController.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Running command interactivity is already installed");
            this.disposeRunningCommandInteractivity();
        }
        this.runningCommandInteractivity = new RunningCommandInteractivity(command2);
    }

    @RequiresEdt(generateAssertion=false)
    private final void disposeRunningCommandInteractivity() {
        if (this.runningCommandInteractivity == null) {
            throw new IllegalStateException("No running command interactivity".toString());
        }
        RunningCommandInteractivity runningCommandInteractivity = this.runningCommandInteractivity;
        Intrinsics.checkNotNull((Object)runningCommandInteractivity);
        Disposer.dispose((Disposable)runningCommandInteractivity.getDisposable());
        this.runningCommandInteractivity = null;
    }

    public final void finishCommandBlock(int exitCode) {
        this.scheduleLastOutputUpdate();
        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)this.editor);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> TerminalOutputController.finishCommandBlock$lambda$0(this, exitCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleLastOutputUpdate() {
        List lastOutput;
        TerminalOutputContentUpdatesScheduler contentUpdatesScheduler;
        RunningCommandInteractivity runningCommandInteractivity = this.runningCommandInteractivity;
        TerminalOutputContentUpdatesScheduler terminalOutputContentUpdatesScheduler = contentUpdatesScheduler = runningCommandInteractivity != null ? runningCommandInteractivity.getContentUpdatesScheduler() : null;
        boolean bl = terminalOutputContentUpdatesScheduler != null ? !terminalOutputContentUpdatesScheduler.getFinished() : false;
        if (bl) {
            v3 = contentUpdatesScheduler.finishUpdating();
        } else {
            Pair pair;
            TerminalModel this_$iv = this.session.getModel();
            boolean $i$f$withContentLock = false;
            this_$iv.lockContent();
            try {
                boolean bl2 = false;
                pair = TuplesKt.to((Object)ShellCommandOutputScraperImpl.Companion.scrapeOutput(this.session), (Object)this.session.getModel().getWidth());
            }
            finally {
                this_$iv.unlockContent();
            }
            Pair pair2 = pair;
            StyledCommandOutput output = (StyledCommandOutput)pair2.component1();
            int terminalWidth = ((Number)pair2.component2()).intValue();
            v3 = lastOutput = CollectionsKt.listOf((Object)new PartialCommandOutput(output.getText(), output.getStyleRanges(), 0, terminalWidth, false));
        }
        if (!((Collection)lastOutput).isEmpty()) {
            Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)this.editor);
            ModalityState modalityState = ModalityState.any();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
            TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> TerminalOutputController.scheduleLastOutputUpdate$lambda$1(lastOutput, this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void trimLastEmptyLine(CommandBlock block) {
        boolean outputEndsWithWhitespacesForZsh;
        if (!CommandBlockImplKt.getWithOutput(block)) {
            return;
        }
        int outputStartOffset = block.getOutputStartOffset() - (CommandBlockImplKt.getWithPrompt(block) || CommandBlockImplKt.getWithCommand(block) ? 1 : 0);
        CharSequence outputText = this.editor.getDocument().getCharsSequence().subSequence(outputStartOffset, block.getEndOffset());
        int lastNewLineInd = StringsKt.lastIndexOf$default((CharSequence)outputText, (char)'\n', (int)0, (boolean)false, (int)6, null);
        CharSequence lastLine = outputText.subSequence(lastNewLineInd + 1, outputText.length());
        boolean outputEndsWithNewline = lastLine.length() == 0;
        boolean bl = outputEndsWithWhitespacesForZsh = this.session.getShellIntegration().getShellType() == ShellType.ZSH && StringsKt.isBlank((CharSequence)lastLine);
        if (outputEndsWithNewline || outputEndsWithWhitespacesForZsh) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            int trimStartOffset = outputStartOffset + Math.max(0, lastNewLineInd);
            Iterable iterable = this.outputModel.getHighlightings(block);
            boolean $i$f$filter = false;
            void var12_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HighlightingInfo it = (HighlightingInfo)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getEndOffset() <= trimStartOffset)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List highlightings = (List)destination$iv$iv;
            this.outputModel.putHighlightings(block, highlightings);
            this.editor.getDocument().deleteString(trimStartOffset, block.getEndOffset());
            this.hyperlinkHighlighter.highlightHyperlinks(block);
        }
    }

    @RequiresEdt
    public final void insertEmptyLine() {
        this.editor.getDocument().insertString(this.editor.getDocument().getTextLength(), (CharSequence)"\n");
        this.scrollToBottom();
    }

    @RequiresEdt
    public final void scrollToBottom() {
        TerminalUiUtilsKt.scrollToBottom((Editor)this.editor);
    }

    @RequiresEdt(generateAssertion=false)
    public final void alternateBufferStateChanged$intellij_terminal(boolean enabled) {
        if (this.runningCommandContext == null) {
            TerminalOutputController $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalOutputController.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Alternate screen buffer changed (" + enabled + "), but no running command");
        }
        if (enabled) {
            if (this.runningCommandInteractivity != null) {
                this.disposeRunningCommandInteractivity();
            }
        } else {
            RunningCommandContext rcc = this.runningCommandContext;
            if (rcc != null && this.runningCommandInteractivity == null) {
                this.installRunningCommandInteractivity(rcc.getCommand());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt(generateAssertion=false)
    private final void updateCommandOutput(PartialCommandOutput output) {
        if (this.editor.isDisposed()) {
            return;
        }
        Editor $this$doWithScrollingAware$iv = (Editor)this.editor;
        boolean $i$f$doWithScrollingAware = false;
        Rectangle it$iv = $this$doWithScrollingAware$iv.getScrollingModel().getVisibleArea();
        boolean bl = false;
        boolean wasAtBottom$iv = it$iv.y + it$iv.height == $this$doWithScrollingAware$iv.getContentComponent().getHeight();
        try {
            boolean bl2 = false;
            this.doUpdateCommandOutput(output);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (wasAtBottom$iv) {
                TerminalUiUtilsKt.scrollToBottom($this$doWithScrollingAware$iv);
            }
        }
    }

    @RequiresEdt(generateAssertion=false)
    private final void doUpdateCommandOutput(PartialCommandOutput output) {
        CommandBlock commandBlock = TerminalOutputModelKt.getActiveBlock(this.outputModel);
        if (commandBlock == null) {
            TerminalOutputController $this$doUpdateCommandOutput_u24lambda_u240 = this;
            boolean bl = false;
            $this$doUpdateCommandOutput_u24lambda_u240.blockCreationAlarm.cancelAllRequests();
            RunningCommandContext runningCommandContext = $this$doUpdateCommandOutput_u24lambda_u240.runningCommandContext;
            if (runningCommandContext == null) {
                TerminalOutputController $this$doUpdateCommandOutput_u24lambda_u240_u240 = $this$doUpdateCommandOutput_u24lambda_u240;
                boolean bl2 = false;
                TerminalOutputController $this$thisLogger$iv = $this$doUpdateCommandOutput_u24lambda_u240_u240;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TerminalOutputController.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("No running command context");
                runningCommandContext = new RunningCommandContext(null, null);
            }
            RunningCommandContext context = runningCommandContext;
            commandBlock = $this$doUpdateCommandOutput_u24lambda_u240.createNewBlock(context, output.getTerminalWidth());
        }
        CommandBlock activeBlock = commandBlock;
        this.updateBlock(activeBlock, output);
    }

    private final CommandBlock createNewBlock(RunningCommandContext context, int terminalWidth) {
        CommandBlock block = this.outputModel.createBlock(context.getCommand(), context.getPrompt(), terminalWidth);
        if (!CommandBlockImplKt.getTextRange(block).isEmpty()) {
            this.blocksDecorator.installDecoration(block);
        }
        return block;
    }

    private final void updateBlock(CommandBlock block, PartialCommandOutput output) {
        block1: {
            Object object;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            Document $this$executeInBulk$iv = (Document)documentEx;
            boolean $i$f$executeInBulk = false;
            Ref.ObjectRef result$iv = new Ref.ObjectRef();
            DocumentUtil.executeInBulk((Document)$this$executeInBulk$iv, (Runnable)new Runnable(result$iv, block, this, output){
                final /* synthetic */ Ref.ObjectRef $result;
                final /* synthetic */ CommandBlock $block$inlined;
                final /* synthetic */ TerminalOutputController this$0;
                final /* synthetic */ PartialCommandOutput $output$inlined;
                {
                    this.$result = $result;
                    this.$block$inlined = commandBlock;
                    this.this$0 = terminalOutputController;
                    this.$output$inlined = partialCommandOutput;
                }

                public final void run() {
                    int outputStartLine;
                    int replaceStartLine;
                    boolean isPostponedNewLine;
                    Ref.ObjectRef objectRef = this.$result;
                    boolean bl = false;
                    boolean bl2 = isPostponedNewLine = CommandBlockImplKt.getWithPrompt(this.$block$inlined) || CommandBlockImplKt.getWithCommand(this.$block$inlined);
                    if (isPostponedNewLine && !CommandBlockImplKt.getWithOutput(this.$block$inlined)) {
                        TerminalOutputController.access$getEditor$p(this.this$0).getDocument().insertString(this.$block$inlined.getEndOffset(), (CharSequence)"\n");
                    }
                    if (this.$output$inlined.isChangesDiscarded()) {
                        this.$block$inlined.setTrimmedLinesCount(this.$output$inlined.getLogicalLineIndex());
                    }
                    if ((replaceStartLine = (outputStartLine = TerminalOutputController.access$getEditor$p(this.this$0).getDocument().getLineNumber(this.$block$inlined.getOutputStartOffset())) + this.$output$inlined.getLogicalLineIndex() - this.$block$inlined.getTrimmedLinesCount()) >= TerminalOutputController.access$getEditor$p(this.this$0).getDocument().getLineCount() && TerminalOutputController.access$getEditor$p(this.this$0).getDocument().getTextLength() > 0) {
                        String newLines = StringsKt.repeat((CharSequence)"\n", (int)(replaceStartLine - TerminalOutputController.access$getEditor$p(this.this$0).getDocument().getLineCount() + 1));
                        TerminalOutputController.access$getEditor$p(this.this$0).getDocument().insertString(TerminalOutputController.access$getEditor$p(this.this$0).getDocument().getTextLength(), (CharSequence)newLines);
                    }
                    int replaceStartOffset = TerminalOutputController.access$getEditor$p(this.this$0).getDocument().getLineStartOffset(replaceStartLine);
                    TerminalOutputController.access$getEditor$p(this.this$0).getDocument().replaceString(replaceStartOffset, this.$block$inlined.getEndOffset(), (CharSequence)this.$output$inlined.getText());
                    TerminalOutputController.access$updateHighlightings(this.this$0, this.$block$inlined, replaceStartOffset, this.$output$inlined.getStyles());
                    objectRef.element = Unit.INSTANCE;
                }
            });
            Intrinsics.checkNotNull((Object)result$iv.element);
            this.outputModel.trimOutput();
            this.hyperlinkHighlighter.highlightHyperlinks(block);
            CharSequence outputText = CommandBlockImplKt.getWithOutput(block) ? this.editor.getDocument().getCharsSequence().subSequence(block.getOutputStartOffset(), block.getEndOffset()) : (CharSequence)"";
            if (!StringsKt.isBlank((CharSequence)outputText) && !Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)outputText), (Object)"%")) {
                this.blocksDecorator.installDecoration(block);
            }
            if ((object = this.runningCommandInteractivity) == null || (object = ((RunningCommandInteractivity)object).getCaretPainter()) == null) break block1;
            ((TerminalCaretPainter)object).repaint();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHighlightings(CommandBlock block, int replaceOffset, List<StyleRange> styles) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = styles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRange styleRange = (StyleRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightingInfo((int)((long)replaceOffset + it.getStartOffset()), (int)((long)replaceOffset + it.getEndOffset()), this.toTextAttributesProvider(it.getStyle())));
        }
        List replaceHighlightings = (List)destination$iv$iv;
        List newHighlightings = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.outputModel.getHighlightings(block)), arg_0 -> TerminalOutputController.updateHighlightings$lambda$1(replaceOffset, arg_0)), (Iterable)replaceHighlightings));
        this.outputModel.putHighlightings(block, newHighlightings);
    }

    private final TextAttributesProvider toTextAttributesProvider(TextStyle $this$toTextAttributesProvider) {
        return new TextStyleAdapter($this$toTextAttributesProvider, this.session.getColorPalette(), false, 4, null);
    }

    public final void addDocumentListener(@NotNull DocumentListener listener2, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (disposable != null) {
            this.editor.getDocument().addDocumentListener(listener2, disposable);
        } else {
            this.editor.getDocument().addDocumentListener(listener2);
        }
    }

    public static /* synthetic */ void addDocumentListener$default(TerminalOutputController terminalOutputController, DocumentListener documentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputController.addDocumentListener(documentListener, disposable);
    }

    @RequiresEdt
    public final void doWhenNextBlockCanBeStarted(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!this.isCommandRunning()) {
            callback.invoke();
        } else {
            this.nextBlockCanBeStartedQueue.offer(callback);
        }
    }

    @RequiresEdt(generateAssertion=true)
    public final boolean isCommandRunning() {
        return this.runningCommandContext != null || TerminalOutputModelKt.getActiveBlock(this.outputModel) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startCommandBlock$lambda$0(TerminalOutputController this$0, RunningCommandContext $newRunningCommandContext) {
        Editor $this$doWithScrollingAware$iv = (Editor)this$0.editor;
        boolean $i$f$doWithScrollingAware = false;
        Rectangle it$iv = $this$doWithScrollingAware$iv.getScrollingModel().getVisibleArea();
        boolean bl = false;
        boolean wasAtBottom$iv = it$iv.y + it$iv.height == $this$doWithScrollingAware$iv.getContentComponent().getHeight();
        try {
            int n;
            boolean bl2 = false;
            TerminalModel this_$iv = this$0.session.getModel();
            boolean $i$f$withContentLock = false;
            this_$iv.lockContent();
            try {
                boolean bl3 = false;
                n = this$0.session.getModel().getWidth();
            }
            finally {
                this_$iv.unlockContent();
            }
            int terminalWidth = n;
            this$0.createNewBlock($newRunningCommandContext, terminalWidth);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (wasAtBottom$iv) {
                TerminalUiUtilsKt.scrollToBottom($this$doWithScrollingAware$iv);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void startCommandBlock$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void finishCommandBlock$lambda$0(TerminalOutputController this$0, int $exitCode) {
        block8: {
            CommandBlock commandBlock = TerminalOutputModelKt.getActiveBlock(this$0.outputModel);
            if (commandBlock == null) {
                throw new IllegalStateException("No active block".toString());
            }
            CommandBlock block = commandBlock;
            Editor $this$doWithScrollingAware$iv = (Editor)this$0.editor;
            boolean $i$f$doWithScrollingAware = false;
            Rectangle it$iv = $this$doWithScrollingAware$iv.getScrollingModel().getVisibleArea();
            boolean bl = false;
            boolean wasAtBottom$iv = it$iv.y + it$iv.height == $this$doWithScrollingAware$iv.getContentComponent().getHeight();
            try {
                boolean bl2 = false;
                this$0.trimLastEmptyLine(block);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if (wasAtBottom$iv) {
                    TerminalUiUtilsKt.scrollToBottom($this$doWithScrollingAware$iv);
                }
            }
            this$0.disposeRunningCommandInteractivity();
            String string = this$0.editor.getDocument().getText(CommandBlockImplKt.getTextRange(block));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this$0.outputModel.removeBlock(block);
            } else {
                this$0.outputModel.setBlockInfo(block, new CommandBlockInfo($exitCode));
                this$0.outputModel.finalizeBlock(block);
            }
            this$0.runningCommandContext = null;
            Function0<Unit> function0 = this$0.nextBlockCanBeStartedQueue.poll();
            if (function0 == null) break block8;
            function0.invoke();
        }
    }

    private static final void scheduleLastOutputUpdate$lambda$1(List $lastOutput, TerminalOutputController this$0) {
        for (PartialCommandOutput output : $lastOutput) {
            this$0.updateCommandOutput(output);
        }
    }

    private static final boolean updateHighlightings$lambda$1(int $replaceOffset, HighlightingInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEndOffset() <= $replaceOffset;
    }

    public static final /* synthetic */ void access$updateHighlightings(TerminalOutputController $this, CommandBlock block, int replaceOffset, List styles) {
        $this.updateHighlightings(block, replaceOffset, styles);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalOutputController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandContext;", "", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;)V", "getCommand", "()Ljava/lang/String;", "getPrompt", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class RunningCommandContext {
        @Nullable
        private final String command;
        @Nullable
        private final TerminalPromptRenderingInfo prompt;

        public RunningCommandContext(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt) {
            this.command = command2;
            this.prompt = prompt;
        }

        @Nullable
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final TerminalPromptRenderingInfo getPrompt() {
            return this.prompt;
        }

        @Nullable
        public final String component1() {
            return this.command;
        }

        @Nullable
        public final TerminalPromptRenderingInfo component2() {
            return this.prompt;
        }

        @NotNull
        public final RunningCommandContext copy(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt) {
            return new RunningCommandContext(command2, prompt);
        }

        public static /* synthetic */ RunningCommandContext copy$default(RunningCommandContext runningCommandContext, String string, TerminalPromptRenderingInfo terminalPromptRenderingInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = runningCommandContext.command;
            }
            if ((n & 2) != 0) {
                terminalPromptRenderingInfo = runningCommandContext.prompt;
            }
            return runningCommandContext.copy(string, terminalPromptRenderingInfo);
        }

        @NotNull
        public String toString() {
            return "RunningCommandContext(command=" + this.command + ", prompt=" + this.prompt + ")";
        }

        public int hashCode() {
            int result = this.command == null ? 0 : this.command.hashCode();
            result = result * 31 + (this.prompt == null ? 0 : this.prompt.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunningCommandContext)) {
                return false;
            }
            RunningCommandContext runningCommandContext = (RunningCommandContext)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)runningCommandContext.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prompt, (Object)runningCommandContext.prompt);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandInteractivity;", "", "command", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;Ljava/lang/String;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "caretModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "getCaretModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "caretPainter", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretPainter;", "getCaretPainter", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretPainter;", "contentUpdatesScheduler", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputContentUpdatesScheduler;", "getContentUpdatesScheduler", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputContentUpdatesScheduler;", "setupContentUpdating", "intellij.terminal"})
    private final class RunningCommandInteractivity {
        @NotNull
        private final Disposable disposable;
        @NotNull
        private final TerminalCaretModel caretModel;
        @NotNull
        private final TerminalCaretPainter caretPainter;
        @NotNull
        private final TerminalOutputContentUpdatesScheduler contentUpdatesScheduler;

        public RunningCommandInteractivity(String command2) {
            Disposable disposable = Disposer.newDisposable((Disposable)TerminalOutputController.this.session, (String)("command " + command2));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.disposable = disposable;
            this.caretModel = new TerminalCaretModel(TerminalOutputController.this.session, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.editor, this.disposable);
            this.caretPainter = new TerminalCaretPainter(this.caretModel, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.getSelectionModel(), TerminalOutputController.this.editor);
            Disposer.register((Disposable)TerminalOutputController.this.session, (Disposable)this.disposable);
            Disposer.register((Disposable)this.disposable, (Disposable)this.caretPainter);
            BlockTerminalEventsHandler eventsHandler = new BlockTerminalEventsHandler(TerminalOutputController.this.session, TerminalOutputController.this.settings, TerminalOutputController.this);
            TerminalEventDispatcherKt.setupKeyEventDispatcher(TerminalOutputController.this.editor, eventsHandler, this.disposable);
            TerminalEventDispatcherKt.setupMouseListener(TerminalOutputController.this.editor, TerminalOutputController.this.settings, TerminalOutputController.this.session.getModel(), eventsHandler, this.disposable);
            TerminalEventDispatcherKt.setupInputMethodSupport(TerminalOutputController.this.editor, TerminalOutputController.this.session, this.caretModel, this.disposable);
            this.contentUpdatesScheduler = this.setupContentUpdating();
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        @NotNull
        public final TerminalCaretModel getCaretModel() {
            return this.caretModel;
        }

        @NotNull
        public final TerminalCaretPainter getCaretPainter() {
            return this.caretPainter;
        }

        @NotNull
        public final TerminalOutputContentUpdatesScheduler getContentUpdatesScheduler() {
            return this.contentUpdatesScheduler;
        }

        private final TerminalOutputContentUpdatesScheduler setupContentUpdating() {
            CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)TerminalCoroutineKt.terminalProjectScope(TerminalOutputController.this.project), (String)"Command block content update", null, (boolean)false, (int)6, null);
            Disposer.register((Disposable)this.disposable, () -> RunningCommandInteractivity.setupContentUpdating$lambda$0(scope));
            TerminalOutputContentUpdatesScheduler collector = new TerminalOutputContentUpdatesScheduler(TerminalOutputController.this.session.getModel().getTextBuffer$intellij_terminal(), TerminalOutputController.this.session.getShellIntegration(), scope, (Function1<? super PartialCommandOutput, Unit>)((Function1)arg_0 -> RunningCommandInteractivity.setupContentUpdating$lambda$1(TerminalOutputController.this, arg_0)));
            collector.startUpdating();
            return collector;
        }

        private static final void setupContentUpdating$lambda$0(CoroutineScope $scope) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$scope, null, (int)1, null);
        }

        private static final Unit setupContentUpdating$lambda$1(TerminalOutputController this$0, PartialCommandOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this$0.updateCommandOutput(output);
            return Unit.INSTANCE;
        }
    }
}

