/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.starter.bus.shared.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.tools.ide.starter.bus.events.Event;
import com.intellij.tools.ide.starter.bus.shared.client.EventBusServerClient;
import com.intellij.tools.ide.starter.bus.shared.client.LocalEventBusServerClientKt;
import com.intellij.tools.ide.starter.bus.shared.dto.SharedEventDto;
import com.intellij.tools.ide.starter.bus.shared.dto.SubscriberDto;
import com.intellij.tools.ide.starter.bus.shared.server.LocalEventBusServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J,\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J/\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b$\u0010%J \u0010&\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020\fH\u0016J(\u0010'\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0018\u0012\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020 0*\u0018\u00010)0(H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\fH\u0016J\b\u0010-\u001a\u00020\u001dH\u0016J\b\u0010.\u001a\u00020\u001dH\u0016J\b\u0010/\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/tools/ide/starter/bus/shared/client/LocalEventBusServerClient;", "Lcom/intellij/tools/ide/starter/bus/shared/client/EventBusServerClient;", "server", "Lcom/intellij/tools/ide/starter/bus/shared/server/LocalEventBusServer;", "<init>", "(Lcom/intellij/tools/ide/starter/bus/shared/server/LocalEventBusServer;)V", "getServer", "()Lcom/intellij/tools/ide/starter/bus/shared/server/LocalEventBusServer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "eventClasses", "Ljava/util/HashMap;", "", "eventClassesLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "PROCESS_ID", "post", "endpoint", "requestBody", "get", "sendRequest", "method", "retriesOnTheSamePort", "", "postAndWaitProcessing", "", "sharedEventDto", "Lcom/intellij/tools/ide/starter/bus/shared/dto/SharedEventDto;", "newSubscriber", "", "eventClass", "Ljava/lang/Class;", "Lcom/intellij/tools/ide/starter/bus/events/Event;", "timeout", "Lkotlin/time/Duration;", "subscriberName", "newSubscriber-8Mi8wO0", "(Ljava/lang/Class;JLjava/lang/String;)V", "unsubscribe", "getEvents", "", "", "Lkotlin/Pair;", "processedEvent", "eventName", "clear", "endServerProcess", "startServerProcess", "intellij.tools.ide.starter.bus"})
@SourceDebugExtension(value={"SMAP\nLocalEventBusServerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEventBusServerClient.kt\ncom/intellij/tools/ide/starter/bus/shared/client/LocalEventBusServerClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1222#2,2:132\n1252#2,2:134\n1563#2:137\n1634#2,3:138\n1255#2:141\n1#3:136\n*S KotlinDebug\n*F\n+ 1 LocalEventBusServerClient.kt\ncom/intellij/tools/ide/starter/bus/shared/client/LocalEventBusServerClient\n*L\n98#1:132,2\n98#1:134,2\n102#1:137\n102#1:138,3\n98#1:141\n*E\n"})
public final class LocalEventBusServerClient
implements EventBusServerClient {
    @NotNull
    private final LocalEventBusServer server;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final HashMap<String, String> eventClasses;
    @NotNull
    private final ReentrantReadWriteLock eventClassesLock;
    @NotNull
    private final String PROCESS_ID;

    public LocalEventBusServerClient(@NotNull LocalEventBusServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper();
        this.eventClasses = new HashMap();
        this.eventClassesLock = new ReentrantReadWriteLock();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.PROCESS_ID = string;
    }

    @NotNull
    public final LocalEventBusServer getServer() {
        return this.server;
    }

    private final String post(String endpoint, String requestBody) {
        return LocalEventBusServerClient.sendRequest$default(this, "POST", endpoint, requestBody, 0, 8, null);
    }

    static /* synthetic */ String post$default(LocalEventBusServerClient localEventBusServerClient, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return localEventBusServerClient.post(string, string2);
    }

    private final String get(String endpoint, String requestBody) {
        return LocalEventBusServerClient.sendRequest$default(this, "GET", endpoint, requestBody, 0, 8, null);
    }

    static /* synthetic */ String get$default(LocalEventBusServerClient localEventBusServerClient, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return localEventBusServerClient.get(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String sendRequest(String method, String endpoint, String requestBody, int retriesOnTheSamePort) {
        Object object;
        URL url = new URL("http://localhost:" + this.server.getPort() + "/" + endpoint);
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            String string;
            int n;
            connection.setRequestMethod(method);
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(5000);
            String string2 = requestBody;
            if (string2 != null) {
                String string3;
                String body = string3 = string2;
                boolean bl = false;
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                OutputStream outputStream = connection.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                Closeable closeable = outputStream;
                Object object2 = Charsets.UTF_8;
                Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object2);
                int n2 = 8192;
                closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n2);
                object2 = null;
                try {
                    BufferedWriter it = (BufferedWriter)closeable;
                    boolean bl2 = false;
                    it.write(body);
                    writer = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
            }
            int it22 = n = connection.getResponseCode();
            boolean $i$a$-also-LocalEventBusServerClient$sendRequest$32 = false;
            if (it22 != 200) {
                throw new ServerException("Code: " + it22 + ". " + connection.getResponseMessage());
            }
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object = inputStream;
            Object it22 = Charsets.UTF_8;
            Reader $i$a$-also-LocalEventBusServerClient$sendRequest$32 = new InputStreamReader((InputStream)object, (Charset)it22);
            int n3 = 8192;
            object = $i$a$-also-LocalEventBusServerClient$sendRequest$32 instanceof BufferedReader ? (BufferedReader)$i$a$-also-LocalEventBusServerClient$sendRequest$32 : new BufferedReader($i$a$-also-LocalEventBusServerClient$sendRequest$32, n3);
            it22 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                it22 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)it22);
            }
            object = string;
        }
        catch (ConnectException e) {
            String string;
            if (retriesOnTheSamePort < 3) {
                string = this.sendRequest(method, endpoint, requestBody, retriesOnTheSamePort + 1);
            } else {
                if (!this.server.updatePort()) {
                    throw e;
                }
                string = this.sendRequest(method, endpoint, requestBody, 0);
            }
            object = string;
        }
        finally {
            connection.disconnect();
        }
        return object;
    }

    static /* synthetic */ String sendRequest$default(LocalEventBusServerClient localEventBusServerClient, String string, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return localEventBusServerClient.sendRequest(string, string2, string3, n);
    }

    @Override
    public boolean postAndWaitProcessing(@NotNull SharedEventDto sharedEventDto) {
        Intrinsics.checkNotNullParameter((Object)sharedEventDto, (String)"sharedEventDto");
        LocalEventBusServerClientKt.access$getLOG$p().info("Post and wait " + sharedEventDto);
        return Boolean.parseBoolean(this.post("postAndWaitProcessing", this.objectMapper.writeValueAsString((Object)sharedEventDto)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newSubscriber-8Mi8wO0(@NotNull Class<? extends Event> eventClass, long l, @NotNull String subscriberName) {
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        Intrinsics.checkNotNullParameter((Object)subscriberName, (String)"subscriberName");
        String simpleName = eventClass.getSimpleName();
        ReentrantReadWriteLock.WriteLock writeLock = this.eventClassesLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            ((Map)this.eventClasses).put(simpleName, eventClass.getName());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        LocalEventBusServerClientKt.access$getLOG$p().info("New subscriber " + simpleName);
        Intrinsics.checkNotNull((Object)simpleName);
        Boolean.parseBoolean(this.post("newSubscriber", this.objectMapper.writeValueAsString((Object)new SubscriberDto(subscriberName, simpleName, this.PROCESS_ID, Duration.getInWholeMilliseconds-impl((long)l)))));
    }

    @Override
    public void unsubscribe(@NotNull Class<? extends Event> eventClass, @NotNull String subscriberName) {
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        Intrinsics.checkNotNullParameter((Object)subscriberName, (String)"subscriberName");
        String simpleName = eventClass.getSimpleName();
        Intrinsics.checkNotNull((Object)simpleName);
        Boolean.parseBoolean(this.post("unsubscribe", this.objectMapper.writeValueAsString((Object)new SubscriberDto(subscriberName, simpleName, this.PROCESS_ID, 0L, 8, null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<Pair<String, Event>>> getEvents() {
        void $this$associateByTo$iv$iv;
        TypeReference<HashMap<String, List<SharedEventDto>>> eventType2 = new TypeReference<HashMap<String, List<SharedEventDto>>>(){};
        Set set = ((HashMap)this.objectMapper.readValue(this.get("getEvents", this.PROCESS_ID), (TypeReference)eventType2)).entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$associateBy$iv = set;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            List list;
            String $i$a$-withLock-LocalEventBusServerClient$getEvents$2$22;
            void entry;
            Map.Entry it;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            it = (Map.Entry)element$iv$iv;
            String string = (String)k;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = this.eventClassesLock.readLock();
            Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
            Lock lock = readLock;
            lock.lock();
            try {
                boolean $i$a$-withLock-LocalEventBusServerClient$getEvents$2$22 = false;
                $i$a$-withLock-LocalEventBusServerClient$getEvents$2$22 = this.eventClasses.get(entry.getKey());
            }
            finally {
                lock.unlock();
            }
            if ($i$a$-withLock-LocalEventBusServerClient$getEvents$2$22 != null) {
                void $this$mapTo$iv$iv;
                String className;
                boolean bl3 = false;
                Intrinsics.checkNotNull(Class.forName(className), (String)"null cannot be cast to non-null type java.lang.Class<out com.intellij.tools.ide.starter.bus.events.Event>");
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                Iterable $this$map$iv = (Iterable)v;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Class<?> clz;
                    void it2;
                    SharedEventDto sharedEventDto = (SharedEventDto)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(TuplesKt.to((Object)it2.getEventId(), (Object)this.objectMapper.readValue(it2.getSerializedEvent(), clz)));
                }
                list = (List)destination$iv$iv2;
            } else {
                list = null;
            }
            List list2 = list;
            map.put(string, list2);
        }
        return destination$iv$iv;
    }

    @Override
    public void processedEvent(@NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        LocalEventBusServerClientKt.access$getLOG$p().info("Processed event " + eventName);
        this.post("processedEvent", eventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.eventClassesLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean $i$a$-withLock-LocalEventBusServerClient$clear$22 = false;
            this.eventClasses.clear();
            Unit $i$a$-withLock-LocalEventBusServerClient$clear$22 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        try {
            LocalEventBusServerClient.post$default(this, "clear", null, 2, null);
        }
        catch (Throwable t) {
            LocalEventBusServerClientKt.access$getLOG$p().info("Clear server exception: " + t.getMessage() + ". " + t);
        }
    }

    @Override
    public void endServerProcess() {
        this.server.endServer();
    }

    @Override
    public void startServerProcess() {
        this.server.startServer();
    }
}

