/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.bun.runConfiguration.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.javascript.bun.BunBundle;
import com.intellij.javascript.bun.BunDebugAdapter;
import com.intellij.javascript.bun.runConfiguration.run.BunRunConfigurationEditor;
import com.intellij.javascript.bun.runConfiguration.run.BunRunConfigurationOptions;
import com.intellij.javascript.bun.settings.BunSettingsService;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.dap.DapLaunchArgumentsProvider;
import com.intellij.platform.dap.DapStartRequest;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 I2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001IB\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001aH\u0016J\u0016\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0016J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u0002H\u0014J\b\u0010?\u001a\u00020\nH\u0016J\b\u0010@\u001a\u00020AH\u0016J\u0014\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010F\u001a\u00020A2\u0006\u0010D\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020A2\u0006\u0010D\u001a\u00020GH\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R(\u0010+\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R(\u00100\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R(\u00103\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010-\"\u0004\b5\u0010/R(\u00106\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010-\"\u0004\b8\u0010/R$\u0010:\u001a\u0002092\u0006\u0010*\u001a\u0002098F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006J"}, d2={"Lcom/intellij/javascript/bun/runConfiguration/run/BunRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/javascript/bun/runConfiguration/run/BunRunConfigurationOptions;", "Lcom/intellij/execution/configurations/RefactoringListenerProvider;", "Lcom/intellij/platform/dap/DapLaunchArgumentsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "envVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvVariables$intellij_javascript_bun", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvVariables$intellij_javascript_bun", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "adapterId", "Lcom/intellij/javascript/bun/BunDebugAdapter;", "getAdapterId", "()Lcom/intellij/javascript/bun/BunDebugAdapter;", "request", "Lcom/intellij/platform/dap/DapStartRequest;", "getRequest", "()Lcom/intellij/platform/dap/DapStartRequest;", "arguments", "", "", "getProgramPath", "Ljava/nio/file/Path;", "getOptions", "value", "filePath", "getFilePath", "()Ljava/lang/String;", "setFilePath", "(Ljava/lang/String;)V", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "applicationParameters", "getApplicationParameters", "setApplicationParameters", "runtimeParameters", "getRuntimeParameters", "setRuntimeParameters", "", "stopOnEntry", "getStopOnEntry", "()Z", "setStopOnEntry", "(Z)V", "suggestedName", "checkConfiguration", "", "getRefactoringElementListener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "element", "Lcom/intellij/psi/PsiElement;", "readExternal", "Lorg/jdom/Element;", "writeExternal", "Companion", "intellij.javascript.bun"})
@SourceDebugExtension(value={"SMAP\nBunRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BunRunConfiguration.kt\ncom/intellij/javascript/bun/runConfiguration/run/BunRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class BunRunConfiguration
extends LocatableConfigurationBase<BunRunConfigurationOptions>
implements RefactoringListenerProvider,
DapLaunchArgumentsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EnvironmentVariablesData envVariables;
    @NotNull
    private final BunDebugAdapter adapterId;
    @NotNull
    private final DapStartRequest request;

    public BunRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        this.envVariables = environmentVariablesData;
        this.adapterId = BunDebugAdapter.INSTANCE;
        this.request = DapStartRequest.Launch;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvVariables$intellij_javascript_bun() {
        return this.envVariables;
    }

    public final void setEnvVariables$intellij_javascript_bun(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkNotNullParameter((Object)environmentVariablesData, (String)"<set-?>");
        this.envVariables = environmentVariablesData;
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = EmptyRunProfileState.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)runProfileState, (String)"INSTANCE");
        return runProfileState;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new BunRunConfigurationEditor(project);
    }

    @NotNull
    public BunDebugAdapter getAdapterId() {
        return this.adapterId;
    }

    @NotNull
    public DapStartRequest getRequest() {
        return this.request;
    }

    @NotNull
    public Map<String, Object> arguments() {
        Object expandedArgs;
        Map map;
        String string;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string2 = ((BunSettingsService.BunSettingsState)BunSettingsService.Companion.getService(project).getState()).getBunPath();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = FileUtil.toSystemDependentName((String)it);
        } else {
            string = null;
        }
        String bunRuntimePath = string;
        String programPath = ((Object)this.getProgramPath()).toString();
        if (BunRunConfiguration.Companion.isRunningOnWsl(programPath)) {
            throw new ExecutionException(BunBundle.message("bun.run.configuration.error.wsl.not.supported", new Object[0]));
        }
        String transport = !SystemInfo.isWindows || WslPath.Companion.isWslUncPath(programPath) ? "native" : "tcp";
        String targetWorkingDirectory = BunRunConfiguration.Companion.convertFromWslPathIfNeeded(this.getWorkingDirectory());
        String targetProgramPath = BunRunConfiguration.Companion.convertFromWslPathIfNeeded(programPath);
        Map $this$arguments_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$arguments_u24lambda_u241.put("runtime", bunRuntimePath);
        $this$arguments_u24lambda_u241.put("program", targetProgramPath);
        CharSequence charSequence = this.getOptions().getApplicationParameters();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)this.getOptions().getApplicationParameters());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
            expandedArgs = list;
            $this$arguments_u24lambda_u241.put("args", expandedArgs);
        }
        if (!((expandedArgs = (CharSequence)this.getOptions().getRuntimeParameters()) == null || StringsKt.isBlank((CharSequence)expandedArgs))) {
            List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)this.getOptions().getRuntimeParameters());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
            List expandedRuntimeArgs = list;
            $this$arguments_u24lambda_u241.put("runtimeArgs", expandedRuntimeArgs);
        }
        $this$arguments_u24lambda_u241.put("cwd", targetWorkingDirectory);
        $this$arguments_u24lambda_u241.put("stopOnEntry", this.getOptions().getStopOnEntry());
        $this$arguments_u24lambda_u241.put("transport", transport);
        Map map2 = this.envVariables.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
        if (!map2.isEmpty()) {
            $this$arguments_u24lambda_u241.put("env", this.envVariables.getEnvs());
        }
        return MapsKt.build((Map)map);
    }

    private final Path getProgramPath() {
        Path path;
        String expandedPath = ProgramParametersUtil.expandPathAndMacros((String)this.getFilePath(), null, (Project)this.getProject());
        String string = ScriptFileUtil.getLocalFilePath((String)expandedPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalFilePath(...)");
        String appFilePath = string;
        Path path2 = Paths.get(appFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path file = path2;
        String workingDirectory = this.getWorkingDirectory();
        if (!file.isAbsolute() && workingDirectory != null) {
            String[] stringArray = new String[]{appFilePath};
            Path path3 = Paths.get(workingDirectory, Arrays.copyOf(stringArray, stringArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else {
            path = file;
        }
        return path;
    }

    @NotNull
    protected BunRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)locatableRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.javascript.bun.runConfiguration.run.BunRunConfigurationOptions");
        return (BunRunConfigurationOptions)locatableRunConfigurationOptions;
    }

    @Nullable
    public final String getFilePath() {
        return BunRunConfiguration.Companion.toSystemDependentNameAndTrim(this.getOptions().getProgram());
    }

    public final void setFilePath(@Nullable String value) {
        this.getOptions().setProgram(PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value)));
    }

    @Nullable
    public final String getWorkingDirectory() {
        return BunRunConfiguration.Companion.toSystemDependentNameAndTrim(this.getOptions().getWorkingDirectory());
    }

    public final void setWorkingDirectory(@Nullable String value) {
        BunRunConfigurationOptions bunRunConfigurationOptions = this.getOptions();
        String string = value;
        if (string == null) {
            string = "";
        }
        bunRunConfigurationOptions.setWorkingDirectory(PathUtil.toSystemIndependentName((String)string));
    }

    @Nullable
    public final String getApplicationParameters() {
        return this.getOptions().getApplicationParameters();
    }

    public final void setApplicationParameters(@Nullable String value) {
        this.getOptions().setApplicationParameters(value);
    }

    @Nullable
    public final String getRuntimeParameters() {
        return this.getOptions().getRuntimeParameters();
    }

    public final void setRuntimeParameters(@Nullable String value) {
        this.getOptions().setRuntimeParameters(value);
    }

    public final boolean getStopOnEntry() {
        return this.getOptions().getStopOnEntry();
    }

    public final void setStopOnEntry(boolean value) {
        this.getOptions().setStopOnEntry(value);
    }

    @NotNull
    public String suggestedName() {
        String string;
        block3: {
            block2: {
                string = this.getOptions().getProgram();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = PathUtil.getFileName((String)it);
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        return string;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Path workingDir;
        block8: {
            block7: {
                String string = this.getWorkingDirectory();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    v1 = Paths.get(it, new String[0]);
                } else {
                    v1 = workingDir = null;
                }
                if (workingDir == null || !workingDir.isAbsolute()) break block7;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(workingDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block8;
            }
            throw new RuntimeConfigurationError(BunBundle.message("bun.run.configuration.error.incorrect.workingDirectory.text", new Object[0]));
        }
        String mainScriptFilePath = this.getFilePath();
        CharSequence charSequence = mainScriptFilePath;
        if (charSequence == null || charSequence.length() == 0) {
            throw new RuntimeConfigurationError(BunBundle.message("bun.run.configuration.error.incorrect.file.path.text", new Object[0]));
        }
        String pathToJsFile = ProgramParametersUtil.expandPathAndMacros((String)mainScriptFilePath, null, (Project)this.getProject());
        if (Intrinsics.areEqual((Object)pathToJsFile, (Object)mainScriptFilePath)) {
            NodeJsRunConfiguration.validatePath((Path)workingDir, (String)pathToJsFile);
        }
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(@Nullable PsiElement element) {
        return null;
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"readExternal(...)");
        this.envVariables = environmentVariablesData;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.envVariables.writeExternalNoDefault(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002J#\u0010\b\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/bun/runConfiguration/run/BunRunConfiguration$Companion;", "", "<init>", "()V", "toSystemDependentNameAndTrim", "", "convertFromWslPathIfNeeded", "path", "isRunningOnWsl", "", "intellij.javascript.bun"})
    public static final class Companion {
        private Companion() {
        }

        private final String toSystemDependentNameAndTrim(String $this$toSystemDependentNameAndTrim) {
            String string = PathUtil.toSystemDependentName((String)$this$toSystemDependentNameAndTrim);
            if (string == null) {
                string = "";
            }
            return StringUtil.nullize((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        }

        private final String convertFromWslPathIfNeeded(String path) {
            String string;
            if (this.isRunningOnWsl(path)) {
                WslPath wslPath = WslPath.Companion.parseWindowsUncPath(path);
                string = wslPath != null ? wslPath.getLinuxPath() : null;
            } else {
                string = path;
            }
            return string;
        }

        private final boolean isRunningOnWsl(String path) {
            return path != null && WslPath.Companion.isWslUncPath(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

