/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.ui.ChangesBrowserWithRollback;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LocalChangesWouldBeOverwrittenHelper {
    public static void showErrorNotification(@NotNull Project project, @NonNls @NotNull String displayId, @NotNull VirtualFile root, @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        if (project == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(0);
        }
        if (displayId == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(1);
        }
        if (root == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(2);
        }
        if (operationName == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(3);
        }
        if (relativeFilePaths == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(4);
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        String description = LocalChangesWouldBeOverwrittenHelper.getOverwrittenByMergeMessage();
        VcsNotifier.importantNotification().createNotification(GitBundle.message((String)"notification.title.git.operation.failed", (Object[])new Object[]{StringUtil.capitalize((String)operationName)}), description, NotificationType.ERROR).setDisplayId(displayId).addAction((AnAction)NotificationAction.createSimple((Supplier)GitBundle.messagePointer((String)"local.changes.would.be.overwritten.by.merge.view.them.action", (Object[])new Object[0]), () -> LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, description, changes, absolutePaths))).notify(project);
    }

    public static void showErrorDialog(@NotNull Project project, @NotNull String operationName, @Nls String description, @NotNull List<? extends Change> changes, @NotNull Collection<String> absolutePaths) {
        if (project == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(5);
        }
        if (operationName == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(6);
        }
        if (changes == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(7);
        }
        if (absolutePaths == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(8);
        }
        String title = GitBundle.message((String)"dialog.title.local.changes.prevent.from.operation", (Object[])new Object[]{StringUtil.capitalize((String)operationName)});
        if (changes.isEmpty()) {
            GitUtil.showPathsInDialog(project, absolutePaths, title, description);
        } else {
            ChangesBrowserWithRollback changesViewer = new ChangesBrowserWithRollback(project, changes);
            DialogBuilder builder = new DialogBuilder(project);
            if (description != null) {
                builder.setNorthPanel((JComponent)new MultiLineLabel(description));
            }
            builder.setCenterPanel((JComponent)((Object)changesViewer));
            builder.addDisposable((Disposable)changesViewer);
            builder.addOkAction();
            builder.setTitle(title);
            builder.show();
        }
    }

    @ApiStatus.Internal
    @Nls
    @NotNull
    public static String getOverwrittenByMergeMessage() {
        String mergeOperation = GitBundle.message((String)"merge.operation.name", (Object[])new Object[0]);
        String stashOperation = StringUtil.toLowerCase((String)GitBundle.message((String)"local.changes.save.policy.stash", (Object[])new Object[0]));
        String string = GitBundle.message((String)"warning.your.local.changes.would.be.overwritten.by", (Object[])new Object[]{mergeOperation, stashOperation});
        if (string == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFilePaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/LocalChangesWouldBeOverwrittenHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/LocalChangesWouldBeOverwrittenHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverwrittenByMergeMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

