/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webstorm.typeEngineWidget;

import com.intellij.icons.AllIcons;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.webstorm.typeEngineWidget.SettingsModel;
import com.intellij.webstorm.typeEngineWidget.TypeScriptEngineWidgetKt;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/webstorm/typeEngineWidget/TypeScriptEngineWidget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ID", "", "statusBarLabel", "Ljavax/swing/JLabel;", "getStatusBarLabel", "()Ljavax/swing/JLabel;", "statusBarLabel$delegate", "Lkotlin/Lazy;", "getComponent", "Ljavax/swing/JComponent;", "updateIcon", "", "showPopup", "createPopupContent", "Lcom/intellij/openapi/ui/DialogPanel;", "state", "Lcom/intellij/webstorm/typeEngineWidget/SettingsModel;", "isTypeScriptServiceBasedEngineEnabled", "", "intellij.webstorm.typeEngineWidget"})
public final class TypeScriptEngineWidget
implements CustomStatusBarWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy statusBarLabel$delegate;

    public TypeScriptEngineWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.statusBarLabel$delegate = LazyKt.lazy(() -> TypeScriptEngineWidget.statusBarLabel_delegate$lambda$1(this));
    }

    @NotNull
    public String ID() {
        return "TypeScriptEngineStatusBarWidget";
    }

    private final JLabel getStatusBarLabel() {
        Lazy lazy = this.statusBarLabel$delegate;
        return (JLabel)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        this.updateIcon();
        return this.getStatusBarLabel();
    }

    private final void updateIcon() {
        this.getStatusBarLabel().setIcon(this.isTypeScriptServiceBasedEngineEnabled(this.project) ? JavaScriptLanguageIcons.Typescript.TypeScriptServiceBasedTypeEngine : JavaScriptLanguageIcons.Typescript.TypeScriptServiceBasedTypeEngineOff);
    }

    private final void showPopup() {
        SettingsModel state = new SettingsModel(this.project);
        DialogPanel popupContent = this.createPopupContent(state);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupContent, null).setRequestFocus(true).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setResizable(false).setMovable(false).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint((Component)this.getStatusBarLabel(), at));
    }

    private final DialogPanel createPopupContent(SettingsModel state) {
        DialogPanel dialogPanel;
        DialogPanel $this$createPopupContent_u24lambda_u2414 = dialogPanel = BuilderKt.panel(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13(state, this, arg_0));
        boolean bl = false;
        $this$createPopupContent_u24lambda_u2414.setBorder((Border)UnscaledGapsKt.toJBEmptyBorder((UnscaledGaps)new IntelliJSpacingConfiguration().getDialogUnscaledGaps()));
        return dialogPanel;
    }

    private final boolean isTypeScriptServiceBasedEngineEnabled(Project project) {
        return TypeScriptCompilerSettings.Companion.getSettings(project).getUseTypesFromServer();
    }

    private static final JLabel statusBarLabel_delegate$lambda$1(TypeScriptEngineWidget this$0) {
        JLabel jLabel;
        JLabel $this$statusBarLabel_delegate_u24lambda_u241_u24lambda_u240 = jLabel = new JLabel();
        boolean bl = false;
        $this$statusBarLabel_delegate_u24lambda_u241_u24lambda_u240.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.title"));
        new ClickListener(this$0){
            final /* synthetic */ TypeScriptEngineWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (SwingUtilities.isLeftMouseButton(event)) {
                    TypeScriptEngineWidget.access$showPopup(this.this$0);
                }
                return true;
            }
        }.installOn((Component)$this$statusBarLabel_delegate_u24lambda_u241_u24lambda_u240);
        return jLabel;
    }

    private static final Unit createPopupContent$lambda$13$lambda$3$lambda$2(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.hint"));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.title")).gap(RightGap.SMALL).bold();
        Icon icon = AllIcons.General.ContextHelp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContextHelp");
        $this$row.icon(icon).applyToComponent(TypeScriptEngineWidget::createPopupContent$lambda$13$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$4(SettingsModel $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.TSandTSX.label")), (ObservableMutableProperty)((ObservableMutableProperty)$state.getTsandtsx()));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$6$lambda$5(SettingsModel $state, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        if (!$state.getAngularServiceEnabled()) {
            $this$applyToComponent.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.angular.disabled"));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$6(SettingsModel $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.angular.label")), (ObservableMutableProperty)((ObservableMutableProperty)$state.getAngular())).enabled($state.getAngularServiceEnabled()).applyToComponent(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$6$lambda$5($state, arg_0)).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)new IntelliJSpacingConfiguration().getHorizontalSmallGap(), (int)7, null));
        Icon icon = AllIcons.General.Beta;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Beta");
        $this$row.icon(icon);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$8$lambda$7(SettingsModel $state, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        if (!$state.getVueServiceEnabled()) {
            $this$applyToComponent.setToolTipText(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.vue.disabled"));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$8(SettingsModel $state, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.vue.label")), (ObservableMutableProperty)((ObservableMutableProperty)$state.getVue())).enabled($state.getVueServiceEnabled()).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)new IntelliJSpacingConfiguration().getHorizontalSmallGap(), (int)7, null)).applyToComponent(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$8$lambda$7($state, arg_0));
        Icon icon = AllIcons.General.Alpha;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Alpha");
        $this$row.icon(icon);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$10$lambda$9(TypeScriptEngineWidget this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AnAction action = ActionManager.getInstance().getAction("TypeScriptEngineBugReportAction");
        AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this$0.project).build(), null, (String)"toolbar", (ActionUiKind)((ActionUiKind)ActionUiKind.TOOLBAR), null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        action.actionPerformed(event);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11$lambda$10(TypeScriptEngineWidget this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(TypeScriptEngineWidgetKt.access$msg("typescript.engine.widget.bug.report"), arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$10$lambda$9(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12$lambda$11(SettingsModel $state, TypeScriptEngineWidget this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$4($state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$6($state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$8($state, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11$lambda$10(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13$lambda$12(SettingsModel $state, TypeScriptEngineWidget this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12$lambda$11($state, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupContent$lambda$13(SettingsModel $state, TypeScriptEngineWidget this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, TypeScriptEngineWidget::createPopupContent$lambda$13$lambda$3, (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TypeScriptEngineWidget.createPopupContent$lambda$13$lambda$12($state, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$showPopup(TypeScriptEngineWidget $this) {
        $this.showPopup();
    }
}

