/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.rsync.RSyncOptions;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotifier;
import com.jetbrains.plugins.webDeployment.ui.CancellableAllFileSelector;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransferOperation {
    private static final Logger LOG = Logger.getInstance(TransferOperation.class);

    public void prepare(ExecutionContext context) throws FileSystemException {
    }

    @NlsContexts.ProgressText
    public abstract String getProgressText(ExecutionContext var1);

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getDetailedText(ExecutionContext var1);

    public abstract void execute(ExecutionContext var1) throws FileSystemException;

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public abstract String getErrorMessage(ExecutionContext var1, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String var2);

    public abstract void onLocalMove(FileObject var1, FileObject var2) throws FileSystemException;

    protected static FileObject updateOnParentMove(FileObject file, FileObject parentFrom, FileObject parentTo) throws FileSystemException {
        if (file.getName().isAncestor(parentFrom.getName())) {
            return parentTo.resolveFile(parentFrom.getName().getRelativeName(file.getName()), NameScope.DESCENDENT);
        }
        return file;
    }

    public static String updateOnParentMove(String path, FileObject parentFrom, FileObject parentTo, boolean caseSensitive) {
        return TransferOperation.updateOnParentMove(path, parentFrom.getName().getPath(), parentTo.getName().getPath(), caseSensitive);
    }

    public static String updateOnParentMove(String path, String parentFrom, String parentTo, boolean caseSensitive) {
        String remainder = DeploymentPathUtils.getPathRemainder(parentFrom, path, caseSensitive);
        if (remainder != null) {
            return DeploymentPathUtils.join(parentTo, remainder);
        }
        return path;
    }

    public static boolean isUpToDate(FileObject source, FileObject target, Deployable server) throws FileSystemException {
        long targetTimestamp;
        long sourceTimestamp;
        if (!target.exists()) {
            return false;
        }
        long sourceSize = source.getContent().getSize();
        long targetSize = target.getContent().getSize();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            sourceTimestamp = 0L;
            targetTimestamp = 0L;
        } else {
            sourceTimestamp = source.getContent().getLastModifiedTime();
            targetTimestamp = target.getContent().getLastModifiedTime();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(source.getName().getPath() + " source timestamp=" + sourceTimestamp + ", target timestamp=" + targetTimestamp + ", delta=" + (sourceTimestamp - targetTimestamp) + ", source size=" + sourceSize + ", target size=" + targetSize);
        }
        return sourceSize == targetSize && TransferOperation.areTimestampsEqual(sourceTimestamp, targetTimestamp, source.getFileSystem().getLastModTimeAccuracy() + target.getFileSystem().getLastModTimeAccuracy());
    }

    @NotNull
    private static List<String> getExcludedMasks(ExecutionContext context, String basePath) {
        List excludedMasks = StringUtil.split((String)context.getConfig().getExcludeMask(), (String)";");
        List<ExcludedPath> excludedPaths = context.getConfig().getExcludedPaths(context.getServer().getId());
        List excludedRels = ContainerUtil.mapNotNull(excludedPaths, path -> !path.isLocal() ? null : FileUtil.getRelativePath((String)basePath, (String)path.getSerializedPath(), (char)'/'));
        List list = excludedMasks = ContainerUtil.concat((List)excludedMasks, (List)excludedRels);
        if (list == null) {
            TransferOperation.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static void moveOrCopy(ExecutionContext context, FileObject remoteSource, FileObject remoteTarget, boolean isMoving) throws FileSystemException {
        LOG.assertTrue(context.isServerSideModification());
        context.addAffectedParentRoot(remoteSource.getName(), true);
        context.addAffectedParentRoot(remoteTarget.getName(), true);
        if (isMoving) {
            if (!remoteSource.getName().equals(remoteTarget.getName())) {
                remoteSource.moveTo(remoteTarget);
            }
        } else {
            CancellableAllFileSelector selector = new CancellableAllFileSelector(context.getProgressIndicator(), "copying.0", context.isCancellable());
            TransferOperation.copyFrom(remoteTarget, remoteSource, (FileSelector)selector, context);
        }
        if (isMoving) {
            context.incCounter("transfer.details.moved");
        } else {
            context.incCounter("transfer.details.copied");
        }
    }

    private static boolean preserveOrSetFilePermissions(FileObject source, FileObject target, ExecutionContext context) throws FileSystemException {
        if (!context.isServerSideModification()) {
            return false;
        }
        if (!context.getConfig().preserveOriginalFilePermissions()) {
            return TransferOperation.setPermissions(target, false, context, true);
        }
        if (SystemInfo.isUnix) {
            try {
                int permissions = source.getPermissions();
                if (permissions != -1) {
                    return TransferOperation.setPermissions(target, permissions, false, context, true);
                }
            }
            catch (FileSystemException e) {
                LOG.warn("Cannot get permissions of source file", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean setPermissions(FileObject target, boolean isDirectory, ExecutionContext context, boolean tolerate) throws FileSystemException {
        int permissions;
        int n = permissions = isDirectory ? context.getConfig().getFolderPermissions() : context.getConfig().getFilePermissions();
        if (!context.isServerSideModification() || permissions == -1) {
            return false;
        }
        return TransferOperation.setPermissions(target, permissions, isDirectory, context, tolerate);
    }

    private static boolean setPermissions(FileObject target, int permissions, boolean isDirectory, ExecutionContext context, boolean tolerate) throws FileSystemException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changing permissions of " + target.getName().getURI() + " to " + Util.getPermissionsAsString(permissions) + " (" + Integer.toOctalString(permissions) + ")");
        }
        try {
            target.setPermissions(permissions);
            return true;
        }
        catch (FileSystemException e) {
            if (!tolerate || PublishUtils.isFatal(e)) {
                throw e;
            }
            context.getConfig().setFilePermissions(-1);
            context.getConfig().setFolderPermissions(-1);
            LOG.warn("Failed to change permissions of " + target.getName().getPath(), (Throwable)e);
            String message = WDBundle.message("failed.to.change.permissions", isDirectory ? 2 : 1, context.getServer().getPresentablePath(target), PublishUtils.getMessage(e, false));
            context.console(message, ConsoleViewContentType.ERROR_OUTPUT);
            return false;
        }
    }

    private static void createFolder(FileObject target, ExecutionContext context) throws FileSystemException {
        LOG.debug("Creating folder " + target.getName().getPath());
        target.createFolder();
        TransferOperation.setPermissions(target, true, context, true);
        context.incCounter("transfer.details.foldersCreated");
        context.addAffectedParentRoot(target.getName(), context.isServerSideModification());
    }

    private static boolean copyFile(FileObject source, FileObject target, ExecutionContext context) throws FileSystemException {
        if (source.getType() == FileType.FOLDER) {
            throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", DeploymentPathUtils.getLocalPath(source)));
        }
        if (target.getType() == FileType.FOLDER) {
            throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", context.getServer().getPresentablePath(target)));
        }
        if (!context.getConfig().isOverwriteAll() && TransferOperation.isUpToDate(source, target, context.getServer())) {
            TransferOperation.createNewRevision(source, target, context);
            String message = WDBundle.message("file.up.to.date", context.getServer().getPresentablePath(target));
            context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
            LOG.debug("Up to date: " + target.getName().getPath());
            context.incCounter("transfer.details.upToDate");
            boolean affected = TransferOperation.preserveOrSetFilePermissions(source, target, context);
            if (affected) {
                context.addAffectedParentRoot(source.getName(), !context.isServerSideModification());
                context.addAffectedParentRoot(target.getName(), context.isServerSideModification());
            }
            return true;
        }
        try {
            if (target.exists() && !context.promptForOverwrite(source, target)) {
                String message = WDBundle.message("file.skipped", context.getServer().getPresentablePath(target));
                context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
                LOG.debug("Skipped by user: " + target.getName().getPath());
                context.incCounter("transfer.details.skippedByUser");
                return false;
            }
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{source, target});
        }
        TransferOperation.copyFileFrom(target, source, context);
        TransferOperation.preserveOrSetFilePermissions(source, target, context);
        if (context.getConfig().isPreserveTimestamps()) {
            long sourceTimestamp = source.getContent().getLastModifiedTime();
            try {
                target.getContent().setLastModifiedTime(sourceTimestamp);
            }
            catch (FileSystemException e) {
                if (PublishUtils.isFatal(e)) {
                    throw e;
                }
                context.getConfig().setPreserveTimestamps(false);
                LOG.warn("Failed to set timestamp of a file " + target.getName().getPath(), (Throwable)e);
                String path = context.isServerSideModification() ? context.getServer().getPresentablePath(target) : DeploymentPathUtils.getLocalPath(target);
                String message = WDBundle.message("failed.to.set.timestamp", path);
                context.console(message, ConsoleViewContentType.ERROR_OUTPUT);
            }
        }
        if (context.getConfig().getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE) {
            try {
                ThrowableComputable revisionFactory;
                FileObject localFile = context.isServerSideModification() ? source : target;
                FileObject remotefile = context.isServerSideModification() ? target : source;
                long timestamp = remotefile.getContent().getLastModifiedTime();
                if (localFile.getContent().getSize() <= DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
                    revisionFactory = () -> new DeploymentRevisionTracker.Revision(timestamp, FileTransferUtil.getContent(localFile, context.getProgressIndicator()));
                } else {
                    LOG.warn("File " + DeploymentPathUtils.getLocalPath(localFile) + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
                    revisionFactory = null;
                }
                context.getRevisionTracker().putBaseRevision(DeploymentPathUtils.getLocalPath(localFile), context.getServer(), (ThrowableComputable<? extends DeploymentRevisionTracker.Revision, ? extends IOException>)revisionFactory);
            }
            catch (IOException e) {
                LOG.warn("Failed to load content of local file " + source.getName().getPath(), (Throwable)e);
            }
        }
        LOG.debug("Transferred: " + source.getName().getPath());
        context.incCounter("transfer.details.transferred");
        context.incBytesTransmitted(source.getContent().getSize());
        context.addAffectedParentRoot(target.getName(), context.isServerSideModification());
        return true;
    }

    private static void createNewRevision(FileObject source, FileObject target, @NotNull ExecutionContext context) throws FileSystemException {
        Project project;
        if (context == null) {
            TransferOperation.$$$reportNull$$$0(1);
        }
        if ((project = context.getProject()) == null) {
            return;
        }
        FileObject local = context.isServerSideModification() ? source : target;
        long timestamp = source.getContent().getLastModifiedTime();
        try {
            RemoteChangeNotifier.createRevision(project, DeploymentPathUtils.getLocalPath(local), RemoteChangeNotifier.getContent(local, context.getProgressIndicator(), true), timestamp, context.getServer());
        }
        catch (IOException e) {
            LOG.warn("Failed to create revision of of local file " + source.getName().getPath(), (Throwable)e);
        }
    }

    private static void copyFileFrom(FileObject target, FileObject source, ExecutionContext context) throws FileSystemException {
        LOG.assertTrue(!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        if (!source.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)source);
        }
        assert (source.getType() == FileType.FILE) : "Came " + String.valueOf(source.getType());
        if (target.exists() && target.getType() != source.getType()) {
            target.delete(Selectors.SELECT_ALL);
        }
        try {
            FileTransferUtil.copyContent(source, target, context);
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{source, target});
        }
    }

    private static void copyFrom(FileObject target, FileObject source, FileSelector selector, ExecutionContext context) throws FileSystemException {
        LOG.assertTrue(!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        if (!source.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)source);
        }
        ArrayList files = new ArrayList();
        source.findFiles(selector, false, files);
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        for (FileObject srcFile : files) {
            progressIndicator.checkCanceled();
            String relPath = source.getName().getRelativeName(srcFile.getName());
            FileObject destFile = target.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            if (destFile.exists() && destFile.getType() != srcFile.getType()) {
                destFile.deleteAll();
            }
            try {
                if (srcFile.getType().hasContent()) {
                    FileTransferUtil.copyContent(srcFile, destFile, context);
                    continue;
                }
                if (!srcFile.getType().hasChildren()) continue;
                destFile.createFolder();
            }
            catch (IOException e) {
                if (progressIndicator.isCanceled()) {
                    LOG.warn((Throwable)e);
                    progressIndicator.checkCanceled();
                }
                throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{srcFile, destFile});
            }
        }
    }

    private static void delete(FileObject target, ExecutionContext context, boolean removeRevision) throws FileSystemException {
        if (target.exists()) {
            LOG.debug("Deleting (recursively) " + target.getName().getPath());
            try {
                if (!context.promptForOverwrite(null, target)) {
                    String message = WDBundle.message("file.skipped", context.getServer().getPresentablePath(target));
                    context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
                    LOG.debug("Skipped by user: " + target.getName().getPath());
                    context.incCounter("transfer.details.skippedByUser");
                    return;
                }
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/delete.error", (Object)target, (Throwable)e);
            }
            if (!context.isMultipleOperations()) {
                context.getProgressIndicator().setIndeterminate(true);
            }
            try {
                target.delete((FileSelector)new CancellableAllFileSelector(context.getProgressIndicator(), "deleting.0", context.isCancellable()));
                if (removeRevision && context.getConfig().getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE) {
                    DeploymentPathMapping mapping;
                    String localPath = context.isServerSideModification() ? ((mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingDeploy2Local(target, false, (Mappable)context.getServer()).getFirst()) != null ? mapping.mapToLocalPath(target, (Mappable)context.getServer()) : null) : DeploymentPathUtils.getLocalPath(target);
                    if (localPath != null) {
                        try {
                            context.getRevisionTracker().putBaseRevision(localPath, context.getServer(), null);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                if (PublishUtils.isProcessCanceledException(e)) {
                    throw new ProcessCanceledException();
                }
                throw e;
            }
        }
        context.incCounter("transfer.details.deleted");
        context.addAffectedParentRoot(target.getName(), context.isServerSideModification());
    }

    public static boolean areTimestampsEqual(long ts1, long ts2, double accuracy) {
        long delta = Math.abs(ts1 - ts2);
        return accuracy > 0.0 ? (double)delta < accuracy : delta == 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedMasks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createNewRevision";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static final class UserConfirmedDelete
    extends Delete {
        boolean myAutoUpload;

        public UserConfirmedDelete(FileObject target, FileType type) {
            super(target, type == FileType.FOLDER, true);
        }

        public UserConfirmedDelete(WebServerConfig.RemotePath targetPath, boolean isDirectory, boolean deleteRevision, boolean autoUpload) {
            super(targetPath, isDirectory, deleteRevision);
            this.myAutoUpload = autoUpload;
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            PublishConfig projectPublishConfig;
            Ref delete = new Ref();
            final Ref dontAsk = new Ref((Object)0);
            String path = this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath);
            PublishConfig publishConfig2 = context.getConfig();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (publishConfig2.isConfirmBeforeDeletion()) {
                    int deleteCode = context.isServerSideModification() ? Messages.showYesNoDialog((Project)context.getProject(), (String)WDBundle.message("local.file.for.0.was.removed.delete.deployed.file", path), (String)WDBundle.message("uploading.to.0", context.getServer().getName()), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                        public void rememberChoice(boolean isSelected, int exitCode) {
                            if (isSelected) {
                                if (exitCode == 0) {
                                    dontAsk.set((Object)1);
                                } else if (exitCode == 1) {
                                    dontAsk.set((Object)2);
                                }
                            }
                        }
                    }) : Messages.showYesNoDialog((Project)context.getProject(), (String)WDBundle.message("deployed.file.for.0.was.removed.delete.local.file", DeploymentPathUtils.getLocalPath(this.myTarget)), (String)WDBundle.message("update.from.0", context.getServer().getName()), (Icon)Messages.getQuestionIcon());
                    delete.set((Object)(0 == deleteCode ? 1 : 0));
                } else {
                    delete.set((Object)(this.myAutoUpload ? publishConfig2.isRemoteFilesAllowedToDisappearOnAutoupload() : publishConfig2.isDeleteMissingItems()));
                }
            }, ModalityState.nonModal());
            PublishConfig publishConfig3 = projectPublishConfig = context.getProject() != null ? PublishConfig.getInstance(context.getProject()) : null;
            if ((Integer)dontAsk.get() == 1) {
                publishConfig2.setConfirmBeforeDeletion(false);
                if (projectPublishConfig != null) {
                    projectPublishConfig.setConfirmBeforeDeletion(false);
                }
            } else if ((Integer)dontAsk.get() == 2) {
                publishConfig2.setConfirmBeforeDeletion(false);
                publishConfig2.setDeleteMissingItems(false);
                publishConfig2.setRemoteFilesAllowedToDisappearOnAutoupload(false);
                if (projectPublishConfig != null) {
                    projectPublishConfig.setConfirmBeforeDeletion(false);
                    projectPublishConfig.setDeleteMissingItems(false);
                    projectPublishConfig.setRemoteFilesAllowedToDisappearOnAutoupload(false);
                }
            }
            if (((Boolean)delete.get()).booleanValue()) {
                super.execute(context);
            } else {
                String message = WDBundle.message("file.skipped", path);
                context.console(message, ConsoleViewContentType.NORMAL_OUTPUT);
                context.incCounter("transfer.details.skippedByUser");
            }
        }
    }

    public static class ChangePermissions
    extends TransferOperation {
        private final FileObject myTarget;
        private final boolean myIsDirectory;

        public ChangePermissions(FileObject target) throws FileSystemException {
            this.myTarget = target;
            this.myIsDirectory = this.myTarget.getType() == FileType.FOLDER;
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("changing.0.permissions", this.myTarget.getName().getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("change.permissions.detailed", this.myIsDirectory ? 2 : 1, context.getServer().getPresentablePath(this.myTarget), Util.getPermissionsAsString(this.myIsDirectory ? context.getConfig().getFolderPermissions() : context.getConfig().getFilePermissions()));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            TransferOperation.setPermissions(this.myTarget, this.myIsDirectory, context, context.isTolerateSetPermissionsErrors());
            context.incCounter("transfer.details.processed");
            context.addAffectedParentRoot(this.myTarget.getName(), context.isServerSideModification());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                ChangePermissions.$$$reportNull$$$0(0);
            }
            String string = WDBundle.message("failed.to.change.permissions", this.myIsDirectory ? 2 : 1, context.getServer().getPresentablePath(this.myTarget), reason);
            if (string == null) {
                ChangePermissions.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
        }

        @NonNls
        public String toString() {
            return "Chmod " + this.myTarget.getName().getURI();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$ChangePermissions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$ChangePermissions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class RsyncCopy
    extends TransferOperation {
        protected FileObject mySource;
        protected FileName myTargetName;
        protected FileObject myTarget;
        protected WebServerConfig.RemotePath myTargetPath;
        protected FileSystemException myException;

        public RsyncCopy(@NotNull FileObject source, FileName targetName) {
            if (source == null) {
                RsyncCopy.$$$reportNull$$$0(0);
            }
            this.mySource = source;
            this.myTargetName = targetName;
        }

        public RsyncCopy(@NotNull FileObject source, FileObject target) {
            if (source == null) {
                RsyncCopy.$$$reportNull$$$0(1);
            }
            this(source, target.getName());
            this.myTarget = target;
        }

        public RsyncCopy(@NotNull FileObject source, WebServerConfig.RemotePath targetPath) {
            if (source == null) {
                RsyncCopy.$$$reportNull$$$0(2);
            }
            this.mySource = source;
            this.myTargetPath = targetPath;
        }

        protected RsyncCopy() {
        }

        protected RSyncUtil.IndicatorWrapper getIndicatorWrapper(final ExecutionContext context) {
            return new RSyncUtil.IndicatorWrapper(){

                public boolean isCanceled() {
                    return context.getProgressIndicator().isCanceled();
                }

                public void checkCanceled() throws ProcessCanceledException {
                    context.getProgressIndicator().checkCanceled();
                }

                public void addText(@Nls @NotNull String text, @NotNull Key<?> key) {
                    String trimmedText;
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (key == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (StringUtil.isEmpty((String)(trimmedText = StringUtil.trim((String)text)))) {
                        return;
                    }
                    if (ProcessOutputType.isStderr(key)) {
                        FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), StringUtil.trim((String)text), ConsoleViewContentType.ERROR_OUTPUT);
                    } else {
                        FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), StringUtil.trim((String)text), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                }

                public void finished(int exitCode) {
                    if (exitCode != 0) {
                        myException = new FileSystemException(WDBundle.message("rsync.failed", exitCode));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "key";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncCopy$1";
                    objectArray[2] = "addText";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                RsyncCopy.$$$reportNull$$$0(3);
            }
            String path = context.isServerSideModification() ? DeploymentPathUtils.getLocalPath(this.mySource) : context.getServer().getPresentablePath(this.mySource);
            String string = WDBundle.message("file.transfer.failed.rsync", path, reason);
            if (string == null) {
                RsyncCopy.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        public String toString() {
            return "Rsync from " + this.mySource.getName().getPath() + " to " + String.valueOf(this.myTargetName != null ? this.myTargetName.getURI() : this.myTargetPath);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            try {
                String rootFolder = context.getServer().computeWebServerConfig().getFileTransferConfig().getRootFolder();
                RemoteCredentials credentials = WebDeploymentCredentialHelper.getRemoteCredentials(context.getServer().computeWebServerConfig(), context.getProject());
                if (this.myTargetName == null) {
                    this.myTargetName = context.findRemoteFile(this.myTargetPath, true).getName();
                }
                if (this.myTarget == null) {
                    this.myTarget = context.resolveFileName(this.myTargetName, true);
                }
                String sourcePath = this.mySource.getName().getPath() + (this.mySource.isFolder() ? "/" : "");
                if (this.mySource instanceof LocalFile) {
                    if (this.mySource.isFile()) {
                        this.myTarget.getParent().createFolder();
                    } else {
                        this.myTarget.createFolder();
                    }
                    String fullSourcePath = FileUtil.normalize((String)(this.mySource.getName().getRootURI().substring(8) + sourcePath));
                    List<String> excludedMasks = TransferOperation.getExcludedMasks(context, fullSourcePath);
                    RSyncUtil.uploadWithRSync((String)fullSourcePath, (String)(rootFolder + "/" + this.myTargetName.getPath()), (RemoteCredentials)credentials, excludedMasks, (boolean)false, (boolean)context.getConfig().isDeleteMissingItems(), (RSyncUtil.IndicatorWrapper)this.getIndicatorWrapper(context), (boolean)false);
                    if (this.myTarget.getParent() != null) {
                        context.addAffectedParentRoot(this.myTarget.getParent().getName(), true);
                    }
                } else {
                    if (credentials == null) {
                        throw new FileSystemException("RemoteCredentials are null");
                    }
                    String targetPath = this.myTargetName.getRootURI().substring(8) + this.myTargetName.getPath();
                    List excludedMasks = StringUtil.split((String)context.getConfig().getExcludeMask(), (String)";");
                    List<ExcludedPath> excludedPaths = context.getConfig().getExcludedPaths(context.getServer().getId());
                    excludedMasks = ContainerUtil.concat((List)excludedMasks, excludedPaths.stream().filter(it -> !it.isLocal()).map(ExcludedPath::getPath).toList());
                    RSyncOptions rsyncOptions = new RSyncOptions().withVerbose(false).withExcludeElements(excludedMasks);
                    RSyncUtil.downloadFileOrFolderWithRSync((String)targetPath, (String)FileUtil.normalize((String)(rootFolder + "/" + sourcePath)), (RemoteCredentials)credentials, (RSyncUtil.IndicatorWrapper)this.getIndicatorWrapper(context), (RSyncOptions)rsyncOptions);
                    context.addAffectedParentRoot(this.myTarget.getName(), false);
                }
                if (this.myException != null) {
                    throw this.myException;
                }
                context.incCounter("transfer.details.transferred.rsync");
            }
            catch (ExecutionException e) {
                context.increaseFailureCount();
                throw new FileSystemException((Throwable)e);
            }
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            if (context.isServerSideModification()) {
                return WDBundle.message("uploading.0.rsync", this.mySource.getName().getBaseName());
            }
            return WDBundle.message("downloading.0.rsync", this.mySource.getName().getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            if (context.isServerSideModification()) {
                String targetPath = this.myTargetName != null ? context.getServer().getPresentablePath(this.myTargetName) : context.getServer().getPresentablePath(this.myTargetPath);
                return WDBundle.message("upload.0.to.1.rsync", DeploymentPathUtils.getLocalPath(this.mySource), targetPath);
            }
            return WDBundle.message("download.0.to.1.rsync", context.getServer().getPresentablePath(this.mySource), DeploymentPathUtils.getLocalPath(this.myTargetName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncCopy";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class RsyncMultiFileDownloading
    extends RsyncCopy {
        private final Collection<FileObject> sources = new ArrayList<FileObject>();
        private final Collection<String> targets = new ArrayList<String>();

        public void add(FileObject source, FileName target) {
            this.targets.add(target.getPath());
            this.sources.add(source);
        }

        public void add(FileObject source, FileObject target) {
            this.sources.add(source);
            this.targets.add(target.getName().getPath());
        }

        public void add(FileObject source, String target) {
            this.sources.add(source);
            this.targets.add(target);
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("downloading.0.rsync", this.getDownloadedFiles());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("downloading.0.rsync", this.getDownloadedFiles());
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.sources.isEmpty() || this.targets.isEmpty()) {
                return;
            }
            Set localPaths = ContainerUtil.map2Set(this.targets, target -> FileUtil.normalize((String)target));
            Set remotePaths = ContainerUtil.map2Set(this.sources, source -> FileUtil.normalize((String)source.getName().getPath()));
            if (localPaths.size() == 1) {
                new RsyncCopy(this.sources.iterator().next(), Objects.requireNonNull(DeploymentPathUtils.getLocalFile(this.targets.iterator().next()))).execute(context);
                return;
            }
            String localParent = RsyncMultiFileDownloading.getCommonParent(localPaths);
            String remoteParent = RsyncMultiFileDownloading.getCommonRemoteParent(remotePaths);
            Set relativePaths = ContainerUtil.map2Set((Collection)remotePaths, path -> FileUtil.getRelativePath((String)remoteParent, (String)path, (char)'/'));
            List<String> excludedMasks = TransferOperation.getExcludedMasks(context, localParent);
            RemoteCredentials credentials = WebDeploymentCredentialHelper.getRemoteCredentials(context.getServer().computeWebServerConfig(), context.getProject());
            String rootFolder = context.getServer().computeWebServerConfig().getFileTransferConfig().getRootFolder();
            try {
                RSyncUtil.downloadInBatchWithRSync((String)localParent, (String)(rootFolder + "/" + remoteParent), (Collection)relativePaths, (RemoteCredentials)credentials, excludedMasks, (boolean)false, (RSyncUtil.IndicatorWrapper)this.getIndicatorWrapper(context));
                FileObject file = DeploymentPathUtils.getLocalFile(localParent);
                if (file != null) {
                    context.addAffectedParentRoot(file.getName(), false);
                }
                if (this.myException != null) {
                    throw this.myException;
                }
                context.incCounter("transfer.details.transferred.rsync");
            }
            catch (ExecutionException e) {
                context.increaseFailureCount();
                throw new FileSystemException((Throwable)e);
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                RsyncMultiFileDownloading.$$$reportNull$$$0(0);
            }
            String string = WDBundle.message("multi.file.transfer.failed.rsync", this.getDownloadedFiles(), reason);
            if (string == null) {
                RsyncMultiFileDownloading.$$$reportNull$$$0(1);
            }
            return string;
        }

        private String getDownloadedFiles() {
            return StringUtil.join(this.targets, (String)",");
        }

        @Override
        public String toString() {
            return "Downloading via Rsync " + this.getDownloadedFiles();
        }

        private static String getCommonParent(Collection<String> paths) {
            LOG.assertTrue(paths.size() > 1);
            return paths.stream().map(path -> new File((String)path)).reduce((file, file2) -> FileUtil.findAncestor((File)file, (File)file2)).get().getAbsolutePath();
        }

        private static String getCommonRemoteParent(Collection<String> paths) {
            LOG.assertTrue(paths.size() > 1);
            return PathUtil.toSystemIndependentName((String)paths.stream().map(path -> new File((String)path)).reduce((file, file2) -> FileUtil.findAncestor((File)file, (File)file2)).get().getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncMultiFileDownloading";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncMultiFileDownloading";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class RsyncMultiFileUploading
    extends RsyncCopy {
        private final Collection<FileObject> sources = new ArrayList<FileObject>();
        private final Collection<WebServerConfig.RemotePath> targets = new ArrayList<WebServerConfig.RemotePath>();

        public void add(FileObject source, FileName target) {
            this.sources.add(source);
            this.targets.add(new WebServerConfig.RemotePath(target.getPath()));
        }

        public void add(FileObject source, FileObject target) {
            this.sources.add(source);
            this.targets.add(new WebServerConfig.RemotePath(target.getName().getPath()));
        }

        public void add(FileObject source, WebServerConfig.RemotePath target) {
            this.sources.add(source);
            this.targets.add(target);
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("uploading.0.rsync", this.getUploadedFiles());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("uploading.0.rsync", this.getUploadedFiles());
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.sources.isEmpty() || this.targets.isEmpty()) {
                return;
            }
            Set localPaths = ContainerUtil.map2Set(this.sources, source -> FileUtil.normalize((String)(source.getName().getRootURI().substring(8) + source.getName().getPath())));
            if (localPaths.size() == 1) {
                new RsyncCopy(this.sources.iterator().next(), this.targets.iterator().next()).execute(context);
                return;
            }
            String localParent = PathUtil.toSystemIndependentName((String)RsyncMultiFileUploading.getCommonParent(localPaths));
            Set relativePaths = ContainerUtil.map2Set((Collection)localPaths, path -> FileUtil.getRelativePath((String)localParent, (String)path, (char)'/'));
            String remoteParent = PathUtil.toSystemIndependentName((String)RsyncMultiFileUploading.getCommonParent(ContainerUtil.map(this.targets, target -> FileUtil.normalize((String)target.path))));
            List<String> excludedMasks = TransferOperation.getExcludedMasks(context, localParent);
            RemoteCredentials credentials = WebDeploymentCredentialHelper.getRemoteCredentials(context.getServer().computeWebServerConfig(), context.getProject());
            String rootFolder = context.getServer().computeWebServerConfig().getFileTransferConfig().getRootFolder();
            FileObject remoteTarget = context.findRemoteFile(new WebServerConfig.RemotePath(remoteParent), false);
            remoteTarget.createFolder();
            try {
                RSyncUtil.uploadInBatchWithRSync((String)localParent, (String)(rootFolder + "/" + remoteParent), (Collection)relativePaths, (RemoteCredentials)credentials, excludedMasks, (boolean)false, (RSyncUtil.IndicatorWrapper)this.getIndicatorWrapper(context));
                context.addAffectedParentRoot(remoteTarget.getName(), true);
                if (this.myException != null) {
                    throw this.myException;
                }
                context.incCounter("transfer.details.transferred.rsync");
            }
            catch (ExecutionException e) {
                context.increaseFailureCount();
                throw new FileSystemException((Throwable)e);
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                RsyncMultiFileUploading.$$$reportNull$$$0(0);
            }
            String string = WDBundle.message("multi.file.transfer.failed.rsync", this.getUploadedFiles(), reason);
            if (string == null) {
                RsyncMultiFileUploading.$$$reportNull$$$0(1);
            }
            return string;
        }

        private String getUploadedFiles() {
            return StringUtil.join((Collection)ContainerUtil.map(this.sources, it -> it.getName().getPath()), (String)",");
        }

        @Override
        public String toString() {
            return "Uploading via Rsync " + this.getUploadedFiles();
        }

        private static String getCommonParent(Collection<String> paths) {
            LOG.assertTrue(paths.size() > 1);
            return paths.stream().map(path -> new File((String)path)).reduce((file, file2) -> FileUtil.findAncestor((File)file, (File)file2)).get().getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncMultiFileUploading";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$RsyncMultiFileUploading";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class RemoteMoveOrCopy
    extends TransferOperation {
        private final boolean myIsDirectory;
        private final FileObject myRemoteSource;
        private final FileObject myRemoteTarget;
        private final boolean myForceOverriding;
        private final boolean myIsRename;
        private final boolean myIsMoving;

        public RemoteMoveOrCopy(FileObject remoteSource, FileObject remoteTarget, boolean isDirectory, boolean forceOverwriting, boolean isMoving) {
            this.myIsDirectory = isDirectory;
            this.myRemoteSource = remoteSource;
            this.myRemoteTarget = remoteTarget;
            this.myForceOverriding = forceOverwriting;
            this.myIsRename = DeploymentPathUtils.getParentPath(this.myRemoteSource.getName().getPath()).equals(DeploymentPathUtils.getParentPath(this.myRemoteTarget.getName().getPath()));
            this.myIsMoving = isMoving;
            LOG.assertTrue(!this.myIsRename || this.myIsMoving);
        }

        @Override
        public void prepare(ExecutionContext context) throws FileSystemException {
            if (!this.myForceOverriding && this.myRemoteTarget.exists()) {
                throw new CustomFileSystemException(WDBundle.message("directory.file.1.already.exists", this.myIsDirectory ? 1 : 2, context.getServer().getPresentablePath(this.myRemoteTarget)));
            }
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            if (this.myIsRename) {
                return WDBundle.message("renaming.0", this.myRemoteSource.getName().getBaseName());
            }
            if (this.myIsMoving) {
                return WDBundle.message("moving.0", this.myRemoteSource.getName().getBaseName());
            }
            return WDBundle.message("copying.0", this.myRemoteSource.getName().getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            String item;
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTarget);
            String sourcePath = context.getServer().getPresentablePath(this.myRemoteSource);
            String string = item = this.myIsDirectory ? WDBundle.message("folder", new Object[0]) : WDBundle.message("file", new Object[0]);
            if (this.myIsRename) {
                return WDBundle.message("rename.0.1.to.2", item, sourcePath, targetPath);
            }
            if (this.myIsMoving) {
                return WDBundle.message("move.0.1.to.2", item, sourcePath, targetPath);
            }
            return WDBundle.message("copy.0.1.to.2", item, sourcePath, targetPath);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            TransferOperation.moveOrCopy(context, this.myRemoteSource, this.myRemoteTarget, this.myIsMoving);
            Project project = context.getProject();
            if (project != null && !project.isDefault()) {
                RemoteChangeNotifier notifier = RemoteChangeNotifier.getInstance(project);
                notifier.updateNotificationsForRemoteItem(this.myRemoteSource, context.getConfig(), context.getServer());
                notifier.updateNotificationsForRemoteItem(this.myRemoteTarget, context.getConfig(), context.getServer());
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            String item;
            if (reason == null) {
                RemoteMoveOrCopy.$$$reportNull$$$0(0);
            }
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTarget);
            String sourcePath = context.getServer().getPresentablePath(this.myRemoteSource);
            String string = item = this.myIsDirectory ? WDBundle.message("folder", new Object[0]) : WDBundle.message("file", new Object[0]);
            if (this.myIsRename) {
                String string2 = WDBundle.message("rename.failed", item, sourcePath, targetPath, reason);
                if (string2 == null) {
                    RemoteMoveOrCopy.$$$reportNull$$$0(1);
                }
                return string2;
            }
            if (this.myIsMoving) {
                String string3 = WDBundle.message("move.failed", item, sourcePath, targetPath, reason);
                if (string3 == null) {
                    RemoteMoveOrCopy.$$$reportNull$$$0(2);
                }
                return string3;
            }
            String string4 = WDBundle.message("copy.failed", item, sourcePath, targetPath, reason);
            if (string4 == null) {
                RemoteMoveOrCopy.$$$reportNull$$$0(3);
            }
            return string4;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
        }

        @NonNls
        public String toString() {
            return "Remote move or copy " + (this.myIsMoving ? "(move) :" : "(copy) :") + this.myRemoteSource.getName().getPath() + " to " + this.myRemoteTarget.getName().getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$RemoteMoveOrCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$RemoteMoveOrCopy";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class RemoteMoveOrUpload
    extends TransferOperation {
        private String myLocalTargetPath;
        private final WebServerConfig.RemotePath myRemoteSourcePath;
        private final WebServerConfig.RemotePath myRemoteTargetPath;
        private final boolean myIsDirectory;
        private final boolean myIsRename;
        private boolean myRemoteSourceExists;
        private FileObject myRemoteSource;

        public RemoteMoveOrUpload(String localTargetPath, WebServerConfig.RemotePath remoteSourcePath, WebServerConfig.RemotePath remoteTargetPath, boolean isDirectory) {
            this.myLocalTargetPath = localTargetPath;
            this.myRemoteSourcePath = remoteSourcePath;
            this.myRemoteTargetPath = remoteTargetPath;
            this.myIsDirectory = isDirectory;
            this.myIsRename = DeploymentPathUtils.getParentPath(this.myRemoteSourcePath).equals(DeploymentPathUtils.getParentPath(this.myRemoteTargetPath));
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
            this.myLocalTargetPath = RemoteMoveOrUpload.updateOnParentMove(this.myLocalTargetPath, sourceFrom, sourceTo, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void prepare(ExecutionContext context) throws FileSystemException {
            this.myRemoteSource = context.findRemoteFile(this.myRemoteSourcePath, true);
            this.myRemoteSourceExists = this.myRemoteSource.exists();
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            if (this.myRemoteSourceExists) {
                if (this.myIsRename) {
                    return WDBundle.message("renaming.0", DeploymentPathUtils.getFileName(this.myRemoteSourcePath));
                }
                return WDBundle.message("moving.0", DeploymentPathUtils.getFileName(this.myRemoteSourcePath));
            }
            if (this.myIsDirectory) {
                return WDBundle.message("creating.folder.0", DeploymentPathUtils.getFileName(this.myRemoteTargetPath));
            }
            return WDBundle.message("uploading.0", DeploymentPathUtils.getFileName(this.myRemoteTargetPath));
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTargetPath);
            if (this.myRemoteSourceExists) {
                String sourcePath = context.getServer().getPresentablePath(this.myRemoteSourcePath);
                String item = WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0]);
                if (this.myIsRename) {
                    return WDBundle.message("rename.0.1.to.2", item, sourcePath, targetPath);
                }
                return WDBundle.message("move.0.1.to.2", item, sourcePath, targetPath);
            }
            if (this.myIsDirectory) {
                return WDBundle.message("create.folder.0.detailed", targetPath);
            }
            return WDBundle.message("upload.0.to.1", this.myLocalTargetPath, targetPath);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            LOG.assertTrue(context.isServerSideModification());
            FileObject localTarget = DeploymentPathUtils.getLocalFile(this.myLocalTargetPath);
            if (localTarget == null) {
                throw new FileSystemException(WDBundle.message("error.message.failed.to.resolve.local.path.0", this.myLocalTargetPath));
            }
            FileObject remoteTarget = context.findRemoteFile(this.myRemoteTargetPath, true);
            RemoteChangeNotifier notifier = null;
            Project project = context.getProject();
            if (project != null && !project.isDefault()) {
                notifier = RemoteChangeNotifier.getInstance(project);
            }
            if (this.myRemoteSourceExists) {
                FileObject remoteTargetParent = remoteTarget.getParent();
                if (remoteTargetParent != null && !remoteTargetParent.exists()) {
                    TransferOperation.createFolder(remoteTargetParent, context);
                }
                if (this.myIsDirectory || RemoteMoveOrUpload.isUpToDate(localTarget, this.myRemoteSource, context.getServer())) {
                    TransferOperation.moveOrCopy(context, this.myRemoteSource, remoteTarget, true);
                } else {
                    TransferOperation.delete(this.myRemoteSource, context, false);
                    TransferOperation.copyFile(localTarget, remoteTarget, context);
                }
                if (notifier != null) {
                    notifier.updateNotificationsForRemoteItem(this.myRemoteSource, context.getConfig(), context.getServer());
                    notifier.updateNotificationsForRemoteItem(remoteTarget, context.getConfig(), context.getServer());
                }
            } else if (this.myIsDirectory) {
                TransferOperation.createFolder(remoteTarget, context);
            } else {
                TransferOperation.copyFile(localTarget, remoteTarget, context);
                if (notifier != null) {
                    notifier.updateNotificationsForLocalItem(localTarget, context);
                }
            }
        }

        public FileObject getSource() {
            return this.myRemoteSource;
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                RemoteMoveOrUpload.$$$reportNull$$$0(0);
            }
            String targetPath = context.getServer().getPresentablePath(this.myRemoteTargetPath);
            if (this.myRemoteSourceExists) {
                String sourcePath = context.getServer().getPresentablePath(this.myRemoteSourcePath);
                String item = WDBundle.message(this.myIsDirectory ? "folder" : "file", new Object[0]);
                if (this.myIsRename) {
                    String string = WDBundle.message("rename.failed", item, sourcePath, targetPath, reason);
                    if (string == null) {
                        RemoteMoveOrUpload.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = WDBundle.message("move.failed", item, sourcePath, targetPath, reason);
                if (string == null) {
                    RemoteMoveOrUpload.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.myIsDirectory) {
                String string = WDBundle.message("failed.to.create.folder", targetPath, reason);
                if (string == null) {
                    RemoteMoveOrUpload.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = WDBundle.message("file.transfer.failed", targetPath, reason);
            if (string == null) {
                RemoteMoveOrUpload.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "Remote move or upload: " + String.valueOf(this.myRemoteSourcePath) + " to " + String.valueOf(this.myRemoteTargetPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$RemoteMoveOrUpload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$RemoteMoveOrUpload";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class SpeculativeCreateRemoteDirectoryAndResolveChildren
    extends TransferOperation
    implements SpeculativeChildTransferOperation {
        private final FileObject myLocalSource;
        private final FileName myTargetName;
        private final DeploymentPathMapping myMapping;
        private boolean isCancelled;
        private final Collection<SpeculativeChildTransferOperation> myChildren;
        @Nullable
        private FileObject myProvidedTarget;

        public SpeculativeCreateRemoteDirectoryAndResolveChildren(@NotNull FileObject localSource, @NotNull FileName targetName, @NotNull DeploymentPathMapping mapping) {
            if (localSource == null) {
                SpeculativeCreateRemoteDirectoryAndResolveChildren.$$$reportNull$$$0(0);
            }
            if (targetName == null) {
                SpeculativeCreateRemoteDirectoryAndResolveChildren.$$$reportNull$$$0(1);
            }
            if (mapping == null) {
                SpeculativeCreateRemoteDirectoryAndResolveChildren.$$$reportNull$$$0(2);
            }
            this.isCancelled = false;
            this.myChildren = new ArrayList<SpeculativeChildTransferOperation>();
            this.myProvidedTarget = null;
            this.myLocalSource = localSource;
            this.myTargetName = targetName;
            this.myMapping = mapping;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("creating.folder.0", this.myTargetName.getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("create.folder.0.detailed", context.getServer().getPresentablePath(this.myTargetName));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.isCancelled) {
                this.cancelChildren();
                return;
            }
            FileObject target = this.myProvidedTarget == null ? context.resolveFileName(this.myTargetName, true) : this.myProvidedTarget;
            FileType targetType = target.getType();
            switch (targetType) {
                case FILE: {
                    throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", context.getServer().getPresentablePath(target)));
                }
                case FOLDER: {
                    ChangePermissions changePermissionsOperation = DeploymentPathUtils.createChangePermissionsOperationIfNeeded(target, (ThrowableComputable<FileType, ? extends FileSystemException>)((ThrowableComputable)() -> targetType), context);
                    if (changePermissionsOperation == null) break;
                    try {
                        SpeculativeCreateRemoteDirectoryAndResolveChildren.executeNestedOperation(changePermissionsOperation, context);
                        break;
                    }
                    catch (FileSystemException e) {
                        LOG.warn(String.valueOf(changePermissionsOperation) + " failed", (Throwable)e);
                        String text = ((TransferOperation)changePermissionsOperation).getErrorMessage(context, PublishUtils.getMessage(e, true));
                        context.console(text, ConsoleViewContentType.ERROR_OUTPUT);
                        if (!PublishUtils.isFatal(e)) {
                            context.increaseFailureCount();
                            break;
                        }
                        throw e;
                    }
                }
                case IMAGINARY: {
                    CreateFolder createFolderOperation = DeploymentPathUtils.createCreateTargetFolderOperationIfNeeded(target, (ThrowableComputable<FileType, ? extends FileSystemException>)((ThrowableComputable)() -> targetType), context);
                    if (createFolderOperation == null) break;
                    SpeculativeCreateRemoteDirectoryAndResolveChildren.executeNestedOperation(createFolderOperation, context);
                }
            }
            Set names = Arrays.stream(this.myLocalSource.getChildren()).map(child -> child.getName().getBaseName()).collect(Collectors.toSet());
            Map resolvedChildren = target.getResolvedChildren(names);
            for (SpeculativeChildTransferOperation child2 : this.myChildren) {
                child2.useChildMap(resolvedChildren);
            }
            DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions = new DeploymentPathUtils.ErrorsAndExclusions();
            ArrayList<TransferOperation> operations = new ArrayList<TransferOperation>();
            DeploymentPathUtils.createDeleteMissingItemsOperations(target, true, this.myMapping, errorsAndExclusions, operations, context);
            for (String error : errorsAndExclusions.getReadOnlyErrors()) {
                context.console(error, ConsoleViewContentType.ERROR_OUTPUT);
            }
            for (String excludedPath : errorsAndExclusions.getReadOnlyPaths()) {
                context.console(WDBundle.message("excluded.message", excludedPath), ConsoleViewContentType.NORMAL_OUTPUT);
                context.incCounter("transfer.details.excluded");
            }
            try {
                for (TransferOperation operation : operations) {
                    SpeculativeCreateRemoteDirectoryAndResolveChildren.executeNestedOperation(operation, context);
                }
            }
            catch (FileSystemException e) {
                this.cancelChildren();
                throw e;
            }
        }

        private static void executeNestedOperation(TransferOperation operation, ExecutionContext context) throws FileSystemException {
            context.getProgressIndicator().checkCanceled();
            operation.execute(context);
        }

        private void cancelChildren() {
            for (SpeculativeChildTransferOperation child : this.myChildren) {
                child.cancel();
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                SpeculativeCreateRemoteDirectoryAndResolveChildren.$$$reportNull$$$0(3);
            }
            String string = WDBundle.message("failed.to.create.folder", context.getServer().getPresentablePath(this.myTargetName), reason);
            if (string == null) {
                SpeculativeCreateRemoteDirectoryAndResolveChildren.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
        }

        @Override
        public void useChildMap(@NotNull Map<String, FileObject> resolvedChildren) {
            if (resolvedChildren == null) {
                SpeculativeCreateRemoteDirectoryAndResolveChildren.$$$reportNull$$$0(5);
            }
            this.myProvidedTarget = resolvedChildren.get(this.myTargetName.getBaseName());
        }

        public void addChildOperation(SpeculativeChildTransferOperation operation) {
            this.myChildren.add(operation);
        }

        @NonNls
        public String toString() {
            return "Speculative create folder " + this.myTargetName.getURI();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$SpeculativeCreateRemoteDirectoryAndResolveChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$SpeculativeCreateRemoteDirectoryAndResolveChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "useChildMap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static interface AsynchronousOperation {
        public FileObject getParentSource() throws FileSystemException;
    }

    static interface SpeculativeChildTransferOperation {
        public void cancel();

        public void useChildMap(@NotNull Map<String, FileObject> var1);
    }

    public static class CreateFolder
    extends TransferOperation {
        private FileObject myTarget;
        private WebServerConfig.RemotePath myTargetPath;

        public CreateFolder(FileObject target) {
            this.myTarget = target;
        }

        public CreateFolder(WebServerConfig.RemotePath targetPath) {
            this.myTargetPath = targetPath;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            String name = this.myTarget != null ? this.myTarget.getName().getBaseName() : DeploymentPathUtils.getFileName(this.myTargetPath);
            return WDBundle.message("creating.folder.0", name);
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            String path = context.isServerSideModification() ? (this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath)) : DeploymentPathUtils.getLocalPath(this.myTarget);
            return WDBundle.message("create.folder.0.detailed", path);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.myTarget == null) {
                this.myTarget = context.findRemoteFile(this.myTargetPath, true);
            }
            TransferOperation.createFolder(this.myTarget, context);
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                CreateFolder.$$$reportNull$$$0(0);
            }
            String path = this.myTargetPath != null ? context.getServer().getPresentablePath(this.myTargetPath) : DeploymentPathUtils.getLocalPath(this.myTarget);
            String string = WDBundle.message("failed.to.create.folder", path, reason);
            if (string == null) {
                CreateFolder.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "Create folder " + String.valueOf(this.myTarget != null ? this.myTarget.getName().getURI() : this.myTargetPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$CreateFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$CreateFolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class Delete
    extends TransferOperation {
        protected FileObject myTarget;
        protected WebServerConfig.RemotePath myTargetPath;
        private final boolean myIsDirectory;
        private final boolean myDeleteRevision;

        public Delete(FileObject target, boolean isDirectory, boolean deleteRevision) {
            this.myTarget = target;
            this.myIsDirectory = isDirectory;
            this.myDeleteRevision = deleteRevision;
        }

        public Delete(WebServerConfig.RemotePath targetPath, boolean isDirectory, boolean deleteRevision) {
            this.myTargetPath = targetPath;
            this.myIsDirectory = isDirectory;
            this.myDeleteRevision = deleteRevision;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            String name = this.myTarget != null ? this.myTarget.getName().getBaseName() : DeploymentPathUtils.getFileName(this.myTargetPath);
            return WDBundle.message("deleting.0", name);
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            String path = context.isServerSideModification() ? (this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath)) : (this.myTarget != null ? DeploymentPathUtils.getLocalPath(this.myTarget) : this.myTargetPath.path);
            return WDBundle.message("delete.0.detailed", this.myIsDirectory ? 2 : 1, path);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.myTarget == null) {
                this.myTarget = context.findRemoteFile(this.myTargetPath, true);
            }
            TransferOperation.delete(this.myTarget, context, this.myDeleteRevision);
            Project project = context.getProject();
            if (project != null && !project.isDefault() && !project.isDisposed()) {
                RemoteChangeNotifier.getInstance(project).updateNotificationsForRemoteItem(this.myTarget, context.getConfig(), context.getServer());
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                Delete.$$$reportNull$$$0(0);
            }
            String path = this.myTargetPath != null ? context.getServer().getPresentablePath(this.myTargetPath) : DeploymentPathUtils.getLocalPath(this.myTarget);
            String string = WDBundle.message("failed.to.delete", this.myIsDirectory ? 2 : 1, path, reason);
            if (string == null) {
                Delete.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "Delete " + String.valueOf(this.myTarget != null ? this.myTarget.getName().getURI() : this.myTargetPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$Delete";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$Delete";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class SpeculativeFileUpload
    extends TransferOperation
    implements SpeculativeChildTransferOperation,
    AsynchronousOperation {
        private final FileObject myLocalSource;
        private final FileName myTargetName;
        private boolean isCancelled;
        private FileObject myProvidedTarget;

        public SpeculativeFileUpload(@NotNull FileObject localSource, @NotNull FileName targetName) {
            if (localSource == null) {
                SpeculativeFileUpload.$$$reportNull$$$0(0);
            }
            if (targetName == null) {
                SpeculativeFileUpload.$$$reportNull$$$0(1);
            }
            this.isCancelled = false;
            this.myLocalSource = localSource;
            this.myTargetName = targetName;
        }

        @Override
        public FileObject getParentSource() throws FileSystemException {
            return this.myLocalSource.getParent();
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("uploading.0", this.myLocalSource.getName().getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            String targetPath = context.getServer().getPresentablePath(this.myTargetName);
            return WDBundle.message("upload.0.to.1", DeploymentPathUtils.getLocalPath(this.myLocalSource), targetPath);
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.isCancelled) {
                return;
            }
            FileObject target = this.myProvidedTarget == null ? context.resolveFileName(this.myTargetName, true) : this.myProvidedTarget;
            SpeculativeCreateRemoteDirectoryAndResolveChildren.executeNestedOperation(new Copy(this.myLocalSource, target), context);
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                SpeculativeFileUpload.$$$reportNull$$$0(2);
            }
            String string = WDBundle.message("file.transfer.failed", DeploymentPathUtils.getLocalPath(this.myLocalSource), reason);
            if (string == null) {
                SpeculativeFileUpload.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
        }

        @Override
        public void useChildMap(@NotNull Map<String, FileObject> resolvedChildren) {
            if (resolvedChildren == null) {
                SpeculativeFileUpload.$$$reportNull$$$0(4);
            }
            this.myProvidedTarget = resolvedChildren.get(this.myLocalSource.getName().getBaseName());
        }

        @NonNls
        public String toString() {
            return "Speculative upload: " + this.myLocalSource.getName().getURI() + " to " + this.myTargetName.getURI();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$SpeculativeFileUpload";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$SpeculativeFileUpload";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "useChildMap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParallelFilesUpload
    extends TransferOperation {
        private List<TransferOperation> myEntries = new ArrayList<TransferOperation>(100);
        private List<TransferOperation> failed;
        private FileObject myParentSource;
        private CompositeFileSystemException myException;
        protected boolean mySuccessfullyFinished;

        public ParallelFilesUpload(FileObject parentSource) {
            this.myParentSource = parentSource;
        }

        public ParallelFilesUpload() {
        }

        public void add(TransferOperation operation) {
            this.myEntries.add(operation);
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            return this.myParentSource != null ? (context.isServerSideModification() ? WDBundle.message("uploading.multiple", DeploymentPathUtils.getLocalPath(this.myParentSource)) : WDBundle.message("downloading.multiple", context.getServer().getPresentablePath(this.myParentSource))) : (context.isServerSideModification() ? WDBundle.message("uploading.multiple.no.parent", new Object[0]) : WDBundle.message("downloading.multiple.no.parent", new Object[0]));
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            StringBuilder result = new StringBuilder();
            for (TransferOperation operation : this.myEntries) {
                result.append(operation.getDetailedText(context)).append("\n");
            }
            StringUtil.trimEnd((StringBuilder)result, (CharSequence)"\n");
            return result.toString();
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            this.myException = null;
            this.failed = Collections.synchronizedList(new ArrayList());
            ExecutorService poolExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Deployment", (int)context.getServer().getNumberOfConnections());
            for (TransferOperation operation : this.myEntries) {
                poolExecutor.execute(() -> {
                    block4: {
                        try {
                            context.getProgressIndicator().checkCanceled();
                            if (this.myException == null || !this.myException.shouldStopExecution()) {
                                operation.execute(context);
                            }
                        }
                        catch (FileSystemException e) {
                            this.failed.add(operation);
                            if (this.myException == null) {
                                this.myException = new CompositeFileSystemException(e);
                            }
                            this.myException.addException(e);
                            if (this.myException.shouldStopExecution()) break block4;
                            context.increaseFailureCount();
                        }
                    }
                });
            }
            this.myEntries = this.failed;
            ParallelFilesUpload.waitTillPoolIsFinished(poolExecutor);
            context.getProgressIndicator().checkCanceled();
            if (this.myException != null && !this.myException.isEmpty()) {
                throw this.myException;
            }
        }

        private static void waitTillPoolIsFinished(ExecutorService poolExecutor) {
            poolExecutor.shutdown();
            try {
                poolExecutor.awaitTermination(24L, TimeUnit.HOURS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                ParallelFilesUpload.$$$reportNull$$$0(0);
            }
            String string = WDBundle.message("failed.parallel.operation", this.failed.size(), reason);
            if (string == null) {
                ParallelFilesUpload.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "Parallel operations: " + String.valueOf(this.myEntries);
        }

        public int getSize() {
            return this.myEntries.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$ParallelFilesUpload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$ParallelFilesUpload";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        static class CompositeFileSystemException
        extends FileSystemException {
            private final List<FileSystemException> myExceptions = Collections.synchronizedList(new ArrayList());
            private final AtomicReference<Boolean> hasFatalError = new AtomicReference<Boolean>(false);

            CompositeFileSystemException(Throwable throwable) {
                super(throwable);
            }

            public void addException(FileSystemException exception) {
                this.myExceptions.add(exception);
                this.hasFatalError.compareAndSet(false, PublishUtils.isFatal(exception));
            }

            public List<FileSystemException> getAllExceptions() {
                return this.myExceptions;
            }

            public boolean shouldStopExecution() {
                return this.hasFatalError.get();
            }

            public boolean isEmpty() {
                return this.myExceptions.isEmpty();
            }
        }
    }

    public static class Copy
    extends TransferOperation
    implements AsynchronousOperation {
        protected FileObject mySource;
        protected FileObject myTarget;
        private WebServerConfig.RemotePath myTargetPath;
        protected boolean mySuccessfullyFinished;

        public Copy(FileObject source, FileObject target) {
            this.mySource = source;
            this.myTarget = target;
        }

        public Copy(FileObject source, WebServerConfig.RemotePath targetPath) {
            this.mySource = source;
            this.myTargetPath = targetPath;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) throws FileSystemException {
            this.mySource = Copy.updateOnParentMove(this.mySource, sourceFrom, sourceTo);
        }

        @Override
        public FileObject getParentSource() throws FileSystemException {
            return this.mySource.getParent();
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            if (context.isServerSideModification()) {
                return WDBundle.message("uploading.0", this.mySource.getName().getBaseName());
            }
            return WDBundle.message("downloading.0", this.mySource.getName().getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            if (context.isServerSideModification()) {
                String targetPath = this.myTarget != null ? context.getServer().getPresentablePath(this.myTarget) : context.getServer().getPresentablePath(this.myTargetPath);
                return WDBundle.message("upload.0.to.1", DeploymentPathUtils.getLocalPath(this.mySource), targetPath);
            }
            return WDBundle.message("download.0.to.1", context.getServer().getPresentablePath(this.mySource), DeploymentPathUtils.getLocalPath(this.myTarget));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            if (this.myTarget == null) {
                this.myTarget = context.findRemoteFile(this.myTargetPath, true);
            }
            this.mySuccessfullyFinished = TransferOperation.copyFile(this.mySource, this.myTarget, context);
            Project project = context.getProject();
            if (project != null && !project.isDefault() && !project.isDisposed()) {
                RemoteChangeNotifier notifier = RemoteChangeNotifier.getInstance(project);
                if (context.isServerSideModification()) {
                    notifier.updateNotificationsForLocalItem(this.mySource, context);
                } else {
                    notifier.updateNotificationsForLocalItem(this.myTarget, context);
                }
            }
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                Copy.$$$reportNull$$$0(0);
            }
            String path = context.isServerSideModification() ? DeploymentPathUtils.getLocalPath(this.mySource) : context.getServer().getPresentablePath(this.mySource);
            String string = WDBundle.message("file.transfer.failed", path, reason);
            if (string == null) {
                Copy.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "Copy: " + this.mySource.getName().getURI() + " to " + String.valueOf(this.myTarget != null ? this.myTarget.getName().getURI() : this.myTargetPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$Copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$Copy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class CreateRemoteFile
    extends TransferOperation {
        private final String myContent;
        private final FileObject myTarget;

        public CreateRemoteFile(@NotNull String fileContent, FileObject target) {
            if (fileContent == null) {
                CreateRemoteFile.$$$reportNull$$$0(0);
            }
            this.myContent = fileContent;
            this.myTarget = target;
        }

        @Override
        @NlsContexts.ProgressText
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("creating.0", this.myTarget.getName().getBaseName());
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("create.0.detailed", context.getServer().getPresentablePath(this.myTarget));
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getErrorMessage(ExecutionContext context, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String reason) {
            if (reason == null) {
                CreateRemoteFile.$$$reportNull$$$0(1);
            }
            String string = WDBundle.message("create.failed", context.getServer().getPresentablePath(this.myTarget), reason);
            if (string == null) {
                CreateRemoteFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            LOG.assertTrue(context.isServerSideModification());
            if (this.myTarget.getType() == FileType.FOLDER) {
                throw new CustomFileSystemException(WDBundle.message("path.represents.a.folder", context.getServer().getPresentablePath(this.myTarget)));
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.myTarget.getContent().getOutputStream(), StandardCharsets.UTF_8);
            try {
                writer.write(this.myContent);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            TransferOperation.setPermissions(this.myTarget, false, context, true);
            LOG.debug("File " + this.myTarget.getName().getURI() + " was created with given content");
            context.incCounter("transfer.details.transferred");
            context.incBytesTransmitted(this.myContent.length());
            context.addAffectedParentRoot(this.myTarget.getName(), true);
        }

        @NonNls
        public String toString() {
            return "Create file at " + this.myTarget.getName().getURI();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileContent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferOperation$CreateRemoteFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferOperation$CreateRemoteFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

