/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.actions;

import com.dmarcotte.handlebars.HbLanguage;
import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbBlockWrapper;
import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbMustache;
import com.dmarcotte.handlebars.psi.HbMustacheName;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbPsiUtil;
import com.dmarcotte.handlebars.psi.HbSimpleInverse;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class HbTypedHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(HbTypedHandler.class);
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACES = "}}";

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        int offset;
        if (project == null) {
            HbTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HbTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            HbTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            HbTypedHandler.$$$reportNull$$$0(3);
        }
        if ((offset = editor.getCaretModel().getOffset()) == 0 || offset > editor.getDocument().getTextLength()) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                HbTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        String previousChar = editor.getDocument().getText(new TextRange(offset - 1, offset));
        if (file.getLanguage() instanceof HbLanguage) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (c == '{' && previousChar.equals(OPEN_BRACE)) {
                editor.getDocument().insertString(offset, (CharSequence)Character.toString(c));
                editor.getCaretModel().moveToOffset(offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    HbTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            HbTypedHandler.$$$reportNull$$$0(6);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            HbTypedHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            HbTypedHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            HbTypedHandler.$$$reportNull$$$0(9);
        }
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider provider = file.getViewProvider();
        if (!provider.getBaseLanguage().isKindOf((Language)HbLanguage.INSTANCE)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                HbTypedHandler.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (offset < 2 || offset > editor.getDocument().getTextLength()) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                HbTypedHandler.$$$reportNull$$$0(11);
            }
            return result;
        }
        String previousChar = editor.getDocument().getText(new TextRange(offset - 2, offset - 1));
        boolean closeBraceCompleted = false;
        if (file.getLanguage() instanceof HbLanguage && HbConfig.isAutocompleteMustachesEnabled() && c == '}' && !previousChar.equals("}")) {
            PsiElement mustache;
            ASTNode node;
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement elementAt = provider.findElementAt(offset - 1, provider.getBaseLanguage());
            ASTNode aSTNode = node = elementAt != null ? elementAt.getNode() : null;
            if (node != null && node.getElementType() == HbTokenTypes.INVALID && (mustache = PsiTreeUtil.findFirstParent((PsiElement)elementAt, psiElement -> psiElement instanceof HbMustache)) != null) {
                String braceCompleter = mustache.getFirstChild().getNode().getElementType() == HbTokenTypes.OPEN_UNESCAPED ? CLOSE_BRACES : "}";
                editor.getDocument().insertString(offset, (CharSequence)braceCompleter);
                editor.getCaretModel().moveToOffset(offset += braceCompleter.length());
                closeBraceCompleted = true;
            }
        }
        if (closeBraceCompleted || c == '}' && previousChar.equals("}")) {
            HbTypedHandler.autoInsertCloseTag(project, offset, editor, provider);
            HbTypedHandler.adjustMustacheFormatting(project, offset, editor, file, provider);
        } else if (c == '/' && previousChar.equals(OPEN_BRACE)) {
            HbTypedHandler.finishClosingTag(offset, editor, provider);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            HbTypedHandler.$$$reportNull$$$0(12);
        }
        return result;
    }

    private static void finishClosingTag(int offset, Editor editor, FileViewProvider provider) {
        HbBlockWrapper block;
        PsiElement elementAtCaret = provider.findElementAt(offset - 1, HbLanguage.class);
        if (elementAtCaret != null && (block = (HbBlockWrapper)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, HbBlockWrapper.class)) != null) {
            HbMustacheName mustacheName;
            HbOpenBlockMustache open = (HbOpenBlockMustache)PsiTreeUtil.findChildOfType((PsiElement)block, HbOpenBlockMustache.class);
            HbCloseBlockMustache close = (HbCloseBlockMustache)PsiTreeUtil.findChildOfType((PsiElement)block, HbCloseBlockMustache.class);
            if (open != null && close == null && (mustacheName = (HbMustacheName)PsiTreeUtil.findChildOfType((PsiElement)open, HbMustacheName.class)) != null) {
                if (offset > 3) {
                    String prePreviousChar = editor.getDocument().getText(new TextRange(offset - 3, offset - 2));
                    if (prePreviousChar.equals(OPEN_BRACE)) {
                        editor.getDocument().insertString(offset, (CharSequence)(mustacheName.getText() + CLOSE_BRACES));
                        editor.getCaretModel().moveToOffset(offset + mustacheName.getText().length() + CLOSE_BRACES.length());
                    } else {
                        editor.getDocument().replaceString(offset - 1, offset, (CharSequence)("{/" + mustacheName.getText() + CLOSE_BRACES));
                        editor.getCaretModel().moveToOffset(offset + mustacheName.getText().length() + CLOSE_BRACES.length() + 1);
                    }
                } else {
                    LOG.warn("Unexpected offset inside HbBlockWrapper element");
                }
            }
        }
    }

    private static void autoInsertCloseTag(Project project, int offset, Editor editor, FileViewProvider provider) {
        HbMustacheName mustacheName;
        if (!HbConfig.isAutoGenerateCloseTagEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement elementAtCaret = provider.findElementAt(offset - 1, HbLanguage.class);
        if (elementAtCaret == null || elementAtCaret.getNode().getElementType() != HbTokenTypes.CLOSE) {
            return;
        }
        HbOpenBlockMustache openTag = HbPsiUtil.findParentOpenTagElement(elementAtCaret);
        if (openTag != null && openTag.getChildren().length > 1 && (mustacheName = (HbMustacheName)PsiTreeUtil.findChildOfType((PsiElement)openTag, HbMustacheName.class)) != null) {
            editor.getDocument().insertString(offset, (CharSequence)("{{/" + mustacheName.getText() + CLOSE_BRACES));
        }
    }

    private static void adjustMustacheFormatting(Project project, int offset, Editor editor, PsiFile file, FileViewProvider provider) {
        if (!HbConfig.isFormattingEnabled()) {
            return;
        }
        PsiElement elementAtCaret = provider.findElementAt(offset - 1, HbLanguage.class);
        PsiElement closeOrSimpleInverseParent = PsiTreeUtil.findFirstParent((PsiElement)elementAtCaret, (boolean)true, element -> element instanceof HbSimpleInverse || element instanceof HbCloseBlockMustache);
        if (closeOrSimpleInverseParent != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            CaretModel caretModel = editor.getCaretModel();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.adjustLineIndent(file, editor.getDocument().getLineStartOffset(caretModel.getLogicalPosition().line));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/editor/actions/HbTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/editor/actions/HbTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

