/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.file;

import com.dmarcotte.handlebars.file.HbTemplateUtilKt;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HbFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myBaseLanguage;
    private final Language myTemplateLanguage;
    private static final ConcurrentMap<String, TemplateDataElementType> TEMPLATE_DATA_TO_LANG = new ConcurrentHashMap<String, TemplateDataElementType>();

    private static TemplateDataElementType getTemplateDataElementType(Language lang) {
        TemplateDataElementType result = (TemplateDataElementType)TEMPLATE_DATA_TO_LANG.get(lang.getID());
        if (result != null) {
            return result;
        }
        TemplateDataElementType created = new TemplateDataElementType("HB_TEMPLATE_DATA", lang, HbTokenTypes.CONTENT, HbTokenTypes.OUTER_ELEMENT_TYPE){

            @NotNull
            protected TemplateDataModifications appendCurrentTemplateToken(int tokenEndOffset, @NotNull CharSequence tokenText) {
                if (tokenText == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.endsWithChar((CharSequence)tokenText, (char)'=')) {
                    TemplateDataModifications templateDataModifications = TemplateDataModifications.fromRangeToRemove((int)tokenEndOffset, (CharSequence)"\"\"");
                    if (templateDataModifications == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return templateDataModifications;
                }
                TemplateDataModifications templateDataModifications = super.appendCurrentTemplateToken(tokenEndOffset, tokenText);
                if (templateDataModifications == null) {
                    1.$$$reportNull$$$0(2);
                }
                return templateDataModifications;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tokenText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/dmarcotte/handlebars/file/HbFileViewProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/dmarcotte/handlebars/file/HbFileViewProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "appendCurrentTemplateToken";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "appendCurrentTemplateToken";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        TemplateDataElementType prevValue = TEMPLATE_DATA_TO_LANG.putIfAbsent(lang.getID(), created);
        return prevValue == null ? created : prevValue;
    }

    public HbFileViewProvider(PsiManager manager, VirtualFile file, boolean physical, Language baseLanguage) {
        this(manager, file, physical, baseLanguage, HbFileViewProvider.getTemplateDataLanguage(manager, file));
    }

    public HbFileViewProvider(PsiManager manager, VirtualFile file, boolean physical, Language baseLanguage, Language templateLanguage) {
        super(manager, file, physical);
        this.myBaseLanguage = baseLanguage;
        this.myTemplateLanguage = templateLanguage;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            HbFileViewProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    @NotNull
    private static Language getTemplateDataLanguage(PsiManager manager, VirtualFile file) {
        Language dataLang = TemplateDataLanguageMappings.getInstance((Project)manager.getProject()).getMapping(file);
        if (dataLang == null) {
            dataLang = HbTemplateUtilKt.guessTemplateLanguage(file);
        }
        Language substituteLang = LanguageSubstitutors.getInstance().substituteLanguage(dataLang, file, manager.getProject());
        if (TemplateDataLanguageMappings.getTemplateableLanguages().contains(substituteLang)) {
            dataLang = substituteLang;
        }
        Language language = dataLang;
        if (language == null) {
            HbFileViewProvider.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            HbFileViewProvider.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateLanguage;
        if (language == null) {
            HbFileViewProvider.$$$reportNull$$$0(3);
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Set.of(this.myBaseLanguage, this.getTemplateDataLanguage());
        if (set == null) {
            HbFileViewProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            HbFileViewProvider.$$$reportNull$$$0(5);
        }
        return new HbFileViewProvider((PsiManager)this.getManager(), virtualFile, false, this.myBaseLanguage, this.myTemplateLanguage);
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition parserDefinition;
        if (lang == null) {
            HbFileViewProvider.$$$reportNull$$$0(6);
        }
        if ((parserDefinition = this.getDefinition(lang)) == null) {
            return null;
        }
        if (lang.is(this.getTemplateDataLanguage())) {
            PsiFile file = parserDefinition.createFile((FileViewProvider)this);
            IElementType type = this.getContentElementType(lang);
            if (type != null) {
                ((PsiFileImpl)file).setContentElementType(type);
            }
            return file;
        }
        if (lang.isKindOf(this.getBaseLanguage())) {
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            HbFileViewProvider.$$$reportNull$$$0(7);
        }
        if (language.is(this.getTemplateDataLanguage())) {
            return HbFileViewProvider.getTemplateDataElementType(this.getBaseLanguage());
        }
        return null;
    }

    private ParserDefinition getDefinition(Language lang) {
        ParserDefinition parserDefinition = lang.isKindOf(this.getBaseLanguage()) ? (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang.is(this.getBaseLanguage()) ? lang : this.getBaseLanguage()) : (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        return parserDefinition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/file/HbFileViewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/file/HbFileViewProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportsIncrementalReparse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

