/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.doc.TaskPsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public final class TaskCellRenderer
extends DefaultListCellRenderer {
    private final Project myProject;

    public TaskCellRenderer(Project project) {
        this.myProject = project;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean focus) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIUtil.getListBackground((boolean)sel));
        panel.setForeground(UIUtil.getListForeground((boolean)sel));
        if (value instanceof TaskPsiElement) {
            boolean isClosed;
            Task task = ((TaskPsiElement)((Object)value)).getTask();
            SimpleColoredComponent c = new SimpleColoredComponent();
            TaskManager taskManager = TaskManager.getManager((Project)this.myProject);
            boolean isLocalTask = taskManager.findTask(task.getId()) != null;
            boolean bl = isClosed = task.isClosed() || task instanceof LocalTask && taskManager.isLocallyClosed((LocalTask)task);
            Color bg = sel ? UIUtil.getListSelectionBackground((boolean)true) : (isLocalTask ? UIUtil.getListBackground() : UIUtil.getDecoratedRowColor());
            panel.setBackground(bg);
            SimpleTextAttributes attr = TaskCellRenderer.getAttributes(sel, isClosed);
            c.setIcon(isClosed ? IconLoader.getTransparentIcon((Icon)task.getIcon()) : task.getIcon());
            SpeedSearchUtil.appendColoredFragmentForMatcher((String)task.getPresentableName(), (SimpleColoredComponent)c, (SimpleTextAttributes)attr, (Matcher)MatcherHolder.getAssociatedMatcher((JComponent)list), (Color)bg, (boolean)sel);
            panel.add((Component)c, "Center");
        } else if ("...".equals(value)) {
            SimpleColoredComponent c = new SimpleColoredComponent();
            c.setIcon(EmptyIcon.ICON_16);
            c.append((String)value);
            panel.add((Component)c, "Center");
        } else if (GotoTaskAction.CREATE_NEW_TASK_ACTION == value) {
            SimpleColoredComponent c = new SimpleColoredComponent();
            c.setIcon(LayeredIcon.create((Icon)AllIcons.FileTypes.Unknown, (Icon)AllIcons.Actions.New));
            c.append(GotoTaskAction.CREATE_NEW_TASK_ACTION.getActionText());
            panel.add((Component)c, "Center");
        }
        return panel;
    }

    private static SimpleTextAttributes getAttributes(boolean selected, boolean taskClosed) {
        return new SimpleTextAttributes(0, taskClosed ? UIUtil.getLabelDisabledForeground() : UIUtil.getListForeground((boolean)selected));
    }
}

