/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ExpressionParser;
import com.intellij.sql.dialects.mongo.js.JSArrowFunctionDetector;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JSParseResult;
import com.intellij.sql.dialects.mongo.js.JSParsingContextUtil;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;
import com.intellij.sql.dialects.mongo.js.JavaScriptParserBase;
import com.intellij.sql.dialects.mongo.js.StatementParser;
import org.jetbrains.annotations.NotNull;

public class FunctionParser
extends JavaScriptParserBase {
    public static final Key<String> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");
    public static final String METHODS_EMPTINESS_ALWAYS = "a";
    public static final String METHODS_EMPTINESS_POSSIBLY = "p";
    public static final Key<Boolean> HAD_GET_SET = Key.create((String)"js.getsetParser");

    protected FunctionParser(JavaScriptParser parser2) {
        super(parser2);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSElementTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        String prevMethodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            FunctionParser.$$$reportNull$$$0(0);
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSElementTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSElementTypes.MULT) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = this.isGeneratorContext();
        this.setIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.function.name", (Object[])new Object[0]));
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= !this.parseParameterList((boolean)(context == Context.EXPRESSION || context == Context.PROPERTY ? true : false)).hasErrors;
        this.myJavaScriptParser.getTypeParser().tryParseFunctionReturnType();
        String methodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSElementTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
        } else if (METHODS_EMPTINESS_ALWAYS.equals(methodEmptiness)) {
            if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                String key = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(DatabaseBundle.message((String)key, (Object[])new Object[0]));
            }
        } else if (METHODS_EMPTINESS_POSSIBLY.equals(methodEmptiness)) {
            if (functionKeywordWasOmitted && JSElementTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
            } else if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                parsedWithoutErrors &= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.setIsGenerator(wasGenerator);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        if (this.parseGetSetAndNameAfterFunctionKeyword(context)) {
            return true;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSElementTypes.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    protected boolean parseGetSetAndNameAfterFunctionKeyword(Context context) {
        IElementType firstToken = this.builder.getTokenType();
        if (JSElementTypes.GET_SET.contains(firstToken) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSElementTypes.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && this.myJavaScriptParser.getExpressionParser().isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                this.myJavaScriptParser.getExpressionParser().parsePropertyName();
                return true;
            }
        }
        return false;
    }

    public void parseFunctionIdentifier() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSElementTypes.PROPERTY_NAMES.contains(tokenType)) {
            this.myJavaScriptParser.getExpressionParser().advancePropertyName(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSElementTypes.EXPORT_KEYWORD || type == JSElementTypes.GET_KEYWORD || type == JSElementTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    public IElementType getAttributeListElementType() {
        return JSElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.AT);
        while (this.builder.getTokenType() == JSElementTypes.AT) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            ExpressionParser expressionParser2 = this.myJavaScriptParser.getExpressionParser();
            expressionParser2.parseLeftHandSideExpression(false, false);
            attribute.done((IElementType)JSElementTypes.ES6_DECORATOR);
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation;
        boolean bl = hadAnnotation = this.builder.getTokenType() == JSElementTypes.AT;
        if (hadAnnotation && this.hasSupportDecorators()) {
            this.parseES7Decorators();
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public JSParseResult parseParameterList(boolean funExpr) {
        if (this.builder.getTokenType() != JSElementTypes.LPAR) {
            this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.lparen", (Object[])new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            return JSParseResult.UNACCEPTABLE;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean first2 = true;
        while (this.builder.getTokenType() != JSElementTypes.RPAR) {
            if (first2) {
                first2 = false;
            } else if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSElementTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSElementTypes.DOT) {
                this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.parameter.name", (Object[])new Object[0]));
                while (this.builder.getTokenType() == JSElementTypes.DOT) {
                    this.builder.advanceLexer();
                }
                hasErrors = true;
            }
            hasErrors |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSElementTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        return JSParseResult.acceptable(hasErrors, null);
    }

    public boolean parseSingleParameter(PsiBuilder.Marker parameter) {
        JSParseResult result = this.doParseSingleParameter();
        IElementType elementType = result.elementType;
        if (elementType != null) {
            parameter.done(elementType);
        } else {
            parameter.drop();
        }
        return !result.hasErrors;
    }

    @NotNull
    protected JSParseResult doParseSingleParameter() {
        boolean acceptResult;
        IElementType tokenType;
        boolean hasErrors = false;
        IElementType elementType = this.getParameterType();
        boolean allowPropertyNameAsIdentifier = this.parseParameterAttributeList();
        if (this.isParameterName(allowPropertyNameAsIdentifier, tokenType = this.builder.getTokenType())) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            this.myJavaScriptParser.getTypeParser().tryParseType();
            if (this.builder.getTokenType() == JSElementTypes.EQ) {
                this.builder.advanceLexer();
                if (!this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(true)) {
                    this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.expression", (Object[])new Object[0]));
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = this.myJavaScriptParser.getExpressionParser().parseDestructuringElementNoMarker(this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.formal.parameter.name", (Object[])new Object[0]));
            hasErrors = true;
            if (this.builder.getTokenType() == JSElementTypes.EQ) {
                this.builder.advanceLexer();
                this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(true);
            } else {
                this.myJavaScriptParser.getTypeParser().tryParseType();
            }
            acceptResult = false;
        }
        JSParseResult jSParseResult = acceptResult && elementType != null ? JSParseResult.acceptable(hasErrors, elementType) : JSParseResult.UNACCEPTABLE;
        if (jSParseResult == null) {
            FunctionParser.$$$reportNull$$$0(1);
        }
        return jSParseResult;
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSElementTypes.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    public IElementType getParameterType() {
        return JSElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    public boolean willParseDestructuringAssignment() {
        return FunctionParser.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    public static boolean willParseDestructuringAssignment(IElementType tokenType) {
        return tokenType == JSElementTypes.LBRACKET || tokenType == JSElementTypes.LBRACE;
    }

    protected boolean parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSElementTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
        return false;
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionWithoutModifiers(this.builder.mark());
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType firstToken;
        if (arrowFunction == null) {
            FunctionParser.$$$reportNull$$$0(2);
        }
        if (this.isIdentifierToken(firstToken = this.builder.getTokenType()) && JSElementTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!JSArrowFunctionDetector.INSTANCE.isArrowFunctionExpression(this.builder, this)) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            IElementType afterParameterListToken = this.builder.getTokenType();
            if (afterParameterListToken == JSElementTypes.COLON && !this.myJavaScriptParser.getTypeParser().tryParseArrowFunctionReturnType()) {
                arrowFunction.rollbackTo();
                return false;
            }
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSElementTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            this.myJavaScriptParser.getStatementParser().parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
        } else {
            this.builder.error(DatabaseBundle.message((String)"MongoJS.parser.message.expected.eqgt", (Object[])new Object[0]));
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    protected boolean isValidFirstParameterStart(IElementType next) {
        if (next == JSElementTypes.RPAR || next == JSElementTypes.DOT_DOT_DOT || FunctionParser.willParseDestructuringAssignment(next)) {
            return true;
        }
        boolean isParameterName = this.isParameterName(true, next);
        if (!isParameterName) {
            return false;
        }
        int lookaheadSteps = 2;
        if (next == JSElementTypes.CLASS_KEYWORD || next == JSElementTypes.FUNCTION_KEYWORD || next == JSElementTypes.ASYNC_KEYWORD && (next = this.builder.lookAhead(lookaheadSteps++)) == JSElementTypes.FUNCTION_KEYWORD) {
            IElementType lookAhead = this.builder.lookAhead(lookaheadSteps);
            if (this.isIdentifierToken(lookAhead)) {
                return false;
            }
            if (next == JSElementTypes.FUNCTION_KEYWORD) {
                return lookAhead != JSElementTypes.LPAR && lookAhead != JSElementTypes.MULT;
            }
            return lookAhead != JSElementTypes.LBRACE;
        }
        return true;
    }

    protected boolean supportsColonTypeCast() {
        return false;
    }

    public IElementType getParameterListElementType() {
        return JSElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return JSParsingContextUtil.isAsyncContext(this.builder);
    }

    public void setIsGenerator(boolean isGenerator) {
        JSParsingContextUtil.setIsGenerator(isGenerator, this.builder);
    }

    public boolean isGeneratorContext() {
        return JSParsingContextUtil.isGeneratorContext(this.builder);
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        boolean lexerAdvanced = !this.myJavaScriptParser.getFunctionParser().parseParameterList((boolean)false).hasErrors;
        lexerAdvanced |= this.myJavaScriptParser.getTypeParser().tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= this.myJavaScriptParser.getStatementParser().parseFunctionBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/js/FunctionParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/js/FunctionParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseSingleParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }
}

