/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PgSelectFromProcedureInspection
extends SqlInspectionBase {
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isPostgres()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, (SqlLanguageDialect)dialect, result){

            public void visitSqlAsExpression(SqlAsExpression o) {
                this.processExpression(o.getExpression(), o.getColumnAliasList());
            }

            public void visitSqlFromClause(SqlFromClause o) {
                super.visitSqlFromClause(o);
                SqlExpression expression = o.getFromExpression();
                this.processExpression(expression, Collections.emptyList());
            }

            private void processExpression(SqlExpression expression, List<SqlDefinition> aliases) {
                SqlFunctionCallExpression function;
                if (expression instanceof SqlFunctionCallExpression) {
                    this.processFunctionCall((SqlFunctionCallExpression)expression, aliases);
                } else if (expression instanceof SqlExplicitTableExpression && (function = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlFunctionCallExpression.class)) != null) {
                    this.processFunctionCall(function, aliases);
                }
            }

            private void processFunctionCall(SqlFunctionCallExpression functionCall, List<SqlDefinition> aliases) {
                boolean needTypedAliasDefinition = PgSelectFromProcedureInspection.needTypedAliasDefinition(functionCall);
                if (needTypedAliasDefinition && aliases.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)functionCall, DatabaseBundle.message((String)"inspection.message.function.call.must.have.typed.alias.definition", (Object[])new Object[0]), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return;
                }
                for (SqlDefinition alias : aliases) {
                    if (alias.getKind() != ObjectKind.COLUMN) continue;
                    SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class);
                    if (needTypedAliasDefinition && type == null) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)alias, DatabaseBundle.message((String)"inspection.message.alias.must.have.type", (Object[])new Object[0]), (LocalQuickFix)new MyAddTypeQuickFix(alias), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                    if (needTypedAliasDefinition || type == null) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)alias, DatabaseBundle.message((String)"inspection.message.alias.can.have.type", (Object[])new Object[0]), (LocalQuickFix)new MyRemoveTypeQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static boolean needTypedAliasDefinition(@Nullable DasType returnType) {
        if (returnType == null) {
            return false;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)returnType.getSpecification(), (CharSequence)"record")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)DasTypeUtilsKt.getTypeName((DasType)returnType), (CharSequence)"table")) {
            String arg = returnType.toDataType().vagueArg;
            return arg != null && StringUtil.endsWithIgnoreCase((String)arg, (String)" record");
        }
        return false;
    }

    private static boolean needTypedAliasDefinition(@NotNull SqlFunctionCallExpression functionCall) {
        SqlReferenceExpression nameElement;
        if (functionCall == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(3);
        }
        if ((nameElement = functionCall.getNameElement()) == null) {
            return false;
        }
        String functionName = nameElement.getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)functionName, (CharSequence)"dblink")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)functionName, (CharSequence)"pg_stat_file")) {
            return false;
        }
        DasSymbol symbol = nameElement.resolveSymbol();
        if (symbol instanceof DasRoutine) {
            DasType type;
            DasRoutine routine2 = (DasRoutine)symbol;
            for (DasArgument info2 : DasUtil.getParameters((DasRoutine)routine2)) {
                ArgumentDirection type2 = info2.getArgumentDirection();
                if (type2 != ArgumentDirection.OUT && type2 != ArgumentDirection.INOUT) continue;
                return false;
            }
            DasArgument retArg = routine2.getReturnArgument();
            DasType dasType = type = retArg == null ? null : retArg.getDasType();
            if (PgSelectFromProcedureInspection.needTypedAliasDefinition(type)) {
                return true;
            }
        } else if (symbol instanceof BuiltinFunction) {
            for (BuiltinFunction.Prototype prototype : ((BuiltinFunction)symbol).getPrototypes()) {
                if (!PgSelectFromProcedureInspection.needTypedAliasDefinition(prototype.getReturnType().getDasType())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "needTypedAliasDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyAddTypeQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements DumbAware {
        private MyAddTypeQuickFix(SqlDefinition alias) {
            super((PsiElement)alias);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"add.type.element", (Object[])new Object[0]);
            if (string == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor2, @NotNull PsiElement alias, @NotNull PsiElement endElement) {
            if (project == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(3);
            }
            if (alias == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (alias instanceof SqlDefinition) {
                SqlNameElement name2 = ((SqlDefinition)alias).getNameElement();
                Document document = psiFile.getViewProvider().getDocument();
                if (name2 != null && document != null) {
                    int offset = name2.getTextRange().getEndOffset();
                    String defaultType = "int";
                    document.insertString(offset, (CharSequence)(" " + defaultType));
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    if (editor2 != null) {
                        int startOffset = offset + 1;
                        editor2.getCaretModel().moveToOffset(startOffset);
                        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor2.getSelectionModel().setSelection(startOffset, startOffset + defaultType.length());
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyAddTypeQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyAddTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyRemoveTypeQuickFix
    implements LocalQuickFix,
    DumbAware {
        private MyRemoveTypeQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DatabaseBundle.message((String)"intention.family.name.remove.type.element", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            SqlTypeElement type;
            PsiElement alias;
            if (project == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(2);
            }
            if ((alias = descriptor2.getPsiElement()) instanceof SqlDefinition && (type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class)) != null) {
                type.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyRemoveTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyRemoveTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

