/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.SemVer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptDisposable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberPackage;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;

public class CucumberJavaScriptRunningState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final CucumberJavaScriptRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myExecutionEnvironment;

    public CucumberJavaScriptRunningState(ExecutionEnvironment env, CucumberJavaScriptRunConfiguration runConfiguration) {
        this.myExecutionEnvironment = env;
        this.myRunConfiguration = runConfiguration;
    }

    private GeneralCommandLine getCommand(int debugPort) throws ExecutionException {
        boolean isESM;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        if (this.myRunConfiguration.getFilePath() == null) {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.can.t.find.feature.to.run", new Object[0]));
        }
        this.myRunConfiguration.getEnvData().configureCommandLine(commandLine, true);
        NodeJsLocalInterpreter interpreter = this.myRunConfiguration.getInterpreterRef().resolveAsLocal(this.myRunConfiguration.getProject());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)true);
        NodePackage cucumberNodePackage = CucumberJavaScriptUtil.getCucumberPackage(this.myRunConfiguration.getProject(), (NodeJsInterpreter)interpreter);
        String cucumberExecutable = "/bin/cucumber";
        if (cucumberNodePackage.getVersion() != null && cucumberNodePackage.getVersion().getMajor() >= 4) {
            cucumberExecutable = "/bin/cucumber-js";
        }
        String cucumberExecutablePath = FileUtil.toSystemDependentName((String)(cucumberNodePackage.getSystemDependentPath() + cucumberExecutable));
        commandLine.addParameter(cucumberExecutablePath);
        VirtualFile fileToRun = CucumberJavaScriptRunningState.virtualFileFromPath(this.myRunConfiguration.getFilePath());
        if (fileToRun != null) {
            if (fileToRun.getExtension() != null && FileTypeRegistry.getInstance().isFileOfType(fileToRun, (FileType)GherkinFileType.INSTANCE)) {
                commandLine.addParameter(FileUtil.toSystemDependentName((String)fileToRun.getPath()));
            }
            if (fileToRun.isDirectory()) {
                commandLine.addParameter(FileUtil.toSystemDependentName((String)fileToRun.getPath()));
            }
            if (!fileToRun.isDirectory()) {
                fileToRun = fileToRun.getParent();
            }
        } else {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.can.t.find.feature.to.run", new Object[0]));
        }
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getNameFilter())) {
            commandLine.addParameter("--name");
            commandLine.addParameter(this.myRunConfiguration.getNameFilter());
        }
        if (!this.myRunConfiguration.getCucumberJsArguments().isEmpty()) {
            commandLine.addParameters(this.myRunConfiguration.getCucumberJsArguments().split(" "));
        }
        CucumberPackage cucumberPackage = CucumberPackage.fromNodePackage(cucumberNodePackage);
        String workingDirectory = this.getWorkingDir();
        commandLine.withWorkDirectory(workingDirectory);
        if (cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(7, 0, 0)) {
            CucumberJavaScriptRunningState.addCommandLineParameters(commandLine, workingDirectory, cucumberPackage, CucumberJavaScriptUtil.getV7FormatterPath());
        } else if (cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(3, 0, 0)) {
            CucumberJavaScriptRunningState.addCommandLineParameters(commandLine, workingDirectory, cucumberPackage, CucumberJavaScriptUtil.getV3FormatterPath());
        } else if (cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(2, 0, 0)) {
            CucumberJavaScriptRunningState.addCommandLineParameters(commandLine, workingDirectory, cucumberPackage, CucumberJavaScriptUtil.getV2FormatterPath());
        } else {
            commandLine.addParameter("--format");
            commandLine.addParameter("summary");
            commandLine.addParameter("--require");
            commandLine.addParameter(CucumberJavaScriptUtil.getFormatterPath());
        }
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)fileToRun);
        boolean bl = isESM = packageJson != null && PackageJsonData.getOrCreate((VirtualFile)packageJson).isModuleType();
        if (isESM && cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(8, 0, 0)) {
            commandLine.addParameter("--import");
        } else {
            commandLine.addParameter("--require");
        }
        commandLine.addParameter(fileToRun.getPath());
        return commandLine;
    }

    private String getWorkingDir() {
        String workingDir = this.myRunConfiguration.getWorkingDirectory();
        return FileUtil.toSystemIndependentName((String)(workingDir == null ? "" : workingDir));
    }

    private ConsoleView createSMTRunnerConsoleView() {
        SMTRunnerConsoleProperties testConsoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)this.myRunConfiguration, "cucumber", this.myExecutionEnvironment.getExecutor());
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)"cucumber", (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new UrlFilter());
        Disposer.register((Disposable)CucumberJavaScriptDisposable.getInstance(this.myExecutionEnvironment.getProject()), (Disposable)consoleView);
        return consoleView;
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        GeneralCommandLine commandLine = this.getCommand(debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        ConsoleView consoleView = this.createSMTRunnerConsoleView();
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        return new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
    }

    private static void addCommandLineParameters(GeneralCommandLine commandLine, String workingDirectory, CucumberPackage cucumberPackage, String formatterPath) throws ExecutionException {
        commandLine.addParameter("--format");
        if (cucumberPackage.version != null && cucumberPackage.version.getMajor() == 2) {
            String relativeFormatterPath = FileUtil.getRelativePath((String)workingDirectory, (String)formatterPath, (char)'/');
            if (relativeFormatterPath == null) {
                throw new ExecutionException(CucumberJavaScriptBundle.message("run.configuration.state.cant.find.path.to.formatter", formatterPath, workingDirectory));
            }
            commandLine.addParameter(FileUtil.toSystemDependentName((String)relativeFormatterPath));
        } else {
            commandLine.addParameter(CucumberJavaScriptRunningState.escapePathParameter(formatterPath, cucumberPackage.version));
        }
        commandLine.addParameter("--format-options");
        commandLine.addParameter(String.format("{\"cucumberLibPath\": \"%s\"}", cucumberPackage.libPath));
        if (cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(5, 0, 0)) {
            commandLine.addParameter("--format-options");
            commandLine.addParameter("{\"colorsEnabled\": true}");
        }
        if (cucumberPackage.version != null && cucumberPackage.version.isGreaterOrEqualThan(7, 0, 0) && !cucumberPackage.version.isGreaterOrEqualThan(9, 4, 0)) {
            commandLine.addParameter("--publish-quiet");
        }
    }

    @NotNull
    private static String escapePathParameter(@NotNull String formatterPath, @Nullable SemVer cucumberVersion) {
        String path;
        if (formatterPath == null) {
            CucumberJavaScriptRunningState.$$$reportNull$$$0(0);
        }
        if (FileUtil.isAbsolute((String)(path = FileUtil.toSystemDependentName((String)formatterPath))) && SystemInfoRt.isWindows && cucumberVersion != null && cucumberVersion.isGreaterOrEqualThan(8, 0, 0)) {
            String string = StringUtil.wrapWithDoubleQuote((String)("file://" + path));
            if (string == null) {
                CucumberJavaScriptRunningState.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            CucumberJavaScriptRunningState.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static VirtualFile virtualFileFromPath(@NotNull String path) {
        if (path == null) {
            CucumberJavaScriptRunningState.$$$reportNull$$$0(3);
        }
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escapePathParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapePathParameter";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileFromPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

