/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.terminal.backend.BackendTerminalSession;
import com.intellij.terminal.backend.StateAwareTerminalSession;
import com.intellij.terminal.session.TerminalBlocksModelState;
import com.intellij.terminal.session.TerminalCommandFinishedEvent;
import com.intellij.terminal.session.TerminalCommandStartedEvent;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import com.intellij.terminal.session.TerminalCursorPositionChangedEvent;
import com.intellij.terminal.session.TerminalInitialStateEvent;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalOutputModelState;
import com.intellij.terminal.session.TerminalPromptFinishedEvent;
import com.intellij.terminal.session.TerminalPromptStartedEvent;
import com.intellij.terminal.session.TerminalSessionTerminatedEvent;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalStateChangedEvent;
import com.intellij.terminal.session.dto.StyleRangeDto;
import com.intellij.terminal.session.dto.StyleRangeDtoKt;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalStateDto;
import com.intellij.terminal.session.dto.TerminalStateDtoKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModelImpl;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporterKt;
import org.jetbrains.plugins.terminal.fus.DurationAndTextLength;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 82\u00020\u0001:\u000278B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!H\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010'\u001a\u00020%H\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0082@\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0016\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020#H\u0002J\b\u00102\u001a\u00020\u000bH\u0002J\b\u00103\u001a\u00020\u0013H\u0002J\u0018\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u00132\u0006\u00101\u001a\u000206H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010&\u00a8\u00069"}, d2={"Lcom/intellij/terminal/backend/StateAwareTerminalSession;", "Lcom/intellij/terminal/backend/BackendTerminalSession;", "delegate", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/terminal/backend/BackendTerminalSession;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "outputFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/terminal/backend/StateAwareTerminalSession$VersionedEvents;", "modelsLock", "Lkotlinx/coroutines/sync/Mutex;", "modelsVersion", "", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "alternateBufferModel", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "outputLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lkotlin/time/Duration;", "documentUpdateLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/DurationAndTextLength;", "getInputChannel", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/intellij/terminal/session/TerminalInputEvent;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOutputFlow", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/intellij/terminal/session/TerminalOutputEvent;", "isClosed", "", "()Z", "hasRunningCommands", "handleOriginalEvents", "", "events", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doHandleEvents", "forwardEventsToOutputFlow", "versionedEvents", "(Lcom/intellij/terminal/backend/StateAwareTerminalSession$VersionedEvents;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleEvent", "event", "createInitialStateEvents", "getCurrentOutputModel", "updateOutputModelContent", "model", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "VersionedEvents", "Companion", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nStateAwareTerminalSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateAwareTerminalSession.kt\ncom/intellij/terminal/backend/StateAwareTerminalSession\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 BatchLatencyReporter.kt\norg/jetbrains/plugins/terminal/fus/BatchLatencyReporterKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n116#2,11:221\n24#3:232\n1761#4,3:233\n1563#4:236\n1634#4,3:237\n1803#4,3:241\n1011#4,2:247\n1011#4,2:276\n101#5:240\n87#5:244\n89#5:246\n90#5,2:249\n50#5:251\n52#5,20:253\n87#5:273\n89#5:275\n90#5,2:278\n1#6:245\n1#6:252\n1#6:274\n*S KotlinDebug\n*F\n+ 1 StateAwareTerminalSession.kt\ncom/intellij/terminal/backend/StateAwareTerminalSession\n*L\n116#1:221,11\n135#1:232\n145#1:233,3\n205#1:236\n205#1:237,3\n59#1:241,3\n60#1:247,2\n62#1:276,2\n59#1:240\n60#1:244\n60#1:246\n60#1:249,2\n61#1:251\n61#1:253,20\n62#1:273\n62#1:275\n62#1:278,2\n60#1:245\n61#1:252\n62#1:274\n*E\n"})
public final class StateAwareTerminalSession
implements BackendTerminalSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BackendTerminalSession delegate;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableSharedFlow<VersionedEvents> outputFlow;
    @NotNull
    private final Mutex modelsLock;
    private long modelsVersion;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalOutputModel alternateBufferModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final BatchLatencyReporter<Duration> outputLatencyReporter;
    @NotNull
    private final BatchLatencyReporter<DurationAndTextLength> documentUpdateLatencyReporter;
    @NotNull
    private static final AtomicLong eventsVersionCounter = new AtomicLong(0L);

    public StateAwareTerminalSession(@NotNull BackendTerminalSession delegate, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.delegate = delegate;
        this.coroutineScope = coroutineScope;
        this.outputFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.modelsLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.modelsVersion = -1L;
        this.sessionModel = new TerminalSessionModelImpl();
        this.outputLatencyReporter = new BatchLatencyReporter(100, StateAwareTerminalSession::outputLatencyReporter$lambda$0);
        this.documentUpdateLatencyReporter = new BatchLatencyReporter(100, StateAwareTerminalSession::documentUpdateLatencyReporter$lambda$4);
        DocumentImpl outputDocument = new DocumentImpl((CharSequence)"", true);
        this.outputModel = new TerminalOutputModelImpl((Document)outputDocument, TerminalUiUtils.INSTANCE.getDefaultMaxOutputLength());
        DocumentImpl alternateBufferDocument = new DocumentImpl((CharSequence)"", true);
        this.alternateBufferModel = new TerminalOutputModelImpl((Document)alternateBufferDocument, 0);
        this.blocksModel = new TerminalBlocksModelImpl((Document)outputDocument);
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), (CoroutineContext)((CoroutineContext)new CoroutineName("StateAwareTerminalSession: models updating")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ StateAwareTerminalSession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = StateAwareTerminalSession.access$getDelegate$p(this.this$0).getOutputFlow((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        originalOutputFlow = (Flow)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)originalOutputFlow);
                        this.label = 2;
                        v1 = originalOutputFlow.collect(new FlowCollector(){

                            public final Object emit(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
                                Object object = this$0.handleOriginalEvents(events, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        originalOutputFlow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Nullable
    public Object getInputChannel(@NotNull Continuation<? super SendChannel<? super TerminalInputEvent>> $completion) {
        return this.delegate.getInputChannel($completion);
    }

    @Nullable
    public Object getOutputFlow(@NotNull Continuation<? super Flow<? extends List<? extends TerminalOutputEvent>>> $completion) {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super List<? extends TerminalOutputEvent>>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StateAwareTerminalSession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                FlowCollector flowCollector = (FlowCollector)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$flow;
                        ResultKt.throwOnFailure((Object)$result);
                        Ref.LongRef initialStateVersion = new Ref.LongRef();
                        initialStateVersion.element = -1L;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$flow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)initialStateVersion);
                        this.label = 1;
                        Object object2 = StateAwareTerminalSession.access$getOutputFlow$p(this.this$0).collect(new FlowCollector(initialStateVersion, this.this$0, (FlowCollector<? super List<? extends TerminalOutputEvent>>)$this$flow){
                            final /* synthetic */ Ref.LongRef $initialStateVersion;
                            final /* synthetic */ StateAwareTerminalSession this$0;
                            final /* synthetic */ FlowCollector<List<? extends TerminalOutputEvent>> $$this$flow;
                            {
                                this.$initialStateVersion = $initialStateVersion;
                                this.this$0 = $receiver;
                                this.$$this$flow = $$this$flow;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object emit(VersionedEvents it, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof getOutputFlow.emit.1)) ** GOTO lbl-1000
                                var11_3 = $completion;
                                if ((var11_3.label & -2147483648) != 0) {
                                    var11_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        Object L$1;
                                        Object L$2;
                                        int I$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ getOutputFlow.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.$initialStateVersion.element != -1L) ** GOTO lbl57
                                        var4_6 = StateAwareTerminalSession.access$getModelsLock$p(this.this$0);
                                        var6_7 = this.this$0;
                                        owner$iv = null;
                                        $i$f$withLock = 0;
                                        $continuation.L$0 = it;
                                        $continuation.L$1 = $this$withLock_u24default$iv;
                                        $continuation.L$2 = var6_7;
                                        $continuation.I$0 = $i$f$withLock;
                                        $continuation.label = 1;
                                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                                        if (v0 == var12_5) {
                                            return var12_5;
                                        }
                                        ** GOTO lbl34
                                    }
                                    case 1: {
                                        $i$f$withLock = $continuation.I$0;
                                        var6_7 = (StateAwareTerminalSession)$continuation.L$2;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                                        it = (VersionedEvents)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl34:
                                        // 2 sources

                                        try {
                                            $i$a$-withLock$default-StateAwareTerminalSession$getOutputFlow$2$1$initialState$1 = false;
                                            var9_13 = StateAwareTerminalSession.access$createInitialStateEvents(var6_7);
                                        }
                                        finally {
                                            $this$withLock_u24default$iv.unlock(owner$iv);
                                        }
                                        initialState = var9_13;
                                        $continuation.L$0 = it;
                                        $continuation.L$1 = initialState;
                                        $continuation.L$2 = null;
                                        $continuation.label = 2;
                                        v1 = this.$$this$flow.emit(initialState.getEvents(), (Continuation)$continuation);
                                        if (v1 == var12_5) {
                                            return var12_5;
                                        }
                                        ** GOTO lbl56
                                    }
                                    case 2: {
                                        initialState = (VersionedEvents)$continuation.L$1;
                                        it = (VersionedEvents)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl56:
                                        // 2 sources

                                        this.$initialStateVersion.element = initialState.getVersion();
lbl57:
                                        // 2 sources

                                        if (it.getVersion() <= this.$initialStateVersion.element) break;
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        $continuation.L$1 = null;
                                        $continuation.label = 3;
                                        v2 = this.$$this$flow.emit(it.getEvents(), (Continuation)$continuation);
                                        if (v2 == var12_5) {
                                            return var12_5;
                                        }
                                        ** GOTO lbl69
                                    }
                                    case 3: {
                                        it = (VersionedEvents)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl69:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Ref.LongRef initialStateVersion = (Ref.LongRef)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super List<? extends TerminalOutputEvent>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Nullable
    public Object hasRunningCommands(@NotNull Continuation<? super Boolean> $completion) {
        return this.delegate.hasRunningCommands($completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object handleOriginalEvents(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleOriginalEvents.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StateAwareTerminalSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StateAwareTerminalSession.access$handleOriginalEvents(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                versionedEvents = new VersionedEvents(events, 0L, 2, null);
                $this$withLock_u24default$iv = this.modelsLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = events;
                $continuation.L$1 = versionedEvents;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                ** if (v0 != var12_5) goto lbl26
lbl25:
                // 1 sources

                return var12_5;
lbl26:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                versionedEvents = (VersionedEvents)$continuation.L$1;
                events = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                try {
                    $i$a$-withLock$default-StateAwareTerminalSession$handleOriginalEvents$2 = false;
                    this.doHandleEvents(events);
                    this.modelsVersion = versionedEvents.getVersion();
                    var8_16 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)events);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)versionedEvents);
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = this.forwardEventsToOutputFlow(versionedEvents, (Continuation<? super Unit>)$continuation);
                if (v1 == var12_5) {
                    return var12_5;
                }
                break;
            }
            case 2: {
                versionedEvents = (VersionedEvents)$continuation.L$1;
                events = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        catch (Throwable var4_10) {
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)events);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)versionedEvents);
            $continuation.L$2 = var4_10;
            $continuation.label = 3;
            v2 = this.forwardEventsToOutputFlow(versionedEvents, (Continuation<? super Unit>)$continuation);
            if (v2 == var12_5) {
                return var12_5;
            }
            ** GOTO lbl77
        }
        {
            case 3: {
                var4_11 = (Throwable)$continuation.L$2;
                versionedEvents = (VersionedEvents)$continuation.L$1;
                events = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl77:
                // 2 sources

                throw var4_11;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void doHandleEvents(List<? extends TerminalOutputEvent> events) {
        for (TerminalOutputEvent terminalOutputEvent : events) {
            try {
                this.handleEvent(terminalOutputEvent);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable t) {
                StateAwareTerminalSession $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(StateAwareTerminalSession.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object forwardEventsToOutputFlow(VersionedEvents versionedEvents, Continuation<? super Unit> $completion) {
        if (!($completion instanceof forwardEventsToOutputFlow.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StateAwareTerminalSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StateAwareTerminalSession.access$forwardEventsToOutputFlow(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = versionedEvents;
                $continuation.label = 1;
                v0 = this.outputFlow.emit((Object)versionedEvents, (Continuation)$continuation);
                ** if (v0 != var12_5) goto lbl19
lbl18:
                // 1 sources

                return var12_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                versionedEvents = (VersionedEvents)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var3_7) {
                    $this$any$iv = versionedEvents.getEvents();
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl47
                    v2 = false;
                    ** GOTO lbl54
lbl47:
                    // 2 sources

                    for (T element$iv : $this$any$iv) {
                        it = (TerminalOutputEvent)element$iv;
                        $i$a$-any-StateAwareTerminalSession$forwardEventsToOutputFlow$2 = false;
                        if (!(it instanceof TerminalSessionTerminatedEvent)) continue;
                        v2 = true;
                        ** GOTO lbl54
                    }
                    v2 = false;
lbl54:
                    // 3 sources

                    if (v2) {
                        CoroutineScopeKt.cancel$default((CoroutineScope)this.getCoroutineScope(), null, (int)1, null);
                    }
                    throw var3_7;
                }
lbl26:
                // 2 sources

                $this$any$iv = versionedEvents.getEvents();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl31
                v1 = false;
                ** GOTO lbl38
lbl31:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TerminalOutputEvent)element$iv;
                    $i$a$-any-StateAwareTerminalSession$forwardEventsToOutputFlow$2 = false;
                    if (!(it instanceof TerminalSessionTerminatedEvent)) continue;
                    v1 = true;
                    ** GOTO lbl38
                }
                v1 = false;
lbl38:
                // 3 sources

                if (v1) {
                    CoroutineScopeKt.cancel$default((CoroutineScope)this.getCoroutineScope(), null, (int)1, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleEvent(TerminalOutputEvent event) {
        TerminalOutputEvent terminalOutputEvent = event;
        if (terminalOutputEvent instanceof TerminalContentUpdatedEvent) {
            Duration latency;
            TerminalOutputModel model = this.getCurrentOutputModel();
            this.updateOutputModelContent(model, (TerminalContentUpdatedEvent)event);
            TimeMark timeMark = ((TerminalContentUpdatedEvent)event).getReadTime();
            Object object = latency = timeMark != null ? Duration.box-impl((long)timeMark.elapsedNow-UwyO8pc()) : null;
            if (latency != null) {
                this.outputLatencyReporter.update(latency);
            }
        } else if (terminalOutputEvent instanceof TerminalCursorPositionChangedEvent) {
            TerminalOutputModel model = this.getCurrentOutputModel();
            model.updateCursorPosition(((TerminalCursorPositionChangedEvent)event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)event).getColumnIndex());
        } else if (terminalOutputEvent instanceof TerminalStateChangedEvent) {
            TerminalState state = TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalStateChangedEvent)event).getState());
            this.sessionModel.updateTerminalState(state);
        } else if (Intrinsics.areEqual((Object)terminalOutputEvent, (Object)TerminalPromptStartedEvent.INSTANCE)) {
            this.blocksModel.promptStarted(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue());
        } else if (Intrinsics.areEqual((Object)terminalOutputEvent, (Object)TerminalPromptFinishedEvent.INSTANCE)) {
            this.blocksModel.promptFinished(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue());
        } else if (terminalOutputEvent instanceof TerminalCommandStartedEvent) {
            this.blocksModel.commandStarted(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue());
        } else if (terminalOutputEvent instanceof TerminalCommandFinishedEvent) {
            this.blocksModel.commandFinished(((TerminalCommandFinishedEvent)event).getExitCode());
        }
    }

    private final VersionedEvents createInitialStateEvents() {
        TerminalInitialStateEvent event = new TerminalInitialStateEvent(TerminalStateDtoKt.toDto((TerminalState)((TerminalState)this.sessionModel.getTerminalState().getValue())), TerminalOutputModelStateDtoKt.toDto((TerminalOutputModelState)this.outputModel.dumpState()), TerminalOutputModelStateDtoKt.toDto((TerminalOutputModelState)this.alternateBufferModel.dumpState()), TerminalBlocksModelStateDtoKt.toDto((TerminalBlocksModelState)this.blocksModel.dumpState()));
        return new VersionedEvents(CollectionsKt.listOf((Object)event), this.modelsVersion);
    }

    private final TerminalOutputModel getCurrentOutputModel() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isAlternateScreenBuffer() ? this.alternateBufferModel : this.outputModel;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOutputModelContent(TerminalOutputModel model, TerminalContentUpdatedEvent event) {
        void $this$mapTo$iv$iv;
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        Iterable $this$map$iv = event.getStyles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRangeDto styleRangeDto = (StyleRangeDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StyleRangeDtoKt.toStyleRange((StyleRangeDto)it));
        }
        List styles = (List)destination$iv$iv;
        model.updateContent(event.getStartLineLogicalIndex(), event.getText(), styles);
        DurationAndTextLength latencyData = new DurationAndTextLength(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime), event.getText().length(), null);
        this.documentUpdateLatencyReporter.update(latencyData);
    }

    private static final Unit outputLatencyReporter$lambda$0(List samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        ReworkedTerminalUsageCollector.INSTANCE.logBackendOutputLatency-WzaCiaA(BatchLatencyReporterKt.totalDuration(samples), ((Duration)BatchLatencyReporterKt.percentile(samples, 90)).unbox-impl(), ((Duration)BatchLatencyReporterKt.thirdLargest(samples)).unbox-impl());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit documentUpdateLatencyReporter$lambda$4(List samples) {
        List $this$thirdLargestOf$iv;
        void p0;
        List $this$percentileOf$iv;
        long l;
        void $this$fold$iv$iv;
        List $this$totalDurationOf$iv;
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        List list = samples;
        ReworkedTerminalUsageCollector reworkedTerminalUsageCollector = ReworkedTerminalUsageCollector.INSTANCE;
        boolean $i$f$totalDurationOf = false;
        Iterable iterable = $this$totalDurationOf$iv;
        long initial$iv$iv = Duration.Companion.getZERO-UwyO8pc();
        boolean $i$f$fold22 = false;
        long accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p02;
            void value$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            long acc$iv = accumulator$iv$iv;
            boolean bl = false;
            DurationAndTextLength durationAndTextLength = (DurationAndTextLength)value$iv;
            l = acc$iv;
            boolean bl2 = false;
            long l2 = p02.getDuration-UwyO8pc();
            accumulator$iv$iv = Duration.plus-LRDsOJo((long)l, (long)l2);
        }
        l = accumulator$iv$iv;
        $this$totalDurationOf$iv = samples;
        int n$iv = 90;
        boolean $i$f$percentileOf = false;
        void $this$sortBy$iv$iv = $this$percentileOf$iv;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc())));
                }
            });
        }
        int index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        DurationAndTextLength $i$f$fold22 = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        boolean bl = false;
        Duration duration = Duration.box-impl((long)p0.getDuration-UwyO8pc());
        $this$percentileOf$iv = samples;
        long l3 = ((Duration)((Comparable)duration)).unbox-impl();
        boolean $i$f$thirdLargestOf = false;
        if (!(!((Collection)$this$thirdLargestOf$iv).isEmpty())) {
            boolean $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = false;
            String $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = "It is expected that array is not empty";
            throw new IllegalStateException($i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22.toString());
        }
        DurationAndTextLength p03 = (DurationAndTextLength)$this$thirdLargestOf$iv.get(0);
        boolean bl3 = false;
        Object max$iv = (Comparable)Duration.box-impl((long)p03.getDuration-UwyO8pc());
        Comparable secondLargest$iv = max$iv;
        Comparable thirdLargest$iv = max$iv;
        for (Object value$iv : $this$thirdLargestOf$iv) {
            DurationAndTextLength p04 = (DurationAndTextLength)value$iv;
            $i$a$-thirdLargestOf-StateAwareTerminalSession$documentUpdateLatencyReporter$1$3 = false;
            Comparable comparableValue$iv = (Comparable)Duration.box-impl((long)p04.getDuration-UwyO8pc());
            if (comparableValue$iv.compareTo(max$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = max$iv;
                max$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(secondLargest$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(thirdLargest$iv) <= 0) continue;
            thirdLargest$iv = comparableValue$iv;
        }
        Comparable comparable = thirdLargest$iv;
        long l4 = ((Duration)comparable).unbox-impl();
        $this$thirdLargestOf$iv = samples;
        n$iv = 90;
        $i$f$percentileOf = false;
        List $this$sortBy$iv$iv2 = $this$percentileOf$iv;
        $i$f$sortBy = false;
        if ($this$sortBy$iv$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(p0.getTextLength());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getTextLength()));
                }
            });
        }
        index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        max$iv = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        long l5 = l4;
        boolean bl4 = false;
        int n = p0.getTextLength();
        reworkedTerminalUsageCollector.logBackendDocumentUpdateLatency-2d-g_3Q(l, l3, l5, n);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableSharedFlow access$getOutputFlow$p(StateAwareTerminalSession $this) {
        return $this.outputFlow;
    }

    public static final /* synthetic */ Mutex access$getModelsLock$p(StateAwareTerminalSession $this) {
        return $this.modelsLock;
    }

    public static final /* synthetic */ VersionedEvents access$createInitialStateEvents(StateAwareTerminalSession $this) {
        return $this.createInitialStateEvents();
    }

    public static final /* synthetic */ Object access$forwardEventsToOutputFlow(StateAwareTerminalSession $this, VersionedEvents versionedEvents, Continuation $completion) {
        return $this.forwardEventsToOutputFlow(versionedEvents, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ BackendTerminalSession access$getDelegate$p(StateAwareTerminalSession $this) {
        return $this.delegate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/backend/StateAwareTerminalSession$Companion;", "", "<init>", "()V", "eventsVersionCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "intellij.terminal.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/backend/StateAwareTerminalSession$VersionedEvents;", "", "events", "", "Lcom/intellij/terminal/session/TerminalOutputEvent;", "version", "", "<init>", "(Ljava/util/List;J)V", "getEvents", "()Ljava/util/List;", "getVersion", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal.backend"})
    private static final class VersionedEvents {
        @NotNull
        private final List<TerminalOutputEvent> events;
        private final long version;

        public VersionedEvents(@NotNull List<? extends TerminalOutputEvent> events, long version) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.events = events;
            this.version = version;
        }

        public /* synthetic */ VersionedEvents(List list, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = eventsVersionCounter.getAndIncrement();
            }
            this(list, l);
        }

        @NotNull
        public final List<TerminalOutputEvent> getEvents() {
            return this.events;
        }

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final List<TerminalOutputEvent> component1() {
            return this.events;
        }

        public final long component2() {
            return this.version;
        }

        @NotNull
        public final VersionedEvents copy(@NotNull List<? extends TerminalOutputEvent> events, long version) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new VersionedEvents(events, version);
        }

        public static /* synthetic */ VersionedEvents copy$default(VersionedEvents versionedEvents, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = versionedEvents.events;
            }
            if ((n & 2) != 0) {
                l = versionedEvents.version;
            }
            return versionedEvents.copy(list, l);
        }

        @NotNull
        public String toString() {
            return "VersionedEvents(events=" + this.events + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.events).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.version);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionedEvents)) {
                return false;
            }
            VersionedEvents versionedEvents = (VersionedEvents)other;
            if (!Intrinsics.areEqual(this.events, versionedEvents.events)) {
                return false;
            }
            return this.version == versionedEvents.version;
        }
    }
}

