/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.CssSelectorCreator;
import com.jetbrains.liveEdit.PageReloader;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.PsiUtil;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlSynchronizer
extends PsiSynchronizer {
    private static final Logger LOG = Logger.getInstance(HtmlSynchronizer.class);
    static final Key<ElementState> ELEMENT_STATE_KEY = Key.create((String)"le_isNew");
    private final ApplicationInspector dom;
    private final List<Change> changes = new ArrayList<Change>();
    private final Set<PsiFile> changedFiles = CollectionFactory.createSmallMemoryFootprintSet();
    private final ElementHighlighter elementHighlighter;

    public HtmlSynchronizer() {
        this.dom = ApplicationInspector.getInstance();
        this.elementHighlighter = ElementHighlighter.getInstance();
    }

    @Override
    public boolean canHandle(@NotNull FileType fileType, @NotNull Project project) {
        if (fileType == null) {
            HtmlSynchronizer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            HtmlSynchronizer.$$$reportNull$$$0(1);
        }
        return fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    @Override
    public boolean schedule(int changeType, @NotNull PsiElement child, @NotNull PsiElement parent, @NotNull PsiFile file) {
        XmlAttribute changedAttribute;
        XmlTag changedTag;
        if (child == null) {
            HtmlSynchronizer.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            HtmlSynchronizer.$$$reportNull$$$0(3);
        }
        if (file == null) {
            HtmlSynchronizer.$$$reportNull$$$0(4);
        }
        PsiElement changedParent = (PsiElement)ObjectUtils.notNull((Object)InjectedLanguageManager.getInstance((Project)parent.getProject()).getInjectionHost(parent), (Object)parent);
        while (true) {
            if (changedParent instanceof XmlTag) {
                if (child instanceof PsiWhiteSpace || PsiUtilCore.hasErrorElementChild((PsiElement)changedParent)) {
                    return false;
                }
                switch (changeType) {
                    case 0: {
                        if (!(child instanceof XmlAttribute)) break;
                        XmlAttribute attribute = (XmlAttribute)child;
                        ELEMENT_STATE_KEY.set((UserDataHolder)attribute, (Object)ElementState.NEW);
                        XmlAttributeValue valueElement = attribute.getValueElement();
                        if (valueElement != null && valueElement.getTextLength() != 0 && !PsiUtilCore.hasErrorElementChild((PsiElement)valueElement)) break;
                        return false;
                    }
                    case 2: {
                        if (!PsiUtilCore.hasErrorElementChild((PsiElement)child)) break;
                        if (child instanceof XmlTag && !HtmlSynchronizer.reloadPageIfNeeded((XmlTag)child, true)) {
                            ELEMENT_STATE_KEY.set((UserDataHolder)child, (Object)ElementState.NEW);
                        }
                        return false;
                    }
                    case 3: {
                        if (!PsiUtilCore.hasErrorElementChild((PsiElement)child)) break;
                        return false;
                    }
                }
                changedTag = (XmlTag)changedParent;
                changedAttribute = null;
                break;
            }
            if (changedParent instanceof XmlText) {
                changedTag = ((XmlText)changedParent).getParentTag();
                changedAttribute = null;
                break;
            }
            if (changedParent instanceof XmlAttribute) {
                changedAttribute = (XmlAttribute)changedParent;
                if (ArrayUtil.contains((String)changedAttribute.getName(), (String[])CssSelectorCreator.REF_ATTRIBUTES)) {
                    ELEMENT_STATE_KEY.set((UserDataHolder)changedAttribute, (Object)ElementState.MODIFIED);
                }
                changedTag = changedAttribute.getParent();
                break;
            }
            if (changedParent instanceof XmlComment) {
                return false;
            }
            if (changedParent instanceof JSEmbeddedContent) {
                PsiElement grandParent = changedParent.getParent();
                if (grandParent instanceof XmlTag) {
                    changedTag = (XmlTag)grandParent;
                    changedAttribute = null;
                    break;
                }
                if (grandParent instanceof XmlDocument) {
                    changedTag = ((XmlDocument)grandParent).getRootTag();
                    if (changedTag == null) {
                        return false;
                    }
                    changedAttribute = null;
                    break;
                }
                if (grandParent != null && grandParent.getParent() instanceof XmlAttribute) {
                    changedAttribute = (XmlAttribute)grandParent.getParent();
                    assert (changedAttribute != null);
                    changedTag = changedAttribute.getParent();
                    LOG.assertTrue(changedTag != null);
                    break;
                }
                changedParent = changedParent.getParent();
                continue;
            }
            if (changedParent instanceof PsiFile || changedParent == null) {
                if (parent instanceof XmlDocument) {
                    changedTag = ((XmlDocument)parent).getRootTag();
                    if (child instanceof XmlToken && ((XmlToken)child).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                        if (changedTag == null) {
                            return this.changedFiles.add(file);
                        }
                        return false;
                    }
                    if (changedTag == null) {
                        return false;
                    }
                    changedAttribute = null;
                    break;
                }
                LOG.warn("unsupported parent " + String.valueOf(changedParent));
                return false;
            }
            changedParent = changedParent.getParent();
        }
        if (changedTag == null || PsiUtilCore.hasErrorElementChild((PsiElement)changedTag)) {
            return false;
        }
        this.mergeOrAddChangeSet(changedTag, changedAttribute, changedParent);
        return true;
    }

    private boolean mergeOrAddChangeSet(@NotNull XmlTag changedTag, @Nullable XmlAttribute changedAttribute, PsiElement changedParent) {
        if (changedTag == null) {
            HtmlSynchronizer.$$$reportNull$$$0(5);
        }
        if (!HtmlSynchronizer.isElementNotChanged((XmlElement)changedTag)) {
            HtmlSynchronizer.clearElementState((XmlElement)changedTag);
            XmlTag parentTag = changedTag.getParentTag();
            if (parentTag != null) {
                changedTag = parentTag;
            }
        }
        int oldSize = this.changes.size();
        for (int i = 0; i < oldSize; ++i) {
            Change set = this.changes.get(i);
            if (set == null) continue;
            if (set.tag == changedTag) {
                if (set.attribute == null) {
                    return false;
                }
                if (changedAttribute == null) {
                    set.attribute = null;
                    this.removeIfChildOrAttributeOnly(changedTag, i, oldSize);
                    return false;
                }
                if (!changedAttribute.equals(set.attribute)) {
                    this.changes.add(new Change(changedTag, changedAttribute));
                }
                return true;
            }
            if (set.attribute == null && PsiTreeUtil.isAncestor((PsiElement)set.tag, (PsiElement)changedParent, (boolean)true)) {
                return false;
            }
            if (changedAttribute != null || !PsiTreeUtil.isAncestor((PsiElement)changedTag, (PsiElement)set.tag, (boolean)true)) continue;
            set.tag = changedTag;
            set.attribute = null;
            this.removeIfChildOrAttributeOnly(changedTag, i, oldSize);
            return false;
        }
        this.changes.add(new Change(changedTag, changedAttribute));
        return true;
    }

    private void removeIfChildOrAttributeOnly(XmlTag changedTag, int min, int max) {
        for (int i = max - 1; i > min; --i) {
            Change set = this.changes.get(i);
            if (!PsiTreeUtil.isAncestor((PsiElement)changedTag, (PsiElement)set.tag, (boolean)false)) continue;
            this.changes.set(i, null);
        }
    }

    @Override
    @Nullable
    public Supplier<Set<PsiElement>> flushSyncTask() {
        PsiFile[] files;
        Change[] sets;
        if (this.changes.isEmpty() && this.changedFiles.isEmpty()) {
            return null;
        }
        if (this.changes.isEmpty()) {
            sets = null;
        } else {
            sets = this.changes.toArray(new Change[0]);
            this.changes.clear();
        }
        if (sets != null && !this.changedFiles.isEmpty()) {
            int length = sets.length;
            for (int i = 0; i < length; ++i) {
                Change set = sets[i];
                if (!this.changedFiles.contains(set.tag.getContainingFile())) continue;
                sets[i] = null;
            }
        }
        if (this.changedFiles.isEmpty()) {
            files = null;
        } else {
            files = this.changedFiles.toArray(PsiFile.EMPTY_ARRAY);
            this.changedFiles.clear();
        }
        return () -> {
            HashSet<XmlTag> result = new HashSet<XmlTag>();
            if (sets != null) {
                for (Change change : sets) {
                    if (change == null) continue;
                    this.sync(change.tag, change.attribute);
                    result.add(change.tag);
                }
            }
            if (files != null) {
                for (Change change : files) {
                    if (!(change instanceof XmlFile)) continue;
                    HtmlSynchronizer.reloadPage((XmlFile)change, true);
                }
                ContainerUtil.addAll(result, (Object[])files);
            }
            return result;
        };
    }

    private void sync(@NotNull XmlTag tag, @Nullable XmlAttribute attribute) {
        if (tag == null) {
            HtmlSynchronizer.$$$reportNull$$$0(6);
        }
        CssSelectorCreator[] selectorCreator = new CssSelectorCreator[1];
        CharSequence[] value = new CharSequence[1];
        String[] name = new String[1];
        ReadAction.run(() -> {
            if (!tag.isValid()) {
                return;
            }
            if (tag.getName().equalsIgnoreCase("title")) {
                selectorCreator[0] = CssSelectorCreator.createForTitle();
                value[0] = tag.getValue().getText();
                name[0] = "title";
            } else {
                if (HtmlSynchronizer.reloadPageIfNeeded(tag, false)) {
                    return;
                }
                if (attribute == null) {
                    selectorCreator[0] = new CssSelectorCreator().create(tag);
                    value[0] = HtmlSynchronizer.getOuterHtml((PsiElement)tag);
                    name[0] = null;
                } else {
                    if (PsiTreeUtil.hasErrorElements((PsiElement)attribute)) {
                        return;
                    }
                    value[0] = attribute.getDisplayValue();
                    if (value[0] == null) {
                        return;
                    }
                    selectorCreator[0] = new CssSelectorCreator().create(attribute, tag);
                    name[0] = attribute.getName();
                }
            }
        });
        if (value[0] == null) {
            return;
        }
        if (!"title".equals(name[0])) {
            this.elementHighlighter.hideAndIgnoreHighlightUntilElementChanged();
        }
        if (name[0] == null) {
            ApplicationInspector.getInstance().setOuterHtml(tag.getProject(), selectorCreator[0].getSelector(), selectorCreator[0].selectorSubject(), value[0]);
        } else {
            this.setProperty(tag.getProject(), selectorCreator[0], name[0], value[0], false);
        }
    }

    private void setProperty(Project project, CssSelectorCreator selectorCreator, CharSequence name, CharSequence value, boolean isStyle) {
        this.dom.setProperty(project, selectorCreator.getSelector(), selectorCreator.selectorSubject(), name, value, isStyle);
    }

    @NotNull
    private static CharSequence getOuterHtml(PsiElement element) {
        CharSequence charSequence = new AstBufferUtil.BufferVisitor(element, false, true){

            private void getChars(String s) {
                assert (this.buffer != null);
                CharArrayUtil.getChars((CharSequence)s, (char[])this.buffer, (int)this.end);
                this.end += s.length();
            }

            private void appendAttributeDelimiter(@Nullable ASTNode type) {
                if (type != null) {
                    assert (this.buffer != null);
                    this.buffer[this.end] = type.getChars().charAt(0);
                    ++this.end;
                }
            }

            public void visitComposite(CompositeElement composite) {
                if (!(composite instanceof XmlAttribute)) {
                    if (!(composite instanceof XmlTag) || !PsiUtilCore.hasErrorElementChild((PsiElement)((XmlTag)composite))) {
                        super.visitComposite(composite);
                    }
                    return;
                }
                XmlAttribute attribute = (XmlAttribute)composite;
                XmlAttributeValue valueElement = attribute.getValueElement();
                if (valueElement != null && !PsiUtilCore.hasErrorElementChild((PsiElement)valueElement) && valueElement.getTextLength() > 0) {
                    this.getChars(attribute.getName());
                    ASTNode type = valueElement.getNode().findChildByType(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER);
                    assert (this.buffer != null);
                    this.buffer[this.end] = 61;
                    ++this.end;
                    this.appendAttributeDelimiter(type);
                    this.getChars(attribute.getDisplayValue());
                    this.appendAttributeDelimiter(type);
                    HtmlSynchronizer.clearElementState((XmlElement)attribute);
                }
            }
        }.createCharSequence();
        if (charSequence == null) {
            HtmlSynchronizer.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    static boolean isElementNotChanged(XmlElement element) {
        return element.getUserData(ELEMENT_STATE_KEY) == null;
    }

    static void clearElementState(XmlElement element) {
        element.putUserData(ELEMENT_STATE_KEY, null);
    }

    private static boolean reloadPageIfNeeded(XmlTag tag, boolean dryRun) {
        if (tag.getName().equals("body")) {
            if (!dryRun && !PsiTreeUtil.hasErrorElements((PsiElement)tag)) {
                AppUIUtil.invokeOnEdt((Runnable)PageReloader.createReloadBelongsToProject((PsiElement)tag, false));
            }
        } else if (PsiUtil.isTagHeadRole(tag)) {
            if (!dryRun && !PsiTreeUtil.hasErrorElements((PsiElement)tag)) {
                HtmlSynchronizer.reloadPage((XmlFile)tag.getContainingFile(), false);
            }
        } else {
            return false;
        }
        return true;
    }

    private static void reloadPage(@NotNull XmlFile file, boolean upload) {
        if (file == null) {
            HtmlSynchronizer.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            XmlTag rootTag = file.getRootTag();
            XmlTag selectorTag = null;
            if (rootTag != null) {
                XmlTag bodyTag = rootTag.findFirstSubTag("body");
                if (bodyTag == null) {
                    for (XmlTag tag : rootTag.getSubTags()) {
                        if (PsiUtil.isTagHeadRole(tag)) continue;
                        selectorTag = tag;
                        break;
                    }
                } else {
                    XmlTag[] tags = bodyTag.getSubTags();
                    if (tags.length > 0) {
                        selectorTag = tags[0];
                    }
                }
            }
            Runnable runnable = selectorTag == null ? PageReloader.createReloadBelongsToProject((PsiElement)file, upload) : PageReloader.createReloadBelongsToProject(selectorTag, new CssSelectorCreator().create(selectorTag).getSelector(), upload);
            AppUIUtil.invokeOnEdt((Runnable)runnable);
        });
    }

    @Override
    public void reload(@NotNull VirtualFile file, @NotNull Project project) {
        PsiFile psiFile;
        if (file == null) {
            HtmlSynchronizer.$$$reportNull$$$0(9);
        }
        if (project == null) {
            HtmlSynchronizer.$$$reportNull$$$0(10);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile) {
            HtmlSynchronizer.reloadPage((XmlFile)psiFile, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedTag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/HtmlSynchronizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/HtmlSynchronizer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHandle";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeOrAddChangeSet";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reloadPage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    static enum ElementState {
        NEW,
        MODIFIED;

    }

    private static final class Change {
        @NotNull
        XmlTag tag;
        @Nullable
        XmlAttribute attribute;

        Change(@NotNull XmlTag tag, @Nullable XmlAttribute attribute) {
            if (tag == null) {
                Change.$$$reportNull$$$0(0);
            }
            this.attribute = attribute;
            this.tag = tag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/liveEdit/HtmlSynchronizer$Change", "<init>"));
        }
    }
}

