/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.Deployer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PageReloader {
    @NotNull
    public static Runnable createReloadBelongsToProject(@NotNull PsiElement element, boolean triggeredByExplicitAction) {
        if (element == null) {
            PageReloader.$$$reportNull$$$0(0);
        }
        return PageReloader.createReloadBelongsToProject(element, null, triggeredByExplicitAction);
    }

    @NotNull
    public static Runnable createReloadBelongsToProject(@NotNull PsiElement element, @Nullable String selector, boolean triggeredByExplicitAction) {
        if (element == null) {
            PageReloader.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        return PageReloader.createSaveTask(element.getContainingFile().getViewProvider().getVirtualFile(), project, PageReloader.domTask(project, selector), triggeredByExplicitAction);
    }

    public static void save(List<PsiFile> files, Condition<List<PsiFile>> actualizer, Runnable callback) {
        PageReloader.saveFiles(files, callback, false, actualizer);
    }

    private static Runnable domTask(@NotNull Project project, @Nullable String selector) {
        if (project == null) {
            PageReloader.$$$reportNull$$$0(2);
        }
        return () -> {
            ApplicationInspector applicationInspector = ApplicationInspector.getInstance();
            if (selector == null) {
                applicationInspector.reloadPages(project);
            } else {
                applicationInspector.reloadPagesContainingElement(project, selector);
            }
        };
    }

    public static void reloadBelongsTo(@NotNull VirtualFile file, @NotNull Project project, boolean triggeredByExplicitAction) {
        if (file == null) {
            PageReloader.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PageReloader.$$$reportNull$$$0(4);
        }
        PageReloader.save(file, project, PageReloader.domTask(project, null), triggeredByExplicitAction);
    }

    public static void save(@NotNull VirtualFile file, @NotNull Project project, @NotNull Runnable callback, boolean triggeredByExplicitAction) {
        if (file == null) {
            PageReloader.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PageReloader.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            PageReloader.$$$reportNull$$$0(7);
        }
        AppUIUtil.invokeOnEdt((Runnable)PageReloader.createSaveTask(file, project, callback, triggeredByExplicitAction));
    }

    @NotNull
    private static Runnable createSaveTask(@NotNull VirtualFile file, @NotNull Project project, @NotNull Runnable callback, boolean triggeredByExplicitAction) {
        if (file == null) {
            PageReloader.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PageReloader.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            PageReloader.$$$reportNull$$$0(10);
        }
        Runnable runnable = () -> {
            if (project.isDisposed()) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Deployer deployer = Deployer.getInstance();
            if (deployer == null) {
                callback.run();
            } else {
                deployer.deploy(file, project, triggeredByExplicitAction).onSuccess(it -> callback.run());
            }
        };
        if (runnable == null) {
            PageReloader.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    private static void saveFiles(List<PsiFile> files, Runnable callback, boolean triggeredByExplicitAction, Condition<List<PsiFile>> actualizer) {
        AppUIUtil.invokeOnEdt(() -> {
            if (!actualizer.value((Object)files)) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Deployer deployer = Deployer.getInstance();
            if (deployer == null) {
                callback.run();
                return;
            }
            ActionCallback actionCallback = new ActionCallback(files.size());
            actionCallback.doWhenDone(callback);
            Runnable onUpdateFinished = actionCallback.createSetDoneRunnable();
            for (PsiFile file : files) {
                if (!file.isValid() || file.getProject().isDisposed()) {
                    actionCallback.setDone();
                    continue;
                }
                deployer.deploy(file, triggeredByExplicitAction).onSuccess(it -> onUpdateFinished.run());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/PageReloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/PageReloader";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSaveTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReloadBelongsToProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "domTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reloadBelongsTo";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSaveTask";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

