/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.google.common.base.CharMatcher;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.impl.StructureViewSelectInTarget;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RunnerContentProvider;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Url;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.WipDocumentModelManager;
import com.jetbrains.liveEdit.elementsInspector.ElementsView;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewKt;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewState;
import com.jetbrains.liveEdit.elementsInspector.InspectorElementHighlightExecutor;
import com.jetbrains.liveEdit.elementsInspector.InspectorFileReferenceHelper;
import com.jetbrains.liveEdit.elementsInspector.InspectorStructureViewWrapper;
import com.jetbrains.liveEdit.elementsInspector.UpdateQueue;
import com.jetbrains.liveEdit.highlighting.ElementHighlightExecutor;
import com.jetbrains.liveEdit.highlighting.ElementHighlighterOnCaretChangeBase;
import com.jetbrains.liveEdit.highlighting.LiveEditElementPreviewProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.NodeIdentifiable;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.dom.AttributeModifiedEventData;
import org.jetbrains.wip.protocol.dom.AttributeRemovedEventData;
import org.jetbrains.wip.protocol.dom.CharacterDataModifiedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeCountUpdatedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeInsertedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeRemovedEventData;
import org.jetbrains.wip.protocol.dom.DOMKt;
import org.jetbrains.wip.protocol.dom.DocumentUpdatedEventData;
import org.jetbrains.wip.protocol.dom.GetDocumentResult;
import org.jetbrains.wip.protocol.dom.InlineStyleInvalidatedEventData;
import org.jetbrains.wip.protocol.dom.NodeValue;
import org.jetbrains.wip.protocol.dom.RequestNodeResult;
import org.jetbrains.wip.protocol.dom.SetChildNodesEventData;
import org.jetbrains.wip.protocol.overlay.OverlayKt;
import org.jetbrains.wip.protocol.page.DomContentEventFiredEventData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002]^B)\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u00109\u001a\u00020:H\u0002J\u0016\u0010;\u001a\u00020:2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u0006\u0010?\u001a\u00020:J\u0010\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u00020BH\u0002J=\u0010C\u001a\u00020:2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\n\u0010G\u001a\u00060Hj\u0002`I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u0010M\u001a\u00020BH\u0000\u00a2\u0006\u0002\bNJ2\u0010O\u001a\u00020:2\n\u0010G\u001a\u00060Hj\u0002`I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u0010P\u001a\u00020F2\u0006\u0010Q\u001a\u00020RH\u0002J\u0015\u0010S\u001a\u00020:2\u0006\u0010T\u001a\u00020(H\u0000\u00a2\u0006\u0002\bUJ\u001e\u0010V\u001a\u00020:2\u0006\u0010W\u001a\u00020X2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KH\u0002J\u0010\u0010Y\u001a\u00020:2\u0006\u0010\u0019\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020:H\u0016J\b\u0010\\\u001a\u00020:H\u0002R\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;", "Lcom/intellij/openapi/Disposable;", "connection", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "project", "Lcom/intellij/openapi/project/Project;", "finder", "Lcom/intellij/javascript/debugger/JSCachingFileFinder;", "<init>", "(Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/JSCachingFileFinder;)V", "getConnection$intellij_js_liveEdit", "()Lorg/jetbrains/debugger/connection/VmConnection;", "setConnection$intellij_js_liveEdit", "(Lorg/jetbrains/debugger/connection/VmConnection;)V", "getProject$intellij_js_liveEdit", "()Lcom/intellij/openapi/project/Project;", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "getCommandProcessor$intellij_js_liveEdit", "()Lorg/jetbrains/wip/WipCommandProcessor;", "setCommandProcessor$intellij_js_liveEdit", "(Lorg/jetbrains/wip/WipCommandProcessor;)V", "editorWrapper", "Ljavax/swing/JPanel;", "highlightExecutor", "Lcom/jetbrains/liveEdit/highlighting/ElementHighlightExecutor;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getTextEditor$intellij_js_liveEdit", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "setTextEditor$intellij_js_liveEdit", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "state", "Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;", "getState$intellij_js_liveEdit", "()Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;", "setState$intellij_js_liveEdit", "(Lcom/jetbrains/liveEdit/elementsInspector/ElementsViewState;)V", "newId", "", "documentId", "getDocumentId$intellij_js_liveEdit", "()I", "setDocumentId$intellij_js_liveEdit", "(I)V", "documentModel", "Lcom/jetbrains/liveEdit/WipDocumentModelManager;", "getDocumentModel", "()Lcom/jetbrains/liveEdit/WipDocumentModelManager;", "updateQueue", "Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;", "documentInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "panelShown", "inspectorStructureViewWrapper", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorStructureViewWrapper;", "initAndLoadDocument", "", "addDomChangeListeners", "map", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "reloadDocument", "loadDocument", "isAfterUpdate", "", "buildStringRepresentation", "nodes", "", "Lorg/jetbrains/wip/protocol/dom/NodeValue;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nodeIdToOffset", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/openapi/util/Segment;", "newLineBeforeTag", "buildStringRepresentation$intellij_js_liveEdit", "buildTag", "node", "nodeName", "", "requestChildNodes", "id", "requestChildNodes$intellij_js_liveEdit", "createEditor", "charSequence", "", "addElementHighlighter", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "dispose", "clearQueueAndState", "ElementsRunnerContentProvider", "ActualDomElementHighlighterOnCaretChange", "intellij.js.liveEdit"})
@SourceDebugExtension(value={"SMAP\nElementsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsView.kt\ncom/jetbrains/liveEdit/elementsInspector/ElementsView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,474:1\n1#2:475\n14#3:476\n*S KotlinDebug\n*F\n+ 1 ElementsView.kt\ncom/jetbrains/liveEdit/elementsInspector/ElementsView\n*L\n378#1:476\n*E\n"})
public final class ElementsView
implements Disposable {
    @Nullable
    private volatile VmConnection<Vm> connection;
    @NotNull
    private final Project project;
    @Nullable
    private JSCachingFileFinder finder;
    @Nullable
    private WipCommandProcessor commandProcessor;
    @NotNull
    private final JPanel editorWrapper;
    @Nullable
    private ElementHighlightExecutor highlightExecutor;
    @Nullable
    private volatile TextEditor textEditor;
    @Nullable
    private volatile ElementsViewState state;
    @NotNull
    private final UpdateQueue updateQueue;
    @NotNull
    private final AtomicBoolean documentInitialized;
    @NotNull
    private final AtomicBoolean panelShown;
    @NotNull
    private final InspectorStructureViewWrapper inspectorStructureViewWrapper;

    public ElementsView(@Nullable VmConnection<Vm> connection, @NotNull Project project, @Nullable JSCachingFileFinder finder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.connection = connection;
        this.project = project;
        this.finder = finder;
        this.editorWrapper = new JPanel(new BorderLayout());
        this.documentInitialized = new AtomicBoolean();
        this.panelShown = new AtomicBoolean();
        VmConnection<Vm> vmConnection = this.connection;
        Intrinsics.checkNotNull(vmConnection);
        vmConnection.executeOnStart(ElementsView::_init_$lambda$1);
        VmConnection<Vm> vmConnection2 = this.connection;
        Intrinsics.checkNotNull(vmConnection2);
        vmConnection2.stateChanged(arg_0 -> ElementsView._init_$lambda$3(this, arg_0));
        VmConnection<Vm> vmConnection3 = this.connection;
        Intrinsics.checkNotNull(vmConnection3);
        if (vmConnection3.getState().getStatus() == ConnectionStatus.CONNECTED) {
            VmConnection<Vm> vmConnection4 = this.connection;
            Intrinsics.checkNotNull(vmConnection4);
            Vm vm = vmConnection4.getVm();
            Intrinsics.checkNotNull((Object)vm, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipVm");
            this.commandProcessor = ((WipVm)vm).getCommandProcessor();
        }
        this.editorWrapper.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ConnectionState connectionState = this.getConnection$intellij_js_liveEdit();
                if ((connectionState != null && (connectionState = connectionState.getState()) != null ? connectionState.getStatus() : null) == ConnectionStatus.CONNECTED && panelShown.compareAndSet(false, true)) {
                    editorWrapper.removeAncestorListener((AncestorListener)((Object)this));
                    this.initAndLoadDocument();
                }
            }
        });
        this.inspectorStructureViewWrapper = new InspectorStructureViewWrapper(this);
        this.updateQueue = new UpdateQueue(this);
    }

    @Nullable
    public final VmConnection<Vm> getConnection$intellij_js_liveEdit() {
        return this.connection;
    }

    public final void setConnection$intellij_js_liveEdit(@Nullable VmConnection<Vm> vmConnection) {
        this.connection = vmConnection;
    }

    @NotNull
    public final Project getProject$intellij_js_liveEdit() {
        return this.project;
    }

    @Nullable
    public final WipCommandProcessor getCommandProcessor$intellij_js_liveEdit() {
        return this.commandProcessor;
    }

    public final void setCommandProcessor$intellij_js_liveEdit(@Nullable WipCommandProcessor wipCommandProcessor) {
        this.commandProcessor = wipCommandProcessor;
    }

    @Nullable
    public final TextEditor getTextEditor$intellij_js_liveEdit() {
        return this.textEditor;
    }

    public final void setTextEditor$intellij_js_liveEdit(@Nullable TextEditor textEditor) {
        this.textEditor = textEditor;
    }

    @Nullable
    public final ElementsViewState getState$intellij_js_liveEdit() {
        return this.state;
    }

    public final void setState$intellij_js_liveEdit(@Nullable ElementsViewState elementsViewState) {
        this.state = elementsViewState;
    }

    public final int getDocumentId$intellij_js_liveEdit() {
        WipDocumentModelManager wipDocumentModelManager = this.getDocumentModel();
        return wipDocumentModelManager != null ? wipDocumentModelManager.getDocumentId() : -1;
    }

    public final void setDocumentId$intellij_js_liveEdit(int newId) {
        block0: {
            WipDocumentModelManager wipDocumentModelManager = this.getDocumentModel();
            if (wipDocumentModelManager == null) break block0;
            wipDocumentModelManager.setDocumentId(newId);
        }
    }

    private final WipDocumentModelManager getDocumentModel() {
        WipDocumentModelManager wipDocumentModelManager;
        Vm vm = this.connection;
        if (vm != null && (vm = vm.getVm()) != null) {
            Vm it = vm;
            boolean bl = false;
            wipDocumentModelManager = WipDocumentModelManager.Companion.getForVm((WipVm)it);
        } else {
            wipDocumentModelManager = null;
        }
        return wipDocumentModelManager;
    }

    private final void initAndLoadDocument() {
        if (this.panelShown.get() && this.documentInitialized.compareAndSet(false, true)) {
            WipCommandProcessor wipCommandProcessor = this.commandProcessor;
            Intrinsics.checkNotNull((Object)wipCommandProcessor);
            this.addDomChangeListeners((EventMap<ProtocolResponseReader>)wipCommandProcessor.getEventMap());
            this.loadDocument(false);
        }
    }

    private final void addDomChangeListeners(EventMap<ProtocolResponseReader> map) {
        map.add((EventType)DocumentUpdatedEventData.TYPE, arg_0 -> ElementsView.addDomChangeListeners$lambda$4(this, arg_0));
        EventType[] eventTypeArray = new EventType[]{AttributeModifiedEventData.TYPE, AttributeRemovedEventData.TYPE, CharacterDataModifiedEventData.TYPE, ChildNodeRemovedEventData.TYPE, ChildNodeCountUpdatedEventData.TYPE};
        map.addMulti(eventTypeArray, arg_0 -> ElementsView.addDomChangeListeners$lambda$5(this, arg_0));
        map.add((EventType)ChildNodeInsertedEventData.TYPE, arg_0 -> ElementsView.addDomChangeListeners$lambda$6(this, arg_0));
        map.add((EventType)InlineStyleInvalidatedEventData.TYPE, arg_0 -> ElementsView.addDomChangeListeners$lambda$7(this, arg_0));
        map.add((EventType)SetChildNodesEventData.TYPE, arg_0 -> ElementsView.addDomChangeListeners$lambda$8(this, arg_0));
    }

    public final void reloadDocument() {
        this.clearQueueAndState();
        this.loadDocument(true);
    }

    private final void loadDocument(boolean isAfterUpdate) {
        block0: {
            CompletableFuture<GetDocumentResult> completableFuture;
            WipDocumentModelManager wipDocumentModelManager = this.getDocumentModel();
            if (wipDocumentModelManager == null || (completableFuture = wipDocumentModelManager.loadDocument(isAfterUpdate)) == null) break block0;
            completableFuture.thenAccept(arg_0 -> ElementsView.loadDocument$lambda$10(arg_0 -> ElementsView.loadDocument$lambda$9(this, arg_0), arg_0));
        }
    }

    public final void buildStringRepresentation$intellij_js_liveEdit(@NotNull List<? extends NodeValue> nodes, @NotNull StringBuilder builder, @NotNull Int2ObjectMap<Segment> nodeIdToOffset, boolean newLineBeforeTag) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(nodeIdToOffset, (String)"nodeIdToOffset");
        boolean newLineBeforeTag2 = newLineBeforeTag;
        for (NodeValue nodeValue : nodes) {
            Object object;
            short s;
            String nodeName = nodeValue.nodeName();
            if (!StringUtil.isEmpty((String)nodeName)) {
                String string = nodeName;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                nodeName = string2;
            }
            if ((s = (short)nodeValue.getNodeType()) == 1) {
                if (newLineBeforeTag2) {
                    if (!HtmlUtil.isPossiblyInlineTag((String)nodeName)) {
                        builder.append('\n');
                    }
                } else {
                    newLineBeforeTag2 = true;
                }
                this.buildTag(builder, nodeIdToOffset, nodeValue, nodeName);
                object = Unit.INSTANCE;
                continue;
            }
            if (s == 3) {
                int start = builder.length();
                ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                object = nodeIdToOffset.put(nodeValue.getNodeId(), (Object)new TextRange(start, builder.length()));
                continue;
            }
            if (s == 2) {
                builder.append(' ');
                builder.append(nodeValue.getName());
                ElementsViewKt.appendAttributeValue(nodeValue.getValue(), builder);
                object = Unit.INSTANCE;
                continue;
            }
            if (s == 8) {
                if (newLineBeforeTag2) {
                    builder.append('\n');
                } else {
                    newLineBeforeTag2 = true;
                }
                builder.append("<!--");
                ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                object = builder.append("-->");
                continue;
            }
            if (s == 10) {
                builder.append("<!DOCTYPE ").append(nodeName);
                if (!StringUtil.isEmpty((String)nodeValue.getPublicId())) {
                    builder.append(" PUBLIC \"").append(nodeValue.getPublicId()).append('\"');
                    if (nodeValue.getSystemId() != null) {
                        builder.append(' ').append('\"').append(nodeValue.getSystemId()).append('\"');
                    }
                } else if (!StringUtil.isEmpty((String)nodeValue.getSystemId())) {
                    builder.append(" SYSTEM \"").append(nodeValue.getPublicId()).append('\"');
                }
                if (!StringUtil.isEmpty((String)nodeValue.getInternalSubset())) {
                    builder.append(' ').append('[').append(nodeValue.getInternalSubset()).append(']');
                }
                object = builder.append('>');
                continue;
            }
            if (s == 4) {
                builder.append("<![CDATA[");
                ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                object = builder.append("]]>");
                continue;
            }
            object = builder.append(CharMatcher.whitespace().collapseFrom((CharSequence)nodeName, ' '));
        }
    }

    private final void buildTag(StringBuilder builder, Int2ObjectMap<Segment> nodeIdToOffset, NodeValue node, String nodeName) {
        boolean hasAttributes;
        builder.append('<').append(nodeName);
        List attributes = node.getAttributes();
        Collection collection = attributes;
        boolean bl = hasAttributes = !(collection == null || collection.isEmpty());
        if (hasAttributes) {
            int i = 0;
            while (i < attributes.size()) {
                String name = (String)attributes.get(i);
                String value = StringUtil.nullize((String)((String)attributes.get(i + 1)));
                if (value == null && Intrinsics.areEqual((Object)"style", (Object)name)) {
                    i += 2;
                    continue;
                }
                builder.append(' ');
                builder.append(name);
                ElementsViewKt.appendAttributeValue(value, builder);
                i += 2;
            }
        }
        int start = builder.length();
        if (HtmlUtil.isSingleHtmlTag((String)nodeName, (boolean)false)) {
            builder.append('/').append('>');
            nodeIdToOffset.put(node.getNodeId(), (Object)new TextRange(start, builder.length()));
            return;
        }
        builder.append('>');
        if (node.getChildren() == null) {
            this.requestChildNodes$intellij_js_liveEdit(node.getNodeId());
        } else {
            List list = node.getChildren();
            Intrinsics.checkNotNull((Object)list);
            if (!list.isEmpty()) {
                List list2 = node.getChildren();
                Intrinsics.checkNotNull((Object)list2);
                this.buildStringRepresentation$intellij_js_liveEdit(list2, builder, nodeIdToOffset, true);
            }
        }
        builder.append('<').append('/').append(nodeName).append('>');
        nodeIdToOffset.put(node.getNodeId(), (Object)new TextRange(start, builder.length()));
    }

    public final void requestChildNodes$intellij_js_liveEdit(int id) {
        WipCommandProcessor wipCommandProcessor = this.commandProcessor;
        Intrinsics.checkNotNull((Object)wipCommandProcessor);
        wipCommandProcessor.send((Request)DOMKt.RequestChildNodes$default((int)id, (Integer)-1, null, (int)4, null));
    }

    private final void createEditor(CharSequence charSequence, Int2ObjectMap<Segment> nodeIdToOffset) {
        VirtualFile realFile;
        Url currentUrl;
        Vm vm;
        ElementsViewState state;
        this.state = state = new ElementsViewState(charSequence, this.project);
        XmlFile psiFile = state.getPsiFile$intellij_js_liveEdit();
        LightVirtualFile virtualFile = state.getVirtualFile$intellij_js_liveEdit();
        VmConnection<Vm> vmConnection = this.connection;
        Intrinsics.checkNotNull(vmConnection);
        Vm vm2 = vm = vmConnection.getVm();
        Url url = currentUrl = vm2 == null ? null : ((WipVm)vm2).getCurrentUrl();
        if (currentUrl == null) {
            v3 = null;
        } else {
            JSCachingFileFinder jSCachingFileFinder = this.finder;
            Intrinsics.checkNotNull((Object)jSCachingFileFinder);
            v3 = realFile = JSCachingFileFinder.findFile$default((JSCachingFileFinder)jSCachingFileFinder, (Url)currentUrl, (Project)this.project, (boolean)false, null, null, (int)28, null);
        }
        if (realFile != null) {
            if (psiFile instanceof PsiFileImpl) {
                ApplicationManager.getApplication().runReadAction(() -> ElementsView.createEditor$lambda$11(this, realFile, psiFile));
            }
            InspectorFileReferenceHelper.registerFile((VirtualFile)virtualFile, realFile);
        }
        ApplicationManager.getApplication().runReadAction(() -> ElementsView.createEditor$lambda$12(state, nodeIdToOffset));
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, () -> ElementsView.createEditor$lambda$13(this, virtualFile, psiFile));
    }

    private final void addElementHighlighter(InspectorElementHighlightExecutor highlightExecutor) {
        ActualDomElementHighlighterOnCaretChange listener = new ActualDomElementHighlighterOnCaretChange(highlightExecutor);
        TextEditor textEditor = this.textEditor;
        Intrinsics.checkNotNull((Object)textEditor);
        textEditor.getEditor().getCaretModel().addCaretListener((CaretListener)listener);
        VmConnection<Vm> vmConnection = this.connection;
        Intrinsics.checkNotNull(vmConnection);
        Disposer.register((Disposable)((Disposable)vmConnection), (Disposable)new Disposable(this, listener){
            final /* synthetic */ ElementsView this$0;
            final /* synthetic */ ActualDomElementHighlighterOnCaretChange $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void dispose() {
                if (this.this$0.getTextEditor$intellij_js_liveEdit() != null) {
                    TextEditor textEditor = this.this$0.getTextEditor$intellij_js_liveEdit();
                    Intrinsics.checkNotNull((Object)textEditor);
                    this.$listener.dispose(textEditor.getEditor());
                }
            }
        });
    }

    public void dispose() {
        this.clearQueueAndState();
        TextEditor editor = this.textEditor;
        if (editor != null) {
            this.textEditor = null;
            ElementsViewState elementsViewState = this.state;
            Intrinsics.checkNotNull((Object)elementsViewState);
            StructureViewSelectInTarget.CUSTOM_STRUCTURE_VIEW_KEY.set((UserDataHolder)elementsViewState.getVirtualFile$intellij_js_liveEdit(), null);
            ElementsViewState elementsViewState2 = this.state;
            Intrinsics.checkNotNull((Object)elementsViewState2);
            LiveEditElementPreviewProvider.CUSTOM_HIGHLIGHT_EXECUTOR_KEY.set((UserDataHolder)elementsViewState2.getPsiFile$intellij_js_liveEdit(), null);
            this.state = null;
            AppUIUtil.invokeOnEdt(() -> ElementsView.dispose$lambda$14(this, editor));
        }
    }

    private final void clearQueueAndState() {
        block0: {
            this.setDocumentId$intellij_js_liveEdit(-1);
            this.updateQueue.clear();
            Int2ObjectOpenHashMap<RangeMarker> int2ObjectOpenHashMap = this.state;
            if (int2ObjectOpenHashMap == null || (int2ObjectOpenHashMap = int2ObjectOpenHashMap.getNodeIdToRangeMarker$intellij_js_liveEdit()) == null) break block0;
            int2ObjectOpenHashMap.clear();
        }
    }

    private static final Unit _init_$lambda$1(Vm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        ((WipVm)vm).getCommandProcessor().send((Request)DOMKt.Enable$default(null, (int)1, null));
        ((WipVm)vm).getCommandProcessor().send((Request)OverlayKt.Enable());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2(ElementsView this$0, DomContentEventFiredEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.initAndLoadDocument();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ElementsView this$0, ConnectionState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getStatus() == ConnectionStatus.CONNECTED) {
            if (this$0.commandProcessor == null) {
                VmConnection<Vm> vmConnection = this$0.connection;
                Intrinsics.checkNotNull(vmConnection);
                Vm vm = vmConnection.getVm();
                Intrinsics.checkNotNull((Object)vm, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                WipCommandProcessor wipCommandProcessor = this$0.commandProcessor = ((WipVm)vm).getCommandProcessor();
                Intrinsics.checkNotNull((Object)wipCommandProcessor);
                wipCommandProcessor.getEventMap().add((EventType)DomContentEventFiredEventData.TYPE, arg_0 -> ElementsView.lambda$3$lambda$2(this$0, arg_0));
            }
        } else if (it.getStatus() != ConnectionStatus.WAITING_FOR_CONNECTION) {
            this$0.connection = null;
            this$0.finder = null;
        }
        return Unit.INSTANCE;
    }

    private static final Unit addDomChangeListeners$lambda$4(ElementsView this$0, DocumentUpdatedEventData it) {
        this$0.reloadDocument();
        return Unit.INSTANCE;
    }

    private static final Unit addDomChangeListeners$lambda$5(ElementsView this$0, NodeIdentifiable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateQueue.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit addDomChangeListeners$lambda$6(ElementsView this$0, ChildNodeInsertedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateQueue.childNodeInserted(it);
        return Unit.INSTANCE;
    }

    private static final Unit addDomChangeListeners$lambda$7(ElementsView this$0, InlineStyleInvalidatedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateQueue.inlineStyleInvalidated(it.nodeIds());
        return Unit.INSTANCE;
    }

    private static final Unit addDomChangeListeners$lambda$8(ElementsView this$0, SetChildNodesEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateQueue.childNodesSet(it);
        return Unit.INSTANCE;
    }

    private static final Unit loadDocument$lambda$9(ElementsView this$0, GetDocumentResult result) {
        CharSequence charSequence = result.root().getDocumentURL();
        if (charSequence == null || charSequence.length() == 0) {
            return Unit.INSTANCE;
        }
        StringBuilder builder = new StringBuilder();
        Int2ObjectOpenHashMap nodeIdToOffset = new Int2ObjectOpenHashMap();
        List list = result.root().getChildren();
        Intrinsics.checkNotNull((Object)list);
        this$0.buildStringRepresentation$intellij_js_liveEdit(list, builder, (Int2ObjectMap<Segment>)((Int2ObjectMap)nodeIdToOffset), false);
        if (this$0.state == null) {
            this$0.createEditor(builder, (Int2ObjectMap<Segment>)((Int2ObjectMap)nodeIdToOffset));
        } else {
            ElementsViewState elementsViewState = this$0.state;
            Intrinsics.checkNotNull((Object)elementsViewState);
            elementsViewState.loadDocument(builder, (Int2ObjectMap<Segment>)((Int2ObjectMap)nodeIdToOffset));
        }
        return Unit.INSTANCE;
    }

    private static final void loadDocument$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createEditor$lambda$11(ElementsView this$0, VirtualFile $realFile, XmlFile $psiFile) {
        PsiFile originalFile = PsiManager.getInstance((Project)this$0.project).findFile($realFile);
        if (originalFile != null) {
            Intrinsics.checkNotNull((Object)$psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            ((PsiFileImpl)$psiFile).setOriginalFile(originalFile);
        }
    }

    private static final void createEditor$lambda$12(ElementsViewState $state, Int2ObjectMap $nodeIdToOffset) {
        try {
            $state.createPointers$intellij_js_liveEdit((Int2ObjectMap<Segment>)$nodeIdToOffset, 0);
            Object[] objectArray = new TextRange[1];
            Intrinsics.checkNotNullExpressionValue((Object)$state.getPsiFile$intellij_js_liveEdit().getTextRange(), (String)"getTextRange(...)");
            $state.scheduleReformat$intellij_js_liveEdit(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ElementsView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(e);
            throw e;
        }
    }

    private static final void createEditor$lambda$13(ElementsView this$0, LightVirtualFile $virtualFile, XmlFile $psiFile) {
        FileEditor fileEditor = TextEditorProvider.Companion.getInstance().createEditor(this$0.project, (VirtualFile)$virtualFile);
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        TextEditor textEditor = this$0.textEditor = (TextEditor)fileEditor;
        Intrinsics.checkNotNull((Object)textEditor);
        Editor editor = textEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).setRendererMode(true);
        StructureViewSelectInTarget.CUSTOM_STRUCTURE_VIEW_KEY.set((UserDataHolder)$virtualFile, (Object)this$0.inspectorStructureViewWrapper);
        this$0.inspectorStructureViewWrapper.setTextEditor(this$0.textEditor);
        this$0.highlightExecutor = new InspectorElementHighlightExecutor(this$0);
        LiveEditElementPreviewProvider.CUSTOM_HIGHLIGHT_EXECUTOR_KEY.set((UserDataHolder)$psiFile, (Object)this$0.highlightExecutor);
        ElementHighlightExecutor elementHighlightExecutor = this$0.highlightExecutor;
        Intrinsics.checkNotNull((Object)elementHighlightExecutor, (String)"null cannot be cast to non-null type com.jetbrains.liveEdit.elementsInspector.InspectorElementHighlightExecutor");
        this$0.addElementHighlighter((InspectorElementHighlightExecutor)elementHighlightExecutor);
        JPanel jPanel = this$0.editorWrapper;
        TextEditor textEditor2 = this$0.textEditor;
        Intrinsics.checkNotNull((Object)textEditor2);
        jPanel.add((Component)textEditor2.getComponent(), "Center");
        this$0.editorWrapper.revalidate();
        this$0.editorWrapper.repaint();
    }

    private static final void dispose$lambda$14(ElementsView this$0, TextEditor $editor) {
        this$0.editorWrapper.removeAll();
        TextEditorProvider.Companion.getInstance().disposeEditor((FileEditor)$editor);
    }

    public static final /* synthetic */ ElementHighlightExecutor access$getHighlightExecutor$p(ElementsView $this) {
        return $this.highlightExecutor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView$ActualDomElementHighlighterOnCaretChange;", "Lcom/jetbrains/liveEdit/highlighting/ElementHighlighterOnCaretChangeBase;", "highlightExecutor", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "<init>", "(Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;)V", "run", "", "intellij.js.liveEdit"})
    private final class ActualDomElementHighlighterOnCaretChange
    extends ElementHighlighterOnCaretChangeBase {
        public ActualDomElementHighlighterOnCaretChange(InspectorElementHighlightExecutor highlightExecutor) {
            Intrinsics.checkNotNullParameter((Object)highlightExecutor, (String)"highlightExecutor");
            super(highlightExecutor);
        }

        @Override
        public void run() {
            if (!this.highlightExecutor.isHighlightingNeed()) {
                return;
            }
            TextEditor textEditor = ElementsView.this.getTextEditor$intellij_js_liveEdit();
            Intrinsics.checkNotNull((Object)textEditor);
            this.highlightExecutor.highlight(textEditor.getEditor(), ElementsView.this.getProject$intellij_js_liveEdit(), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView$ElementsRunnerContentProvider;", "Lcom/intellij/javascript/debugger/RunnerContentProvider;", "<init>", "()V", "registerContent", "", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "tabIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "domPresentationProvider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "elementsView", "Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;", "intellij.js.liveEdit"})
    private static final class ElementsRunnerContentProvider
    implements RunnerContentProvider {
        public void registerContent(@NotNull RunnerLayoutUi ui, @NotNull JavaScriptDebugProcess<? extends VmConnection<Vm>> debugProcess, @NotNull AtomicInteger tabIdCounter) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
                Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
                Intrinsics.checkNotNullParameter((Object)tabIdCounter, (String)"tabIdCounter");
                if (!debugProcess.getElementsInspectorEnabled()) {
                    return;
                }
                int tabId = tabIdCounter.incrementAndGet();
                ui.getDefaults().initTabDefaults(tabId, LiveEditBundle.message("view.elements", new Object[0]), HtmlFileType.INSTANCE.getIcon());
                VmConnection vmConnection = debugProcess.getConnection();
                Project project = debugProcess.getSession().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ElementsView elementsView = new ElementsView((VmConnection<Vm>)vmConnection, project, debugProcess.getFinder());
                Disposer.register((Disposable)((Disposable)ui.getContentManager()), (Disposable)elementsView);
                Content content = ui.createContent("wi.structureView", (JComponent)elementsView.inspectorStructureViewWrapper.getComponent(), LiveEditBundle.message("view.structure", new Object[0]), HtmlFileType.INSTANCE.getIcon(), null);
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
                Content structureViewContent = content;
                structureViewContent.setCloseable(false);
                ui.addContent(structureViewContent, tabId, PlaceInGrid.left, false);
                Content content2 = ui.createContent("wi.textView", (JComponent)elementsView.editorWrapper, LiveEditBundle.message("view.text", new Object[0]), null, null);
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
                Content elementsViewContent = content2;
                elementsViewContent.setCloseable(false);
                ui.addContent(elementsViewContent, tabId, PlaceInGrid.center, false);
                ConsoleView consoleView = debugProcess.getJSConsoleView(false);
                WebConsoleView webConsoleView = consoleView instanceof WebConsoleView ? (WebConsoleView)consoleView : null;
                if (webConsoleView == null) break block1;
                webConsoleView.setDOMViewHandler(this.domPresentationProvider(elementsView));
            }
        }

        private final WebConsoleView.DOMPresentationProvider domPresentationProvider(ElementsView elementsView) {
            return new WebConsoleView.DOMPresentationProvider(elementsView){
                final /* synthetic */ ElementsView $elementsView;
                {
                    this.$elementsView = $elementsView;
                }

                public Promise<ItemPresentation> getNodePresentation(Value v) {
                    WipCommandProcessor wipCommandProcessor;
                    block3: {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            wipCommandProcessor = this.$elementsView.getCommandProcessor$intellij_js_liveEdit();
                            if (wipCommandProcessor == null) break block2;
                            String string = ((SerializableValue)v).getRefId();
                            Intrinsics.checkNotNull((Object)string);
                            if ((wipCommandProcessor = wipCommandProcessor.send((Request)DOMKt.RequestNode((CharSequence)string))) != null && (wipCommandProcessor = wipCommandProcessor.then(arg_0 -> domPresentationProvider.1.getNodePresentation$lambda$1(arg_0 -> domPresentationProvider.1.getNodePresentation$lambda$0(this.$elementsView, arg_0), arg_0))) != null) break block3;
                        }
                        wipCommandProcessor = Promises.rejectedPromise();
                    }
                    return wipCommandProcessor;
                }

                public boolean hasChildren(ItemPresentation node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Collection collection = ((HtmlTagTreeElement)node).getChildrenBase();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildrenBase(...)");
                    return !collection.isEmpty();
                }

                public List<ItemPresentation> getChildren(ItemPresentation node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    List<HtmlTagTreeElement> list = ((HtmlTagTreeElement)node).getChildrenBase().stream().map(arg_0 -> domPresentationProvider.1.getChildren$lambda$3(domPresentationProvider.1::getChildren$lambda$2, arg_0)).toList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                    return list;
                }

                public void highlight(ItemPresentation node) {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        ElementHighlightExecutor elementHighlightExecutor = ElementsView.access$getHighlightExecutor$p(this.$elementsView);
                        boolean bl = elementHighlightExecutor != null ? elementHighlightExecutor.isHighlightingNeed() : false;
                        if (!bl) break block2;
                        TextEditor textEditor = this.$elementsView.getTextEditor$intellij_js_liveEdit();
                        if (textEditor != null && (textEditor = textEditor.getEditor()) != null) {
                            TextEditor textEditor2 = textEditor;
                            ElementsView elementsView = this.$elementsView;
                            TextEditor editor = textEditor2;
                            boolean bl2 = false;
                            ElementHighlightExecutor elementHighlightExecutor2 = ElementsView.access$getHighlightExecutor$p(elementsView);
                            if (elementHighlightExecutor2 != null) {
                                elementHighlightExecutor2.highlight((Editor)editor, elementsView.getProject$intellij_js_liveEdit(), (XmlTag)((HtmlTagTreeElement)node).getElement());
                            }
                        }
                    }
                }

                public void hideHighlight(ItemPresentation node) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        ElementHighlightExecutor elementHighlightExecutor = ElementsView.access$getHighlightExecutor$p(this.$elementsView);
                        boolean bl = elementHighlightExecutor != null ? elementHighlightExecutor.isHighlightingNeed() : false;
                        if (!bl) break block1;
                        ElementHighlightExecutor elementHighlightExecutor2 = ElementsView.access$getHighlightExecutor$p(this.$elementsView);
                        if (elementHighlightExecutor2 != null) {
                            elementHighlightExecutor2.hideHighlight(this.$elementsView.getProject$intellij_js_liveEdit(), (XmlTag)((HtmlTagTreeElement)node).getElement());
                        }
                    }
                }

                private static final ItemPresentation getNodePresentation$lambda$0(ElementsView $elementsView, RequestNodeResult it) {
                    ElementsViewState elementsViewState = $elementsView.getState$intellij_js_liveEdit();
                    return elementsViewState != null ? elementsViewState.buildItemPresentation(it.nodeId()) : null;
                }

                private static final ItemPresentation getNodePresentation$lambda$1(Function1 $tmp0, Object p0) {
                    return (ItemPresentation)$tmp0.invoke(p0);
                }

                private static final HtmlTagTreeElement getChildren$lambda$2(StructureViewTreeElement s) {
                    Intrinsics.checkNotNull((Object)s, (String)"null cannot be cast to non-null type com.intellij.lang.html.structureView.HtmlTagTreeElement");
                    return (HtmlTagTreeElement)s;
                }

                private static final HtmlTagTreeElement getChildren$lambda$3(Function1 $tmp0, Object p0) {
                    return (HtmlTagTreeElement)$tmp0.invoke(p0);
                }
            };
        }
    }
}

