/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.highlighting.ElementHighlightExecutor;
import com.jetbrains.liveEdit.highlighting.LiveEditElementHighlightExecutor;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiveEditElementPreviewProvider
implements ElementPreviewProvider {
    public static final Key<ElementHighlightExecutor> CUSTOM_HIGHLIGHT_EXECUTOR_KEY = Key.create((String)"customHighlightExecutor");
    private final ElementHighlightExecutor highlightExecutor = new LiveEditElementHighlightExecutor();

    public boolean isSupportedFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            LiveEditElementPreviewProvider.$$$reportNull$$$0(0);
        }
        return HtmlUtil.isHtmlFile((PsiElement)psiFile);
    }

    public void show(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Point point, boolean keyTriggered) {
        if (element == null) {
            LiveEditElementPreviewProvider.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            LiveEditElementPreviewProvider.$$$reportNull$$$0(2);
        }
        if (point == null) {
            LiveEditElementPreviewProvider.$$$reportNull$$$0(3);
        }
        Project project = editor.getProject();
        if (keyTriggered || project == null || !LiveEditManager.getInstance().isOperable(project)) {
            return;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        ElementHighlightExecutor customHighlightExecutor = (ElementHighlightExecutor)CUSTOM_HIGHLIGHT_EXECUTOR_KEY.get((UserDataHolder)tag.getContainingFile());
        (customHighlightExecutor == null ? this.highlightExecutor : customHighlightExecutor).highlight(editor, project, tag);
    }

    public void hide(@Nullable PsiElement element, @NotNull Editor editor) {
        Project project;
        if (editor == null) {
            LiveEditElementPreviewProvider.$$$reportNull$$$0(4);
        }
        if ((project = editor.getProject()) == null) {
            return;
        }
        this.highlightExecutor.hideHighlight(project, (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/highlighting/LiveEditElementPreviewProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hide";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

