/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.jsp;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class JspSynchronizer
extends FileBasedSynchronizer {
    JspSynchronizer() {
    }

    @Override
    public boolean canHandle(@NotNull FileType fileType, @NotNull Project project) {
        if (fileType == null) {
            JspSynchronizer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JspSynchronizer.$$$reportNull$$$0(1);
        }
        return fileType.getDefaultExtension().equals("jsp") || fileType.getDefaultExtension().equals("jspx");
    }

    @Override
    protected void sync(@NotNull List<PsiFile> files) {
        if (files == null) {
            JspSynchronizer.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            MostlySingularMultiMap projectToFiles = new MostlySingularMultiMap();
            for (PsiFile file : files) {
                VirtualFile virtualFile = file.isValid() ? file.getVirtualFile() : null;
                if (virtualFile == null) continue;
                projectToFiles.add((Object)file.getProject(), (Object)virtualFile);
            }
            if (projectToFiles.isEmpty()) {
                return;
            }
            for (Project project : projectToFiles.keySet()) {
                SmartList result = new SmartList();
                projectToFiles.processForKey((Object)project, arg_0 -> JspSynchronizer.lambda$sync$0(project, (List)result, arg_0));
                if (result.isEmpty()) continue;
                PackageFileWorker.startPackagingFiles((Project)project, (List)result, (Artifact[])ArtifactManager.getInstance((Project)project).getArtifacts(), (boolean)false).doWhenDone(() -> JobScheduler.getScheduler().schedule(() -> ApplicationInspector.getInstance().reloadPages(project), 2000L, TimeUnit.MILLISECONDS));
            }
        });
    }

    private static /* synthetic */ boolean lambda$sync$0(Project project, List result, VirtualFile file) {
        if (file != null) {
            for (Artifact artifact : ArtifactBySourceFileFinder.getInstance((Project)project).findArtifacts(file)) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result.add(file);
                break;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/jsp/JspSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

