/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.back;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/ConfiguredStatContext;", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "dataFrames", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "transformByAes", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "(Ljava/util/List;Ljava/util/Map;)V", "overallRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "aes", "variable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "overallXRange", "overallYRange", "plot-stem"})
public final class ConfiguredStatContext
implements StatContext {
    @NotNull
    private final List<DataFrame> dataFrames;
    @NotNull
    private final Map<Aes<?>, Transform> transformByAes;

    public ConfiguredStatContext(@NotNull List<DataFrame> dataFrames, @NotNull Map<Aes<?>, ? extends Transform> transformByAes) {
        Intrinsics.checkNotNullParameter(dataFrames, (String)"dataFrames");
        Intrinsics.checkNotNullParameter(transformByAes, (String)"transformByAes");
        this.dataFrames = dataFrames;
        this.transformByAes = transformByAes;
    }

    private final DoubleSpan overallRange(DataFrame.Variable variable, List<DataFrame> dataFrames) {
        DoubleSpan range = null;
        for (DataFrame dataFrame : dataFrames) {
            if (!dataFrame.has(variable)) continue;
            range = SeriesUtil.INSTANCE.span(range, dataFrame.range(variable));
        }
        return range;
    }

    @Override
    @Nullable
    public DoubleSpan overallXRange() {
        return this.overallRange(Aes.Companion.getX());
    }

    @Override
    @Nullable
    public DoubleSpan overallYRange() {
        return this.overallRange(Aes.Companion.getY());
    }

    private final DoubleSpan overallRange(Aes<?> aes2) {
        DoubleSpan doubleSpan;
        Pair ends;
        Pair pair2;
        Transform transform2;
        DataFrame.Variable transformVar = DataFrameUtil.INSTANCE.transformVarFor(aes2);
        Pair<Double, Double> undefinedLimits = new Pair<Double, Double>((Object)Double.NaN, (Object)Double.NaN);
        Pair<Double, Double> transformedLimits = this.transformByAes.containsKey(aes2) ? ((transform2 = (Transform)MapsKt.getValue(this.transformByAes, aes2)) instanceof ContinuousTransform ? ScaleUtil.INSTANCE.transformedDefinedLimits((ContinuousTransform)transform2) : undefinedLimits) : undefinedLimits;
        double limitsLower = ((Number)transformedLimits.component1()).doubleValue();
        double limitsUpper = ((Number)transformedLimits.component2()).doubleValue();
        DoubleSpan dataRange = this.overallRange(transformVar, this.dataFrames);
        if (dataRange != null) {
            double d = limitsLower;
            double lower2 = !Double.isInfinite(d) && !Double.isNaN(d) ? limitsLower : dataRange.getLowerEnd();
            double d2 = limitsUpper;
            double upper2 = !Double.isInfinite(d2) && !Double.isNaN(d2) ? limitsUpper : dataRange.getUpperEnd();
            pair2 = TuplesKt.to((Object)lower2, (Object)upper2);
        } else {
            pair2 = SeriesUtil.INSTANCE.allFinite(limitsLower, limitsUpper) ? TuplesKt.to((Object)limitsLower, (Object)limitsUpper) : null;
        }
        Pair pair3 = ends = pair2;
        if (pair3 != null) {
            Pair it = pair3;
            boolean bl = false;
            doubleSpan = new DoubleSpan(((Number)ends.getFirst()).doubleValue(), ((Number)ends.getSecond()).doubleValue());
        } else {
            doubleSpan = null;
        }
        return doubleSpan;
    }

    @Override
    @NotNull
    public StatContext getFlipped() {
        return StatContext.DefaultImpls.getFlipped(this);
    }
}

