/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSslConfiguration {
    public static final String ELEMENT_NAME = "ssl-config";
    @NotNull
    public String myCaCertPath;
    @NotNull
    public String myClientCertPath;
    @NotNull
    public String myClientKeyPath;
    public boolean myEnabled;
    @NotNull
    public JdbcSettings.SslMode myMode;
    @NotNull
    public LocalDataSource.Storage myPasswordStorage;
    public boolean myUseIdeStore;
    public boolean myUseJavaStore;
    public boolean myUseSystemStore;

    @Deprecated
    public DataSourceSslConfiguration(@NotNull String caCertPath, @NotNull String clientCertPath, @NotNull String clientKeyPath, boolean enabled, @NotNull JdbcSettings.SslMode mode) {
        if (caCertPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(0);
        }
        if (clientCertPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(1);
        }
        if (clientKeyPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(3);
        }
        this(enabled, mode);
        this.myCaCertPath = caCertPath;
        this.myClientCertPath = clientCertPath;
        this.myClientKeyPath = clientKeyPath;
    }

    public DataSourceSslConfiguration(boolean enabled, @NotNull JdbcSettings.SslMode mode) {
        if (mode == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(4);
        }
        this.myCaCertPath = "";
        this.myClientCertPath = "";
        this.myClientKeyPath = "";
        this.myPasswordStorage = LocalDataSource.Storage.PERSIST;
        this.myEnabled = enabled;
        this.myMode = mode;
    }

    public static boolean equal(@Nullable DataSourceSslConfiguration c1, @Nullable DataSourceSslConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myCaCertPath)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myClientCertPath)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myClientKeyPath)) {
            return false;
        }
        return this.myUseIdeStore && this.myUseJavaStore && this.myUseSystemStore;
    }

    public boolean equalConfiguration(@NotNull DataSourceSslConfiguration cfg) {
        if (cfg == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(5);
        }
        if (this.myEnabled != cfg.myEnabled) {
            return false;
        }
        if (this.myMode != cfg.myMode) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCaCertPath), (CharSequence)StringUtil.nullize((String)cfg.myCaCertPath))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myClientCertPath), (CharSequence)StringUtil.nullize((String)cfg.myClientCertPath))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myClientKeyPath), (CharSequence)StringUtil.nullize((String)cfg.myClientKeyPath))) {
            return false;
        }
        if (this.myPasswordStorage != cfg.myPasswordStorage) {
            return false;
        }
        if (this.myUseIdeStore != cfg.myUseIdeStore) {
            return false;
        }
        if (this.myUseJavaStore != cfg.myUseJavaStore) {
            return false;
        }
        return this.myUseSystemStore == cfg.myUseSystemStore;
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer2) {
        if (serializer2 == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(6);
        }
        serializer2.startNode(ELEMENT_NAME);
        LocalDataSourceSerialization.writeTag(serializer2, "ca-cert", this.myCaCertPath);
        LocalDataSourceSerialization.writeTag(serializer2, "client-cert", this.myClientCertPath);
        LocalDataSourceSerialization.writeTag(serializer2, "client-key", this.myClientKeyPath);
        LocalDataSourceSerialization.writeTag(serializer2, "enabled", Boolean.toString(this.myEnabled));
        if (this.myMode != JdbcSettings.SslMode.VERIFY_CA) {
            LocalDataSourceSerialization.writeTag(serializer2, "mode", this.myMode.toString());
        }
        if (this.myPasswordStorage != LocalDataSource.Storage.PERSIST) {
            LocalDataSourceSerialization.writeTag(serializer2, "password-storage", this.myPasswordStorage.toString());
        }
        if (this.myUseIdeStore) {
            serializer2.addAttribute("use-ide-store", "true");
        }
        if (this.myUseJavaStore) {
            serializer2.addAttribute("use-java-store", "true");
        }
        if (this.myUseSystemStore) {
            serializer2.addAttribute("use-system-store", "true");
        }
        serializer2.endNode();
    }

    @Nullable
    public static DataSourceSslConfiguration deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(7);
        }
        DataSourceSslConfiguration cfg = new DataSourceSslConfiguration(false, JdbcSettings.SslMode.VERIFY_CA);
        String useIdeStore = reader.getAttribute("use-ide-store");
        String useJavaStore = reader.getAttribute("use-java-store");
        String useSystemStore = reader.getAttribute("use-system-store");
        cfg.myUseIdeStore = "true".equals(useIdeStore);
        cfg.myUseJavaStore = "true".equals(useJavaStore);
        cfg.myUseSystemStore = "true".equals(useSystemStore);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name2 = reader.getNodeName();
            String value = reader.getValue();
            if ("ca-cert".equals(name2)) {
                cfg.myCaCertPath = value;
            } else if ("client-cert".equals(name2)) {
                cfg.myClientCertPath = value;
            } else if ("client-key".equals(name2)) {
                cfg.myClientKeyPath = value;
            } else if ("enabled".equals(name2)) {
                cfg.myEnabled = Boolean.parseBoolean(value);
            } else if ("mode".equals(name2)) {
                cfg.myMode = JdbcSettings.SslMode.valueOf((String)value);
            } else if ("password-storage".equals(name2)) {
                cfg.myPasswordStorage = LocalDataSource.Storage.valueOf(value);
            }
            reader.moveUp();
        }
        return cfg.isEmpty() ? null : cfg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caCertPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientCertPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientKeyPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSslConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "equalConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

