/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.dialects.redis.RedisDvStructureExtensionKt;
import com.intellij.database.dialects.redis.RedisTree;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/redis/RedisFamilyTree;", "", "family", "Lcom/intellij/database/model/families/Family;", "Lcom/intellij/database/model/basic/BasicElement;", "delimiter", "", "<init>", "(Lcom/intellij/database/model/families/Family;Ljava/lang/String;)V", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "getSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/model/families/HostFamily;", "getFamily", "()Lcom/intellij/database/model/families/HostFamily;", "tree", "Lcom/intellij/database/dialects/redis/RedisTree;", "Lcom/intellij/database/model/basic/BasicNode;", "getTree", "()Lcom/intellij/database/dialects/redis/RedisTree;", "topNodes", "", "getTopNodes", "()Ljava/util/List;", "getDelimiter", "()Ljava/lang/String;", "intellij.database.dialects.redis"})
final class RedisFamilyTree {
    @NotNull
    private final BasicSchema schema;
    @NotNull
    private final HostFamily<? extends BasicElement> family;
    @NotNull
    private final RedisTree<BasicNode> tree;
    @NotNull
    private final List<BasicNode> topNodes;
    @NotNull
    private final String delimiter;

    @NotNull
    public final BasicSchema getSchema() {
        return this.schema;
    }

    @NotNull
    public final HostFamily<? extends BasicElement> getFamily() {
        return this.family;
    }

    @NotNull
    public final RedisTree<BasicNode> getTree() {
        return this.tree;
    }

    @NotNull
    public final List<BasicNode> getTopNodes() {
        return this.topNodes;
    }

    @NotNull
    public final String getDelimiter() {
        return this.delimiter;
    }

    public RedisFamilyTree(@NotNull Family<? extends BasicElement> family, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter(family, (String)"family");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        this.delimiter = delimiter;
        this.family = (HostFamily)family;
        BasicSchema basicSchema = ((HostFamily)family).getHost().getSchema();
        Intrinsics.checkNotNull((Object)basicSchema);
        this.schema = basicSchema;
        this.tree = ((HostFamily)family).isEmpty() ? RedisDvStructureExtensionKt.getEmptyTree() : RedisDvStructureExtensionKt.growTree(this.schema, (HostFamily)family, delimiter);
        this.topNodes = this.tree.getTopNodes();
    }
}

